function [codons_list,reads_codons,norm_codon_occupancy,n_gene] = compute_codon_usage(data_dir,file_name,species,codon_size,buffer,winsor_cut,density_thresh)


%% start by getting the basic information about codons and their synonyms. 
[codons_list, ~, synonymous_codons] = get_codon_dictionary();


%% get gene data and ribosome profiling data
if strcmp(species,'bsub')
    [start_forward, stop_forward, genes_f, ...
        start_reverse, stop_reverse, genes_r] = get_bsub_genes();
    genome = get_bsub_genome();
elseif strcmp(species,'ecoli')
    [start_forward, stop_forward, genes_f, ...
        start_reverse, stop_reverse, genes_r] = get_ecoli_genes();
    genome = get_ecoli_genome();
end
genome_size = length(genome);      
data = zeros(genome_size,2);
% index key:
% 1: forward
% 2: reverse
counts = extract_RNA_seq_data(file_name,data_dir,genome_size);
data(:,1) = counts(1,:);
data(:,2) = counts(2,:);

disp('Done extracting data.')

%% codon reads
 [reads_codons,norm_codon_occupancy,n_gene] = compute_reads_codons(data,genome,codon_size,buffer,codons_list,winsor_cut,...
    start_forward,stop_forward,start_reverse,stop_reverse,density_thresh);
disp('Done reading codons.')

% %% reference set
% RSCU = zeros(length(codons_list),1);
% for i = 1:length(codons_list)
%     RSCU(i) = reads_codons(i)/mean(reads_codons(synonymous_codons(i).names));
% end
% 
% 
% %% computing the CAI
% genes = [genes_f; genes_r];
% strand = [ones(length(genes_f),1); zeros(length(genes_r),1)];
% stop_codons = {'TAA','TAG','TGA'};
% 
% CAI = compute_CAI_genes(genes,genome,codons_list,synonymous_codons,strand,RSCU,...
%     start_forward,stop_forward,start_reverse,stop_reverse,...
%     codon_size,stop_codons);
% 
%    



