function [genes, gene_length,read_density, median_reads,reads_per_gene, ...
    rescaled_reads_per_gene, winsorized_read_density, winsorized_reads_per_gene, ...
    winsorized_rescaled_reads_per_gene, winsorized_median_reads, non_rRNA_raw_reads, all_raw_reads,...
    bootstrap_winsorized_read_density,bootstrap_rescaled_reads_per_gene] = ...
    compute_read_density_20200218(data_dir,files_names,gap,winsor_cut,ribo_bool,n_boot,species)

% gene information
if strcmp(species,'bsub')
    genome_size = 4215606;      % B. subtilis
    [start_forward, stop_forward, genes_f, start_reverse, stop_reverse, genes_r] = get_bsub_genes();
    
    genes = [genes_f; genes_r];
%     
elseif strcmp(species,'bsub_detailed')
    [genes, strand, start, stop] = get_bsub_genes_detailed();
    genome_size = 4215606;      % B. subtilis

    genes_f = genes(strand==1);
    genes_r = genes(strand==0);
    genes = [genes_f; genes_r];
    start_forward = start(strand==1);
    start_reverse = start(strand==0);
    stop_forward = stop(strand==1);
    stop_reverse = stop(strand==0);
    
elseif strcmp(species,'ecoli')
    [start_forward, stop_forward, genes_f, start_reverse, stop_reverse, genes_r] = get_ecoli_genes();
    genome_size = length(get_ecoli_genome);
    genes = [genes_f; genes_r];

elseif strcmp(species,'bsub_dCas9_lacA')
    
    genome_size = 8569;
    start_forward = [2069 6871];
    stop_forward = [6075 7608];
    genes_f = {'dCas9'; 'ermB'};
    
    start_reverse = 629;
    stop_reverse = 1753;
    genes_r = {'xylR'};
    
    genes = [genes_f; genes_r];

elseif strcmp(species,'vnat1')
    [genes, strand, start, stop, chr] = get_vnat_genes();
    genome_size = length(get_vnat1_genome());
    
    genes = genes(chr==1);
    strand = strand(chr==1);
    start = start(chr==1);
    stop = stop(chr==1);
    
    genes_f = genes(strand==1)';
    genes_r = genes(strand==0)';
    genes = [genes_f; genes_r];
    
    start_forward = start(strand==1);
    start_reverse = start(strand==0);
    
    stop_forward = stop(strand==1);
    stop_reverse = stop(strand==0);
    
    
elseif strcmp(species,'vnat2')
    
    [genes, strand, start, stop, chr] = get_vnat_genes();
    genome_size = length(get_vnat1_genome());
    
    genes = genes(chr==2);
    strand = strand(chr==2);
    start = start(chr==2);
    stop = stop(chr==2);
    
    genes_f = genes(strand==1)';
    genes_r = genes(strand==0)';
    genes = [genes_f; genes_r];
    
    start_forward = start(strand==1);
    start_reverse = start(strand==0);
    
    stop_forward = stop(strand==1);
    stop_reverse = stop(strand==0);
    
    
elseif strcmp(species,'caulo')
    [genes, strand, start, stop] = get_caulobacter_genes();
    genome_size = length(get_caulobacter_genome());
    
    
    genes_f = genes(strand==1)';
    genes_r = genes(strand==0)';
    genes = [genes_f; genes_r];
    
    start_forward = start(strand==1);
    start_reverse = start(strand==0);
    
    stop_forward = stop(strand==1);
    stop_reverse = stop(strand==0);
    
    
end

% index key (for mRNA)
% 1: 3' forward
% 2: 3' reverse
% 3: 5' forward
% 4: 5' reverse

% index key (for ribosome profiling)
% 1: forward
% 2: reverse

tic
if ~ribo_bool   % mRNA data
    data = zeros(length(files_names),genome_size,4);
    for i = 1:length(files_names)
        
        counts = extract_RNA_seq_data(files_names{i},data_dir,genome_size);
        data(i,:,1) = counts(1,:);
        data(i,:,2) = counts(2,:);
        data(i,:,3) = counts(3,:);
        data(i,:,4) = counts(4,:);
      
    end
else
    data = zeros(length(files_names),genome_size,2);
    for i = 1:length(files_names)

        counts = extract_RNA_seq_data(files_names{i},data_dir,genome_size);
        data(i,:,1) = counts(1,:);
        data(i,:,2) = counts(2,:);
        toc
    end
end


% all reads
all_raw_reads = zeros(length(files_names),1);
for i = 1:length(files_names)
    all_raw_reads(i) = sum(data(i,:,1)) + sum(data(i,:,2));
end

% remove rRNA and tRNA.
buffer = 50;
data = remove_rRNA_tRNA(data,buffer,species);

% normalization by the total (non rRNA/tRNA) number of reads
non_rRNA_raw_reads = zeros(length(files_names),1);
for i = 1:length(files_names)
   non_rRNA_raw_reads(i) =  sum(data(i,:,1)) + sum(data(i,:,2));
end
reads = non_rRNA_raw_reads/1E6; %/mean(non_rRNA_raw_reads);
% reads = non_rRNA_raw_reads/1E1; %/mean(non_rRNA_raw_reads);



% total reads per gene and read density. 
reads_per_gene = NaN(length(files_names),length(start_forward)+length(start_reverse));
rescaled_reads_per_gene = NaN(length(files_names),length(start_forward)+length(start_reverse));
gene_length = NaN(length(start_forward)+length(start_reverse),1);

read_density = NaN(length(files_names),length(start_forward)+length(start_reverse));
median_reads = NaN(length(files_names),length(start_forward)+length(start_reverse));

winsorized_reads_per_gene = NaN(length(files_names),length(start_forward)+length(start_reverse));
winsorized_rescaled_reads_per_gene = NaN(length(files_names),length(start_forward)+length(start_reverse));

winsorized_read_density = NaN(length(files_names),length(start_forward)+length(start_reverse));
winsorized_median_reads = NaN(length(files_names),length(start_forward)+length(start_reverse));

bootstrap_winsorized_read_density = NaN(length(files_names),length(start_forward)+length(start_reverse),n_boot);
bootstrap_rescaled_reads_per_gene = NaN(length(files_names),length(start_forward)+length(start_reverse),n_boot);

tic
for i = 1:length(files_names)
    for j = 1:length(start_forward)
        
        if ~isempty((start_forward(j)+gap):(stop_forward(j)-gap))
            
            reads_gene = data(i,(start_forward(j)+gap):(stop_forward(j)-gap),1);
            winsorized_reads_gene = winsorize(reads_gene,winsor_cut);

            size_count = length((start_forward(j)+gap):(stop_forward(j)-gap));
            size_gene = length(start_forward(j):stop_forward(j));
            gene_length(j) = size_gene;
            
            reads_per_gene(i,j) = sum(reads_gene);
            rescaled_reads_per_gene(i,j) = sum(reads_gene)*size_gene/size_count;
            
            [~, bootstrap_reads_per_gene] = simple_bootstrap_sum(reads_gene,n_boot);
            bootstrap_rescaled_reads_per_gene(i,j,:) = bootstrap_reads_per_gene*size_gene/size_count;
            
            winsorized_reads_per_gene(i,j) = sum(winsorized_reads_gene);
            winsorized_rescaled_reads_per_gene(i,j) = sum(winsorized_reads_gene)*size_gene/size_count;
            
%             [~, bootstrap_winsorized_read_density(i,j,:)] = simple_bootstrap_2(winsorized_reads_gene/reads(i),n_boot);
            
            
            read_density(i,j) = mean(reads_gene)/reads(i)*1000;
            median_reads(i,j) = median(reads_gene)/reads(i);
            
            winsorized_read_density(i,j) = mean(winsorized_reads_gene)/reads(i)*1000;
            winsorized_median_reads(i,j) = median(winsorized_reads_gene)/reads(i);

            
        
            
            
            
%             if mod(j,1000)==0
%                 toc
%             end
            
                       
        end
    end
    
    for j = 1:length(start_reverse)
        
        
       
        if ~isempty((start_reverse(j)+gap):(stop_reverse(j)-gap))
            
            size_count = length((start_reverse(j)+gap):(stop_reverse(j)-gap));
            size_gene = length(start_reverse(j):stop_reverse(j));
            gene_length(length(start_forward)+j) = size_gene;
            
            reads_gene = data(i,(start_reverse(j)+gap):(stop_reverse(j)-gap),2);
            winsorized_reads_gene = winsorize(reads_gene,winsor_cut);
            
            
            reads_per_gene(i,length(start_forward)+j) = sum(reads_gene);
            rescaled_reads_per_gene(i,length(start_forward)+j) = sum(reads_gene)*size_gene/size_count;
            
            
            [~, bootstrap_reads_per_gene] = simple_bootstrap_sum(reads_gene,n_boot);
            bootstrap_rescaled_reads_per_gene(i,length(start_forward)+j,:) = bootstrap_reads_per_gene*size_gene/size_count;
            
            
            winsorized_reads_per_gene(i,length(start_forward)+j) = sum(winsorized_reads_gene);
            winsorized_rescaled_reads_per_gene(i,length(start_forward)+j) = sum(winsorized_reads_gene)*size_gene/size_count;

            
            read_density(i,length(start_forward)+j) = mean(reads_gene)/reads(i)*1000;
            winsorized_read_density(i,length(start_forward)+j) = mean(winsorized_reads_gene)/reads(i)*1000;
            
            [~, bootstrap_winsorized_read_density(i,length(start_forward)+j,:)] = simple_bootstrap_2(winsorized_reads_gene/reads(i),n_boot);
            
            
            
            
%             if 3735 == (length(start_forward)+j)
%                bla
%             end

            
%             if mod(j,1000)==0
%                 toc
%             end
        end
    end
    toc
end


