function tRNA_synthetase = get_synthetase_data()

%% first get the name and stoichiometry.

tRNA_synthetase = [];
counter = 1;

tRNA_synthetase{counter}.aa_name = 'Ala';
tRNA_synthetase{counter}.name_coli = {'alaS'};
tRNA_synthetase{counter}.name_bsub = {'alaS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Arg';
tRNA_synthetase{counter}.name_coli = {'argS'};
tRNA_synthetase{counter}.name_bsub = {'argS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Asn';
tRNA_synthetase{counter}.name_coli = {'asnS'};
tRNA_synthetase{counter}.name_bsub = {'asnC'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Asp';
tRNA_synthetase{counter}.name_coli = {'aspS'};
tRNA_synthetase{counter}.name_bsub = {'aspS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Cys';
tRNA_synthetase{counter}.name_coli = {'cysS'};
tRNA_synthetase{counter}.name_bsub = {'cysS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Gln';
tRNA_synthetase{counter}.name_coli = {'glnS'};
tRNA_synthetase{counter}.name_bsub = {'gltX'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Glu';
tRNA_synthetase{counter}.name_coli = {'gltX'};
tRNA_synthetase{counter}.name_bsub = {'gltX'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Gly';
tRNA_synthetase{counter}.name_coli = {'glyS','glyQ'};
tRNA_synthetase{counter}.name_bsub = {'glyS','glyQ'};
tRNA_synthetase{counter}.stoichiometry = [2 2];
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'His';
tRNA_synthetase{counter}.name_coli = {'hisS'};
tRNA_synthetase{counter}.name_bsub = {'hisS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Ile';
tRNA_synthetase{counter}.name_coli = {'ileS'};
tRNA_synthetase{counter}.name_bsub = {'ileS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Leu';
tRNA_synthetase{counter}.name_coli = {'leuS'};
tRNA_synthetase{counter}.name_bsub = {'leuS'};
tRNA_synthetase{counter}.name_vnat = {'leuS'};
tRNA_synthetase{counter}.name_caulo = {'CCNA_03865'};

tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Lys';
tRNA_synthetase{counter}.name_coli = {'lysS'};
tRNA_synthetase{counter}.name_bsub = {'lysS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Met';
tRNA_synthetase{counter}.name_coli = {'metG'};
tRNA_synthetase{counter}.name_bsub = {'metS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;


tRNA_synthetase{counter}.aa_name = 'Phe';
tRNA_synthetase{counter}.name_coli = {'pheS','pheT'};
tRNA_synthetase{counter}.name_bsub = {'pheS','pheT'};
tRNA_synthetase{counter}.stoichiometry = [2 2];
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Pro';
tRNA_synthetase{counter}.name_coli = {'proS'};
tRNA_synthetase{counter}.name_bsub = {'proS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Ser';
tRNA_synthetase{counter}.name_coli = {'serS'};
tRNA_synthetase{counter}.name_bsub = {'serS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Thr';
tRNA_synthetase{counter}.name_coli = {'thrS'};
tRNA_synthetase{counter}.name_bsub = {'thrS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Trp';
tRNA_synthetase{counter}.name_coli = {'trpS'};
tRNA_synthetase{counter}.name_bsub = {'trpS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Tyr';
tRNA_synthetase{counter}.name_coli = {'tyrS'};
tRNA_synthetase{counter}.name_bsub = {'tyrS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Val';
tRNA_synthetase{counter}.name_coli = {'valS'};
tRNA_synthetase{counter}.name_bsub = {'valS'};
tRNA_synthetase{counter}.stoichiometry = 1;


%% then get the levels

[coli_syn,bsub_syn] = get_gene_synonyms();

for i = 1:length(tRNA_synthetase)
   [coli_levels, ~, ~] = get_protein_levels_v3(tRNA_synthetase{i}.name_coli,coli_syn,'ecoli, MOPS complete');
   tRNA_synthetase{i}.level_coli_subunit = coli_levels;
   tRNA_synthetase{i}.level_coli = mean(coli_levels./tRNA_synthetase{i}.stoichiometry);
   
   [bsub_levels, ~, ~] = get_protein_levels_v3(tRNA_synthetase{i}.name_bsub,bsub_syn,'bsub');
   tRNA_synthetase{i}.level_bsub_subunit = bsub_levels;
   tRNA_synthetase{i}.level_bsub = mean(bsub_levels./tRNA_synthetase{i}.stoichiometry);
end


%% get total abundance to normalize

total_abundance_coli = 0;
total_abundance_bsub = 0;
for j = 1:length(tRNA_synthetase)
    total_abundance_coli = total_abundance_coli + tRNA_synthetase{j}.level_coli;
    total_abundance_bsub = total_abundance_bsub + tRNA_synthetase{j}.level_bsub;
end

for j = 1:length(tRNA_synthetase)
    tRNA_synthetase{j}.level_coli_norm = tRNA_synthetase{j}.level_coli/total_abundance_coli;
    tRNA_synthetase{j}.level_bsub_norm = tRNA_synthetase{j}.level_bsub/total_abundance_bsub;
end






