function [aligned_reads,rRNA_fraction_low, rRNA_fraction_high, ...
    tRNA_fraction_low, tRNA_fraction_high, all_fraction_low,all_fraction_high] = quantifying_tRNA_rRNA_v2(data_seq_dir,file_name,buffer_window,species)


present_dir = pwd;
if strcmp(species,'bsub')
    cd('/Users/jbl/Dropbox (MIT)/RNA-seq_data/wigs')
    rRNA_ends = xlsread('bsub_168_rRNA.xlsx');
    tRNA_ends = xlsread('bsub_168_tRNA.xlsx');
    genome_size = 4215606;      % B. Subtilis
elseif strcmp(species,'ecoli')
    genome_size = 4639675;      % E. Coli
    
    % updated on 03/17/2017.
    [rRNA_ends, tRNA_ends] = get_rRNA_tRNA_coli_v2();
    
elseif strcmp(species,'CP011495.1')
    
    dir_fasta = '/Users/jbl/Documents/MIT/research/D1/gene_annotations/NCM3722_coli';
    file_fasta = 'CP011495.1.fasta';
    [genome, ~,~] = get_genomes_fna(dir_fasta,file_fasta);
    genome_size = length(genome{1});
    
    
    % see parse_NCM3722_tRNA_rRNA_20190625.m
    tRNA_ends = [...
        3297        3372
        3415        3491
      284956      285032
      412563      412657
      520975      521050
      524412      524488
      524497      524572
      559917      559993
      560052      560127
      560148      560234
      560277      560353
      614683      614759
      614802      614877
      745912      745987
      752928      753003
      753012      753096
      753213      753287
      753294      753369
      787315      787390
      939981      940056
      969790      969865
      969902      969977
      970013      970088
     1074611     1074695
     1182948     1183034
     1183069     1183155
     1183184     1183270
     1443902     1443978
     1444021     1444096
     1447448     1447524
     1455451     1455527
     1480615     1480690
     1503451     1503527
     1770996     1771072
     1900305     1900379
     1900417     1900491
     1900539     1900615
     1900631     1900705
     1900740     1900814
     1900838     1900922
     1900932     1901008
     1984429     1984504
     1984640     1984715
     1984718     1984793
     1984943     1985018
     1985022     1985097
     1985244     1985319
     1985452     1985527
     2179040     2179127
     2284781     2284868
     2350902     2350989
     2540581     2540665
     2540875     2540959
     2999909     2999985
     2999990     3000066
     3251698     3251784
     3251797     3251870
     3251925     3252000
     3303351     3303440
     3304432     3304507
     3317910     3317985
     3319734     3319809
     3322143     3322218
     3526114     3526190
     3706212     3706286
     3758721     3758796
     3758836     3758911
     3761611     3761686
     3761731     3761806
     3761853     3761928
     3761933     3762008
     3970049     3970124
     4027778     4027853
     4059800     4059876
     4060075     4060151
     4060214     4060290
     4060489     4060565
     4060569     4060661
     4189404     4189480
     4189514     4189590
     4189624     4189700
     4241002     4241075
     4352384     4352459
     4465848     4465923
     4568463     4568539
     4572322     4572408
     4672631     4672706
     4676009     4676084
     4676127     4676203];
 
 
 
    rRNA_ends = [...
         9       124
       202      3131
      3548      5103
    519346    520901
    521235    524159
    524242    524357
    613071    614626
    615052    617982
    618059    618174
    744197    745752
    746172    749101
    749179    749294
    785686    787241
    787575    790505
    790583    790698
   1442290   1443845
   1444271   1447200
   1447278   1447393
   3966751   3966866
   3966944   3969873
   3970284   3971839
   4672476   4672591
   4672721   4672836
   4672914   4675843
   4676260   4677815];
    
elseif strcmp(species,'CP011496.1')
    
    rRNA_ends = [];
    tRNA_ends = [];
    genome_size = []; 
    
elseif strcmp(species,'Pmarinus')
    
    % added 05/09/2019 (parse_Pmarinus_tRNA_rRNA_20190509.m)
    tRNA_ends =[...
       65454       65535
      122896      122967
      229473      229554
      249345      249418
      264442      264517
      296377      296452
      305096      305167
      314649      314722
      314735      314807
      368348      368419
      368430      368511
      450064      450137
      450520      450592
      538180      538265
      625757      625846
      776396      776472
      818172      818243
      819740      819813
      861144      861230
      914442      914515
     1020083     1020155
     1063867     1063938
     1071431     1071504
     1115986     1116070
     1143410     1143483
     1208565     1208637
     1252993     1253074
     1258262     1258334
     1274670     1274740
     1306262     1306333
     1469551     1469639
     1489483     1489554
     1502203     1502276
     1516866     1516936
     1533818     1533891
     1570753     1570824
     1617346     1617417];
 
    rRNA_ends = [...
        313061   314525
        315074   317948
        318012   318126];
    
    genome_size = 1657990;
    
    
elseif strcmp(species,'vnat1')
    
    [rRNA_ends, tRNA_ends] = get_rRNA_tRNA_vnat('vnat1');
    genome_size = length(get_vnat1_genome());
    
elseif strcmp(species,'vnat2')
    
    [rRNA_ends, tRNA_ends] = get_rRNA_tRNA_vnat('vnat2');
    genome_size = length(get_vnat2_genome());

elseif strcmp(species,'caulobacter')
    [rRNA_ends, tRNA_ends] = get_rRNA_tRNA_caulo();
    genome_size = length(get_caulobacter_genome());
    
else
    
    disp('Unrecognized species.')
end
cd(present_dir);

% buffered regions.
rRNA_ends_buf = [];
tRNA_ends_buf = [];
rRNA_ends_buf(:,1) = rRNA_ends(:,1)-buffer_window;
tRNA_ends_buf(:,1) = tRNA_ends(:,1)-buffer_window;
rRNA_ends_buf(:,2) = rRNA_ends(:,2)+buffer_window;
tRNA_ends_buf(:,2) = tRNA_ends(:,2)+buffer_window;

rRNA_ends_buf(rRNA_ends_buf(:,1)<0) = 1;
tRNA_ends_buf(tRNA_ends_buf(:,1)<0) = 1;
rRNA_ends_buf(rRNA_ends_buf(:,2)>genome_size) = genome_size;
tRNA_ends_buf(tRNA_ends_buf(:,2)>genome_size) = genome_size;



% extracting the data (using the 3' ends for quantitation). 
try
counts = extract_RNA_seq_data(file_name,data_seq_dir,genome_size);
data_3f = counts(1,:);
data_3r = counts(2,:);
catch
    bla
end


% removal of the rRNA and tRNA regions
data_3f_rRNA_rem_low = data_3f;
data_3f_rRNA_rem_high = data_3f;
data_3f_tRNA_rem_low = data_3f;
data_3f_tRNA_rem_high = data_3f;

data_3r_rRNA_rem_low = data_3r;
data_3r_rRNA_rem_high = data_3r;
data_3r_tRNA_rem_low = data_3r;
data_3r_tRNA_rem_high = data_3r;

data_3r_all_rem_low = data_3r;
data_3r_all_rem_high = data_3r;
data_3f_all_rem_low = data_3f;
data_3f_all_rem_high = data_3f;

for i = 1:length(rRNA_ends)
    excluded_region = rRNA_ends(i,1):rRNA_ends(i,2);
    data_3f_rRNA_rem_low(excluded_region) = 0;
    data_3r_rRNA_rem_low(excluded_region) = 0;
    data_3f_all_rem_low(excluded_region) = 0;
    data_3r_all_rem_low(excluded_region) = 0;
    
    excluded_region_high = rRNA_ends_buf(i,1):rRNA_ends_buf(i,2);
    data_3f_rRNA_rem_high(excluded_region_high) = 0;
    data_3r_rRNA_rem_high(excluded_region_high) = 0;
    data_3f_all_rem_high(excluded_region_high) = 0;
    data_3r_all_rem_high(excluded_region_high) = 0;
    
    
end

for i = 1:length(tRNA_ends)
    excluded_region = tRNA_ends(i,1):tRNA_ends(i,2);
    data_3f_tRNA_rem_low(excluded_region) = 0;
    data_3r_tRNA_rem_low(excluded_region) = 0;
    data_3f_all_rem_low(excluded_region) = 0;
    data_3r_all_rem_low(excluded_region) = 0;
    
    excluded_region_high = tRNA_ends_buf(i,1):tRNA_ends_buf(i,2);
    data_3f_tRNA_rem_high(excluded_region_high) = 0;
    data_3r_tRNA_rem_high(excluded_region_high) = 0;
    data_3f_all_rem_high(excluded_region_high) = 0;
    data_3r_all_rem_high(excluded_region_high) = 0;
end


%%

aligned_reads = sum(data_3f) + sum(data_3r);

% fraction rRNA
rRNA_fraction_low = ((sum(data_3f)+sum(data_3r)-sum(data_3f_rRNA_rem_low)-sum(data_3r_rRNA_rem_low))...
    /(sum(data_3f) + sum(data_3r)));

rRNA_fraction_high = ((sum(data_3f)+sum(data_3r)-sum(data_3f_rRNA_rem_high)-sum(data_3r_rRNA_rem_high))...
    /(sum(data_3f) + sum(data_3r)));


% fraction rRNA
tRNA_fraction_low = ((sum(data_3f)+sum(data_3r)-sum(data_3f_tRNA_rem_low)-sum(data_3r_tRNA_rem_low))...
    /(sum(data_3f) + sum(data_3r)));

tRNA_fraction_high = ((sum(data_3f)+sum(data_3r)-sum(data_3f_tRNA_rem_high)-sum(data_3r_tRNA_rem_high))...
    /(sum(data_3f) + sum(data_3r)));

% fraction all 

all_fraction_low = ((sum(data_3f)+sum(data_3r)-sum(data_3f_all_rem_low)-sum(data_3r_all_rem_low))...
    /(sum(data_3f) + sum(data_3r)));

all_fraction_high = ((sum(data_3f)+sum(data_3r)-sum(data_3f_all_rem_high)-sum(data_3r_all_rem_high))...
    /(sum(data_3f) + sum(data_3r)));
