function [gene_name,strand, start, stop] = read_gene_annotation_v2(file_name,dir_name)

% line by line reading 
gene_counter = 0;
strand = [];
gene_name = [];
start = [];
stop = [];

curr_dir = pwd;
cd(dir_name);
fid = fopen(file_name);
tline = fgetl(fid);


while ischar(tline) && ~isempty(tline)
%     disp(tline)

    if strcmp(tline(1),'>')
        gene_counter = gene_counter+1;
        
        % getting the gene name
        startIndex = regexp(tline,'gene=')+5;
        stopIndex = regexp(tline,'protein=')-4;
        
        gene_info = tline(startIndex:stopIndex);
        
        % if multiple gene names, pick the first one.
        final_stopIndex = regexp(gene_info,',')-1;
        
        if isempty(final_stopIndex)
            gene_name{gene_counter} = gene_info;
        elseif isempty(gene_info)
            gene_name{gene_counter} = gene_info(1:final_stopIndex);
        else
            gene_name{gene_counter} = sprintf('gene%d',gene_counter);
            i
            break
        end
      
        try
        % getting the strand and position
        startIndex = regexp(tline,'location=complement(')+20;
        if ~isempty(startIndex)
            strand(gene_counter) = 0;
            position_string = tline(startIndex:end);
            position_string(position_string=='.')='-';
           
            ind1 = regexp(position_string,'-->')-1;
            ind1b = regexp(position_string,'--')-1;
            ind2 = regexp(position_string,')')-1;
            
            

            if isempty(ind1)
                start(gene_counter) = str2num(position_string(1:ind1b));
                stop(gene_counter) = str2num(position_string(ind1b+3:ind2));
            else
                start(gene_counter) = str2num(position_string(1:ind1));
                stop(gene_counter) = str2num(position_string(ind1+4:ind2));
            end
            
        else
            strand(gene_counter) = 1;
            startIndex = regexp(tline,'location=')+9;
            position_string = tline(startIndex:end);
            position_string(position_string=='.')='-';

            ind1 = regexp(position_string,'-->')-1;
            ind1b = regexp(position_string,'--')-1;
            ind2 = regexp(position_string,']')-1;

            if isempty(ind1)
                start(gene_counter) = str2num(position_string(1:ind1b));
                stop(gene_counter) = str2num(position_string(ind1b+3:ind2));
            else
                start(gene_counter) = str2num(position_string(1:ind1));
                stop(gene_counter) = str2num(position_string(ind1+4:ind2));
            end
            
            
        end
        catch
            disp('Problem:');
            disp(tline);
        end
    end
    tline = fgetl(fid);
    

end

fclose(fid);
cd(curr_dir)


