%% parameters

codon_size = 3;
buffer_stop = 5;
winsor_cut = 0.01;

density_thresh = 0.01;
length_thresh = 100;


%% Ecoli (MOPS comp)
data_dir =  % path to ribosome profiling data
file_name = 'GSE53767_fp_rdm_pooled*.wig';
species = 'ecoli';
buffer_start = 5;

%%
[genes_by_stop, n_stop,stop_tetra] = translation_properties_stop_tetra(data_dir,file_name,...
    species,codon_size,buffer_start,buffer_stop,winsor_cut,density_thresh,length_thresh);

%%
normalization = 0;
for i = 1:12
    normalization = normalization+ sum(genes_by_stop(i).density);
end

J_UAA = sum([genes_by_stop(1:4).density])/normalization;
J_UGA = sum([genes_by_stop(5:8).density])/normalization;
J_UAG = sum([genes_by_stop(9:12).density])/normalization;

fprintf('J_UAA \t %.3f\n',J_UAA)
fprintf('J_UGA \t %.3f\n',J_UGA)
fprintf('J_UAG \t %.3f\n\n',J_UAG)

for i = 1:length(stop_tetra)
    fprintf('J_%s\t %.3f\t %d\n',strrep(stop_tetra{i},'T','U'),sum(genes_by_stop(i).density)/normalization,n_stop(i));
end
