function [genes, strand, start, stop] = get_bsub_genes_v2()


file_name = 'CDS_168.mochiview_v2.txt';
file_dir = '/Users/jbl/Documents/MIT/research/D1/RNA_seq_annotation/data/b_subtilis';
present_dir = pwd;
cd(file_dir);
fid = fopen(file_name);
test = textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s','HeaderLines',1);
fclose(fid);
cd(present_dir)

start_codon_positions = str2num(char(test{2}));
stop_codon_positions = str2num(char(test{3}));
gene_names = test{6};
gene_strand = test{4};

start_forward = start_codon_positions(strcmp(gene_strand,'+'));
stop_forward = stop_codon_positions(strcmp(gene_strand,'+'));
gene_names_forward = gene_names(strcmp(gene_strand,'+'));
start_reverse = start_codon_positions(strcmp(gene_strand,'-'));
stop_reverse = stop_codon_positions(strcmp(gene_strand,'-'));
gene_names_reverse = gene_names(strcmp(gene_strand,'-'));

genes = [gene_names_forward' gene_names_reverse'];
strand = [ones(length(start_forward),1)' zeros(length(start_reverse),1)'];
start = [start_forward' start_reverse'];
stop = [stop_forward' stop_reverse'];


% manual correction for duplicate names
genes{3186} = 'yrvO';

