function genome = get_genomes(species)



if strcmp(species,'bsub') || strcmp(species,'Bsub')
    genome = get_bsub_genome();
elseif strcmp(species,'ecoli') || strcmp(species,'Ecoli')
    genome = get_ecoli_genome();
elseif strcmp(species,'vnat1') || strcmp(species,'Vnat1')
    genome = get_vnat1_genome();
elseif strcmp(species,'vnat2') || strcmp(species,'Vnat2')
    genome = get_vnat2_genome();
elseif strcmp(species,'caulo') || strcmp(species,'Caulo')
    genome = get_caulobacter_genome();
elseif strcmp(species,'staph')
    genome = get_staph_genome();
elseif strcmp(species,'L_brevis')
    genome = get_L_brevis_genome();
elseif strcmp(species,'B_anthracis')
    genome = get_B_anthracis_genome();
else
    genome = [];
    disp('species not recognized');
end