function [protein_levels, proteome_fraction, footprint_counts] = get_protein_levels_v3(gene_names,gene_synonyms,species)

% extracting data: E. coli MOPS complete.
cur_dir = pwd;
data_dir = % path to file 
cd(data_dir)
file_name = '20161112_Ecoli_protein_levels_proteome_fraction_MOPS_complete.txt';
fid = fopen(file_name);
test = textscan(fid,'%s %f %f','Delimiter','\t');
Ecoli_genes = test{1};
Ecoli_proteins = test{2};
Ecoli_proteome_fraction = test{3};
fclose(fid);
cd(cur_dir);


% extracting data: bsub, LB. 
data_dir = % path to file 
cd(data_dir)

% bacillus subtilis ribosome profiling LB
file_name = '20161125_protein_synthesis_rates_pooled_168_winsorized_prot_frac.txt';


fid = fopen(file_name);
data = textscan(fid,'%s %d %f %f %f','Delimiter','\t','HeaderLines',1);

cd(cur_dir);
Bsub_genes= data{1};
Bsub_ribo_count = data{2};
Bsub_proteins =data{3};
Bsub_proteome_fraction =data{5};
fclose(fid);

if strcmp(species,'bsub')
    genes_prot = Bsub_genes;
    prot_level = Bsub_proteins;
    footprint_reads = Bsub_ribo_count;
    prot_frac = Bsub_proteome_fraction;
elseif strcmp(species,'ecoli, MOPS complete')
    genes_prot = Ecoli_genes;
    prot_level = Ecoli_proteins;
    footprint_reads = NaN(size(Ecoli_proteins));
    prot_frac = Ecoli_proteome_fraction;
end



protein_levels = NaN(size(gene_names));
footprint_counts = NaN(size(gene_names));
proteome_fraction = NaN(size(gene_names));
RNA_levels = NaN(size(gene_names));
RNA_counts = NaN(size(gene_names));
TE = NaN(size(gene_names));

% parsing the list
for i = 1:length(gene_names)
    
    index = strcmp_synonyms(genes_prot,gene_names{i},gene_synonyms,1);
    if isempty(index)

    elseif ~isnan(index) && (length(index)==1)
        protein_levels(i) = prot_level(index);
        footprint_counts(i) = footprint_reads(index);
        proteome_fraction(i) = prot_frac(index);
    elseif length(index)>1
        fprintf(sprintf('Problem, %s, %s.\n',species,gene_names{i}));
    end
end



