
tRNA_synthetase = [];
counter = 1;

tRNA_synthetase{counter}.aa_name = 'Ala';
tRNA_synthetase{counter}.name_coli = {'alaS'};
tRNA_synthetase{counter}.name_bsub = {'alaS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Arg';
tRNA_synthetase{counter}.name_coli = {'argS'};
tRNA_synthetase{counter}.name_bsub = {'argS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Asn';
tRNA_synthetase{counter}.name_coli = {'asnS'};
tRNA_synthetase{counter}.name_bsub = {'asnC'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Asp';
tRNA_synthetase{counter}.name_coli = {'aspS'};
tRNA_synthetase{counter}.name_bsub = {'aspS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Cys';
tRNA_synthetase{counter}.name_coli = {'cysS'};
tRNA_synthetase{counter}.name_bsub = {'cysS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Gln';
tRNA_synthetase{counter}.name_coli = {'glnS'};
tRNA_synthetase{counter}.name_bsub = {'gltX'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Glu';
tRNA_synthetase{counter}.name_coli = {'gltX'};
tRNA_synthetase{counter}.name_bsub = {'gltX'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Gly';
tRNA_synthetase{counter}.name_coli = {'glyS','glyQ'};
tRNA_synthetase{counter}.name_bsub = {'glyS','glyQ'};
tRNA_synthetase{counter}.stoichiometry = [2 2];
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'His';
tRNA_synthetase{counter}.name_coli = {'hisS'};
tRNA_synthetase{counter}.name_bsub = {'hisS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Ile';
tRNA_synthetase{counter}.name_coli = {'ileS'};
tRNA_synthetase{counter}.name_bsub = {'ileS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Leu';
tRNA_synthetase{counter}.name_coli = {'leuS'};
tRNA_synthetase{counter}.name_bsub = {'leuS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Lys';
tRNA_synthetase{counter}.name_coli = {'lysS'};
tRNA_synthetase{counter}.name_bsub = {'lysS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Met';
tRNA_synthetase{counter}.name_coli = {'metG'};
tRNA_synthetase{counter}.name_bsub = {'metS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;


tRNA_synthetase{counter}.aa_name = 'Phe';
tRNA_synthetase{counter}.name_coli = {'pheS','pheT'};
tRNA_synthetase{counter}.name_bsub = {'pheS','pheT'};
tRNA_synthetase{counter}.stoichiometry = [2 2];
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Pro';
tRNA_synthetase{counter}.name_coli = {'proS'};
tRNA_synthetase{counter}.name_bsub = {'proS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Ser';
tRNA_synthetase{counter}.name_coli = {'serS'};
tRNA_synthetase{counter}.name_bsub = {'serS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Thr';
tRNA_synthetase{counter}.name_coli = {'thrS'};
tRNA_synthetase{counter}.name_bsub = {'thrS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Trp';
tRNA_synthetase{counter}.name_coli = {'trpS'};
tRNA_synthetase{counter}.name_bsub = {'trpS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Tyr';
tRNA_synthetase{counter}.name_coli = {'tyrS'};
tRNA_synthetase{counter}.name_bsub = {'tyrS'};
tRNA_synthetase{counter}.stoichiometry = 2;
counter = counter+1;

tRNA_synthetase{counter}.aa_name = 'Val';
tRNA_synthetase{counter}.name_coli = {'valS'};
tRNA_synthetase{counter}.name_bsub = {'valS'};
tRNA_synthetase{counter}.stoichiometry = 1;
counter = counter+1;


%% obtain the gene sizes from annotations
[gene_bsub,strand_bsub,start_bsub,stop_bsub] = get_bsub_genes_v2();
[gene_coli,strand_coli,start_coli,stop_coli] = get_ecoli_genes_v2();

%% get protein size (units of aa)

for i = 1:length(tRNA_synthetase)
    
    for j = 1:length(tRNA_synthetase{i}.name_coli)
        ind_coli = find(strcmp(gene_coli,tRNA_synthetase{i}.name_coli{j}));
        tRNA_synthetase{i}.size_coli(j) = (1+stop_coli(ind_coli)-start_coli(ind_coli))/3;
    end
    tRNA_synthetase{i}.total_size_coli = sum(tRNA_synthetase{i}.size_coli.*tRNA_synthetase{i}.stoichiometry);
    
    for j = 1:length(tRNA_synthetase{i}.name_bsub)
        ind_bsub = find(strcmp(gene_bsub,tRNA_synthetase{i}.name_bsub{j}));
        tRNA_synthetase{i}.size_bsub(j) = (1+stop_bsub(ind_bsub)-start_bsub(ind_bsub))/3;
    end
    tRNA_synthetase{i}.total_size_bsub = sum(tRNA_synthetase{i}.size_bsub.*tRNA_synthetase{i}.stoichiometry);
end



%% get proteome fraction from ribosome profiling data (published in Lalanne et al, 2018 and Li et al, 2014). 

file_name = '20161112_translation_transcription_prot_level_subcoli.txt';
fid = fopen(file_name);
data = textscan(fid,'%s %f %f %f %s %s %f %f %f %f %s %f %s %f %s %f','Delimiter','\t','HeaderLines',1);
fclose(fid);

genes_coli_prot = data{1};
proteome_frac_ecoli = data{4};
proteome_frac_ecoli(isnan(proteome_frac_ecoli)) = 0;

genes_bsub_prot = data{6};
proteome_frac_bsub = data{10};
proteome_frac_bsub(isnan(proteome_frac_bsub)) = 0;

for i = 1:length(tRNA_synthetase)
    
    for j = 1:length(tRNA_synthetase{i}.name_coli)
        ind_coli = find(strcmp(genes_coli_prot,tRNA_synthetase{i}.name_coli{j}));
        if i~=6
            tRNA_synthetase{i}.prot_frac_coli(j) = proteome_frac_ecoli(ind_coli);
        else
            tRNA_synthetase{i}.prot_frac_coli(j) = 0.0012; % this gene not in the data table
        end
    end
    tRNA_synthetase{i}.total_prot_frac_coli = sum(tRNA_synthetase{i}.prot_frac_coli);
    
    for j = 1:length(tRNA_synthetase{i}.name_bsub)
        ind_bsub = find(strcmp(genes_bsub_prot,tRNA_synthetase{i}.name_bsub{j}));
        tRNA_synthetase{i}.prot_frac_bsub(j) = proteome_frac_bsub(ind_bsub);
    end
    tRNA_synthetase{i}.total_prot_frac_bsub = sum(tRNA_synthetase{i}.prot_frac_bsub);
    
    
end


%% estimating size weighted by proteome fraction

% get sizes
sizes_coli = [];
prot_frac_coli = [];
sizes_bsub = [];
prot_frac_bsub = [];
for i = 1:length(tRNA_synthetase)
    sizes_coli(end+1) = tRNA_synthetase{i}.total_size_coli;
    prot_frac_coli(end+1) = tRNA_synthetase{i}.total_prot_frac_coli;
    sizes_bsub(end+1) = tRNA_synthetase{i}.total_size_bsub;
    prot_frac_bsub(end+1) = tRNA_synthetase{i}.total_prot_frac_bsub;

end

mean_size_coli = sum(prot_frac_coli)/sum(prot_frac_coli./sizes_coli);
mean_size_bsub = sum(prot_frac_bsub)/sum(prot_frac_bsub./sizes_bsub);

