function [start_forward, stop_forward, gene_names_forward, ...
    start_reverse, stop_reverse, gene_names_reverse] = get_ecoli_genes()


file_name = 'gffEditedNoDup_v3.txt';
file_dir = '/Users/jbl/Documents/MIT/research/D1/RNA_seq_annotation/data/Jing_RNA_seq_annotation';
present_dir = pwd;
cd(file_dir);
fid = fopen(file_name);
test = textscan(fid,'%s %s %s %s %s %s %s %s %s','HeaderLines',1);
cd(present_dir)
fclose(fid);

start_codon_positions = [];
stop_codon_positions = [];
gene_names = [];

counter = 1;
tic
for i = 1:length(test{1})
    if strcmp(test{3}(i),'CDS')
        temp = test{9}(i);
        temp2 = temp{1}(4:7);
        if strcmp(temp2(4),':') || strcmp(temp2(4),';')
            gene_names{counter} = temp2(1:3);
        else
            gene_names{counter} = temp2(1:4);
        end
        start_codon_positions(counter) = str2num(char(test{4}(i)));
        stop_codon_positions(counter) = str2num(char(test{5}(i)));
        
        gene_strand{counter} = char(test{7}(i));
        counter = counter +1; 

    end
end

start_forward = start_codon_positions(strcmp(gene_strand,'+'))';
stop_forward = stop_codon_positions(strcmp(gene_strand,'+'))';
gene_names_forward = gene_names(strcmp(gene_strand,'+'))';
start_reverse = start_codon_positions(strcmp(gene_strand,'-'))';
stop_reverse = stop_codon_positions(strcmp(gene_strand,'-'))';
gene_names_reverse = gene_names(strcmp(gene_strand,'-'))';