function [rRNA_ends, tRNA_ends] = get_rRNA_tRNA_coli_v2()

%% get the rRNA and tRNA gene names.
% see script commented out below for how I got those. 

rRNA_ends = double([...
         4035542     4038446
     4166664     4169567
     3941727     3944630
     3421902     3424805
     4208066     4210969
     2724303     2727206
      225759      228662
     4033554     4035095
     4164682     4166223
     3939831     3941372
     3425243     3426784
     4206170     4207711
     2727638     2729179
      223771      225312
     4038540     4038659
     4169660     4169779
     3944723     3944842
     3421445     3421564
     4211063     4211182
     3421445     3421564
     2724091     2724210
      228756      228875]);
  
[~,ind] = sort(rRNA_ends(:,1));
rRNA_ends = rRNA_ends(ind,:);

  
tRNA_ends = [...
    4035283     4035358
     3424980     3425055
      225500      225575
     2516063     2516138
     2815806     2815882
      563946      564022
     2815806     2815882
      563946      564022
     3980398     3980474
     2816220     2816296
     2816081     2816157
     2042573     2042648
     2057875     2057950
     2060284     2060359
     2056051     2056126
     3944895     3944971
      228928      229004
      236931      237007
     1989938     1990011
      695979      696053
      695653      695727
      695979      696053
      695653      695727
     4166395     4166470
     3941458     3941533
     4207797     4207872
     2727391     2727466
     4173696     4173770
     2997006     2997079
     4390383     4390458
     1990066     1990141
     4390495     4390570
     4390606     4390681
     3980532     3980608
     4035164     4035240
     3425098     3425174
      225381      225457
     3213620     3213695
     2783784     2783859
     4604223     4604309
     4604338     4604424
     3980629     3980715
     3320094     3320180
     4604102     4604188
      696186      696270
     4494428     4494512
     1989839     1989925
      780800      780875
      779777      779852
     2519275     2519350
      780066      780141
      780370      780445
      780592      780667
      695887      695963
      695887      695963
     2945629     2945705
     2945519     2945595
     3316235     3316311
     2945409     2945485
     4360574     4360649
     3108388     3108463
     3706639     3706715
     2284233     2284309
     3980758     3980834
     3834245     3834339
     1030848     1030935
     2041492     2041581
     2816575     2816667
      925107      925194
     1096788     1096875
     4173777     4173852
     4173411     4173486
     3421602     3421677
      262095      262170
     3944980     3945055
     1286289     1286459
     4173495     4173579
     1286467     1286551
      779988      780063
     2518953     2519028
     1744459     1744535
     1744540     1744616
     2519073     2519148
     2519195     2519270
      780291      780366];
  

[~,ind] = sort(tRNA_ends(:,1));

tRNA_ends = tRNA_ends(ind,:);

% 
% %%
% 
% rRNA_names = {'rrlA','rrlB','rrlC','rrlD','rrlE','rrlG','rrlH',...
%     'rrsA','rrsB','rrsC','rrsD','rrsE','rrsG','rrsH',...
%     'rrfA','rrfB','rrfC','rrfD','rrfE','rrfF','rrfG','rrfH'};
% 
% file_name = 'list_tRNA_gene_names.xls';
% file_dir = '~/Documents/MIT/research/D1/RNA_seq_annotation/data/Jing_RNA_seq_annotation/';
% current_dir = pwd;
% 
% cd(file_dir);
% 
% fid = fopen(file_name);
% content = textscan(fid,'%s %s','Delimiter','\t','HeaderLines',1);
% fclose(fid);
% cd(current_dir);
% 
% tRNA_names = content{1};
% for i = 1:length(tRNA_names)
%     tRNA_names{i} = strrep(tRNA_names{i},'"',''); 
% end
% 
% 
% %% search for the genes in the list, get their position.
% 
% file_name = 'gffEditedNoDup_v2.txt';
% cd(file_dir);
% fid = fopen(file_name);
% content = textscan(fid,'%s %s %s %d %d %s %s %s %s','Delimiter','\t');
% fclose(fid)
% cd(current_dir);
% %%
% 
% tic
% rRNA_ends = zeros(length(rRNA_names),2);
% for j = 1:length(rRNA_names)
%     for i = 1:length(content{1})
%         if regexp(content{end}{i},rRNA_names{j})
%             rRNA_ends(j,1) = content{4}(i);
%             rRNA_ends(j,2) = content{5}(i);
%             toc
%             break
%         end
%     end
% end
% 
% tic
% tRNA_ends = zeros(length(tRNA_names),2);
% for j = 1:length(tRNA_names)
%     for i = 1:length(content{1})
%         if regexp(content{end}{i},tRNA_names{j})
%             tRNA_ends(j,1) = content{4}(i);
%             tRNA_ends(j,2) = content{5}(i);
%             toc
%             break
%         end
%     end
% end
% 
