function tRNA = get_tRNA_data_v2()

% tRNA data. Compiling information from Dong et al, 1996. 

counter = 1;

tRNA = [];

tRNA{counter}.name = 'Ala1B';
tRNA{counter}.codons_recognized = {'GCT','GCA','GCG'};
tRNA{counter}.aa_name = 'Ala';
tRNA{counter}.abundance = 0.4;
counter = counter+1;

tRNA{counter}.name = 'Ala2';
tRNA{counter}.codons_recognized = {'GCC'};
tRNA{counter}.aa_name = 'Ala';
tRNA{counter}.abundance = 0.07;
counter = counter+1;

tRNA{counter}.name = 'Arg2';
tRNA{counter}.codons_recognized = {'CGT','CGC','CGA'};
tRNA{counter}.aa_name = 'Arg';
tRNA{counter}.abundance = 0.49;
counter = counter+1;

tRNA{counter}.name = 'Arg3';
tRNA{counter}.codons_recognized = {'CGG'};
tRNA{counter}.aa_name = 'Arg';
tRNA{counter}.abundance = 0.04;
counter = counter+1;

tRNA{counter}.name = 'Arg4';
tRNA{counter}.codons_recognized = {'AGA'};
tRNA{counter}.aa_name = 'Arg';
tRNA{counter}.abundance = 0.07;
counter = counter+1;

tRNA{counter}.name = 'Arg5';
tRNA{counter}.codons_recognized = {'AGG'};
tRNA{counter}.aa_name = 'Arg';
tRNA{counter}.abundance = 0.04;
counter = counter+1;

tRNA{counter}.name = 'Asn';
tRNA{counter}.codons_recognized = {'AAC','AAT'};
tRNA{counter}.aa_name = 'Asn';
tRNA{counter}.abundance = 0.14;
counter = counter+1;

tRNA{counter}.name = 'Asp1';
tRNA{counter}.codons_recognized = {'GAC','GAT'};
tRNA{counter}.aa_name = 'Asp';
tRNA{counter}.abundance = 0.29;
counter = counter+1;

tRNA{counter}.name = 'Cys';
tRNA{counter}.codons_recognized = {'TGC','TGT'};
tRNA{counter}.aa_name = 'Cys';
tRNA{counter}.abundance = 0.14;
counter = counter+1;

tRNA{counter}.name = 'Gln1';
tRNA{counter}.codons_recognized = {'CAA'};
tRNA{counter}.aa_name = 'Gln';
tRNA{counter}.abundance = 0.08;
counter = counter+1;

tRNA{counter}.name = 'Gln2';
tRNA{counter}.codons_recognized = {'CAG'};
tRNA{counter}.aa_name = 'Gln';
tRNA{counter}.abundance = 0.12;
counter = counter+1;

tRNA{counter}.name = 'Glu2';
tRNA{counter}.codons_recognized = {'GAA','GAG'};
tRNA{counter}.aa_name = 'Glu';
tRNA{counter}.abundance = 0.56;
counter = counter+1;

tRNA{counter}.name = 'Gly1+2';
tRNA{counter}.codons_recognized = {'GGG','GGA'};
tRNA{counter}.aa_name = 'Gly';
tRNA{counter}.abundance = 0.21;
counter = counter+1;

tRNA{counter}.name = 'Gly3';
tRNA{counter}.codons_recognized = {'GGC','GGT'};
tRNA{counter}.aa_name = 'Gly';
tRNA{counter}.abundance = 0.48;
counter = counter+1;

tRNA{counter}.name = 'His';
tRNA{counter}.codons_recognized = {'CAC','CAT'};
tRNA{counter}.aa_name = 'His';
tRNA{counter}.abundance = 0.08;
counter = counter+1;

tRNA{counter}.name = 'Ile1+2';
tRNA{counter}.codons_recognized = {'ATC','ATT','ATA'};
tRNA{counter}.aa_name = 'Ile';
tRNA{counter}.abundance = 0.47;
counter = counter+1;

tRNA{counter}.name = 'Leu1';
tRNA{counter}.codons_recognized = {'CTG'};
tRNA{counter}.aa_name = 'Leu';
tRNA{counter}.abundance = 0.42;
counter = counter+1;

tRNA{counter}.name = 'Leu2';
tRNA{counter}.codons_recognized = {'CTC','CTT'};
tRNA{counter}.aa_name = 'Leu';
tRNA{counter}.abundance = 0.11;
counter = counter+1;

tRNA{counter}.name = 'Leu3';
tRNA{counter}.codons_recognized = {'CTG','CTA'};
tRNA{counter}.aa_name = 'Leu';
tRNA{counter}.abundance = 0.06;
counter = counter+1;

tRNA{counter}.name = 'Leu4';
tRNA{counter}.codons_recognized = {'TTG'};
tRNA{counter}.aa_name = 'Leu';
tRNA{counter}.abundance = 0.18;
counter = counter+1;

tRNA{counter}.name = 'Leu5';
tRNA{counter}.codons_recognized = {'TTG','TTA'};
tRNA{counter}.aa_name = 'Leu';
tRNA{counter}.abundance = 0.07;
counter = counter+1;

tRNA{counter}.name = 'Metm';
tRNA{counter}.codons_recognized = {'ATG'};
tRNA{counter}.aa_name = 'Met';
tRNA{counter}.abundance = 0.09;
counter = counter+1;

tRNA{counter}.name = 'Phe';
tRNA{counter}.codons_recognized = {'TTC','TTT'};
tRNA{counter}.aa_name = 'Phe';
tRNA{counter}.abundance = 0.10;
counter = counter+1;

tRNA{counter}.name = 'Pro1';
tRNA{counter}.codons_recognized = {'CCG'};
tRNA{counter}.aa_name = 'Pro';
tRNA{counter}.abundance = 0.05;
counter = counter+1;

tRNA{counter}.name = 'Pro2';
tRNA{counter}.codons_recognized = {'CCC','CCT'};
tRNA{counter}.aa_name = 'Pro';
tRNA{counter}.abundance = 0.07;
counter = counter+1;

tRNA{counter}.name = 'Pro3';
tRNA{counter}.codons_recognized = {'CCT','CCA','CCG'};
tRNA{counter}.aa_name = 'Pro';
tRNA{counter}.abundance = 0.05;
counter = counter+1;

tRNA{counter}.name = 'Ser1';
tRNA{counter}.codons_recognized = {'TCA','TCT','TCG'};
tRNA{counter}.aa_name = 'Ser';
tRNA{counter}.abundance = 0.14;
counter = counter+1;

tRNA{counter}.name = 'Ser2';
tRNA{counter}.codons_recognized = {'TCG'};
tRNA{counter}.aa_name = 'Ser';
tRNA{counter}.abundance = 0.03;
counter = counter+1;

tRNA{counter}.name = 'Ser3';
tRNA{counter}.codons_recognized = {'AGC','AGT'};
tRNA{counter}.aa_name = 'Ser';
tRNA{counter}.abundance = 0.11;
counter = counter+1;

tRNA{counter}.name = 'Ser5';
tRNA{counter}.codons_recognized = {'TCT','TCC'};
tRNA{counter}.aa_name = 'Ser';
tRNA{counter}.abundance = 0.08;
counter = counter+1;

tRNA{counter}.name = 'Lys';
tRNA{counter}.codons_recognized = {'AAA','AAG'};
tRNA{counter}.aa_name = 'Lys';
tRNA{counter}.abundance = 0.20;
counter = counter+1;

tRNA{counter}.name = 'Thr1';
tRNA{counter}.codons_recognized = {'ACC','ACT'};
tRNA{counter}.aa_name = 'Thr';
tRNA{counter}.abundance = 0.01;
counter = counter+1;

tRNA{counter}.name = 'Thr2';
tRNA{counter}.codons_recognized = {'ACG'};
tRNA{counter}.aa_name = 'Thr';
tRNA{counter}.abundance = 0.06;
counter = counter+1;

tRNA{counter}.name = 'Thr3';
tRNA{counter}.codons_recognized = {'ACC','ACT'};
tRNA{counter}.aa_name = 'Thr';
tRNA{counter}.abundance = 0.11;
counter = counter+1;

tRNA{counter}.name = 'Thr4';
tRNA{counter}.codons_recognized = {'ACT','ACG','ACA'};
tRNA{counter}.aa_name = 'Thr';
tRNA{counter}.abundance = 0.13;
counter = counter+1;

tRNA{counter}.name = 'Trp';
tRNA{counter}.codons_recognized = {'TGG'};
tRNA{counter}.aa_name = 'Trp';
tRNA{counter}.abundance = 0.1;
counter = counter+1;

tRNA{counter}.name = 'Tyr1+2';
tRNA{counter}.codons_recognized = {'TAC','TAT'};
tRNA{counter}.aa_name = 'Tyr';
tRNA{counter}.abundance = 0.18;
counter = counter+1;

% tRNA{counter}.name = 'Tyr2';
% tRNA{counter}.codons_recognized = {'TAC','TAT'};
% tRNA{counter}.aa_name = 'Tyr';
% tRNA{counter}.abundance = 0.1;
% counter = counter+1;

tRNA{counter}.name = 'Val1';
tRNA{counter}.codons_recognized = {'GTA','GTG','GTT'};
tRNA{counter}.aa_name = 'Val';
tRNA{counter}.abundance = 0.39;
counter = counter+1;

tRNA{counter}.name = 'Val2A+2B';
tRNA{counter}.codons_recognized = {'GTC','GTT'};
tRNA{counter}.aa_name = 'Val';
tRNA{counter}.abundance = 0.13;
counter = counter+1;

% tRNA{counter}.name = 'Val2B';
% tRNA{counter}.codons_recognized = {'GTC','GTT'};
% tRNA{counter}.aa_name = 'Val';
% tRNA{counter}.abundance = 0.08;
% counter = counter+1;


% normalize the abundance:
total_abundance = 0;
for i = 1:length(tRNA)
   total_abundance = total_abundance + tRNA{i}.abundance;
end

for i = 1:length(tRNA)
   tRNA{i}.abundance = tRNA{i}.abundance/total_abundance; 
end

