function index = strcmp_synonyms(original_list,string,synonyms_list,bool_NaN)

% search for string in original list. Stop there if there is a unique
% match.
index = find(strcmp(original_list,string));

% if there is no match, look in the list of synonyms.
if numel(index)==0
    % first search for the list of synonyms corresponding to string of
    % interest.
    for j = 1:size(synonyms_list,1)
        
        if ~isempty(find(strcmp(synonyms_list(j,:),string),1))
            
            % then search back the original list with the possible
            % synonyms. Stop at the first encountered synonym.
            for k = 1:length(synonyms_list(j,:))
                ind = find(strcmp(original_list,synonyms_list(j,k)));
                if length(ind)==1
                    index = ind;
                    break
                end
            end
            
            
        end
    end
    
    if numel(index)==0
        if bool_NaN
%             disp('No possibility found.')
%             disp(string)
            index = NaN;
        end
    end
    
elseif numel(index)>1
%     if bool_NaN
%         disp('Multiple possibilities found.')
%         disp(string)
%         index = NaN;
%     end
end
