clear all
%% reading files
dir_name = 'C:\Users\t450s\INSTITUT CURIE\LOCCO - Cell migration polarity\PAPER Golgi essential\4 Submission to eLife\FULL Submission\4 Source Data\Figure1\1c\Freely Angles control'; % folder containing your data
file_list = dir(dir_name);

ind = length(file_list) - 2;

max_t = 0;
big_tab_ang = [];
aver_tab = zeros(ind,1);
aver_tab_rad = zeros(ind,1);
for i_a=1:ind
    res = load(fullfile(dir_name,file_list(i_a+2).name));
    tab_ang = res.v2_ang-res.v1_ang;
    tab_ang_rad = tab_ang*pi/180;
    big_tab_ang = [big_tab_ang, tab_ang_rad];
    aver_tab(i_a) = mean(tab_ang);
    aver_tab_rad(i_a) = mean(tab_ang_rad);
end

% figure; rose(big_tab_ang,10); title('All angles');
% figure; rose(aver_tab_rad,10); %title('Averaged angles');
figure; h = polarhistogram(aver_tab_rad, 10, 'BinLimits',[-pi pi], 'FaceAlpha', 0.2, 'FaceColor', [0 0.4470 0.7410], 'EdgeColor', [0 0.4470 0.7410], 'LineWidth', 3); %title('Averaged angles');
% figure; polarhistogram(aver_tab_rad);

%% customize figure

% set(gca,'FontSize',12,'fontweight','bold')
set(gcf,'color','w');
ax = gca;
ax.FontSize = 18;
ax.FontWeight = 'bold';
ax.RLim = [0 8]; % for max value [0 inf]
ax.RColor = [0.4 0.4 0.4];
ax.LineWidth = 2;
ax.Color = [0.97 0.97 0.97];

