%% load the data by entering in the folder with the morphomaps of interest

%for golgi centered
outfolders=dir(pwd);
i=1;
for z=1:size(outfolders)
S=strfind(outfolders(z).name,'golgcenter.fig');
  if isempty(S)<1
        name{i}=(strcat(pwd,'\',outfolders(z).name));
        i=i+1;
  end
end
Nc = length(name);

%% average morpho map traj centered
for i=1:Nc
fig = openfig(name{i});
fig = gcf;
M = getimage(fig);
meanMg(:,i) = mean(M,2);
close(fig)
end

%% plot
figure;
hold all
for i=1:Nc
    plot(meanMg(:,i))
end

%% plot average of the average
figure;
plot(mean(meanMg,2)) % mean of each row

%% final fig
figure;
hold on
%plot(meanMg,'color',[0 0 1 0.2])
plot(mean(meanMg,2),'b','linewidth',2)
stdMg = std(meanMg,0,2);
plot(mean(meanMg,2)+stdMg,'--b','linewidth',0.5)
plot(mean(meanMg,2)-stdMg,'--b','linewidth',0.5)

%% save data
save('meanMg.mat','meanMg')
save('stdMg.mat','stdMg')



