clear all
%% Calculate the exit direction properly: nucleus direction at exit
load('dataALL.mat')

for i=1:36
    FEn = data(i).FEn;
    nuc = data(i).nuc{:};
    ae(i)=atan2(nuc(2,FEn)-nuc(2,FEn-1),nuc(1,FEn)-nuc(1,FEn-1));
end
ae = rad2deg(ae);

%% plot the initial orientation against the escape

ai=[];
af=[];
for i=1:36
    a2 = data(i).agn{:};
    ai(i) = a2(1);
end

ad = wrapTo180(ae-ai);
aver_tab_rad_zero = deg2rad(ad);

% plot
figure; h = polarhistogram(aver_tab_rad_zero, 18, 'BinLimits',[-pi pi], 'FaceAlpha', 0.2, 'FaceColor', [0 0.4470 0.7410], 'EdgeColor', [0 0.4470 0.7410], 'LineWidth', 3); %title('Averaged angles');

% customize
set(gcf,'color','w');
ax = gca;
ax.FontSize = 18;
ax.FontWeight = 'bold';
ax.RLim = [0 15]; % for max value [0 inf]
ax.RColor = [0.4 0.4 0.4];
ax.LineWidth = 2;
ax.Color = [0.97 0.97 0.97];


%% plot the NG orientation against the escape direction
ai=[];
af=[];
for i=1:36
    a1 = data(i).an{:};
    a2 = data(i).agn{:};
    ai(i) = a2(data(i).FEn);
    af(i) = a1(data(i).FEn);
end

ad = wrapTo180(ai-af);
aver_tab_rad_escape = deg2rad(ad);

% plot
figure; h = polarhistogram(aver_tab_rad_escape, 18, 'BinLimits',[-pi pi], 'FaceAlpha', 0.2, 'FaceColor', [0 0.4470 0.7410], 'EdgeColor', [0 0.4470 0.7410], 'LineWidth', 3); %title('Averaged angles');

% customize
set(gcf,'color','w');
ax = gca;
ax.FontSize = 18;
ax.FontWeight = 'bold';
ax.RLim = [0 15]; % for max value [0 inf]
ax.RColor = [0.4 0.4 0.4];
ax.LineWidth = 2;
ax.Color = [0.97 0.97 0.97];

