%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN this script IN SECTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
%% extract data for the temporal cross-correlation plot 
files = dir('pos*.mat');
nf = length(files);
rt = NaN(nf,400);
lt = NaN(nf,400);
for i=1:nf
    load(files(i).name);
    lp= length(rm);
    figure(1)
    imshow(MDns,[],'initialmagnification',500)
    colormap('jet')
    saveas(gcf,[files(i).name,'1.jpg'])
    figure(2)
    imshow(SMs,[],'initialmagnification',500)
    colormap('jet')
    saveas(gcf,[files(i).name,'2.jpg'])
    rt(i,1:lp) = rm;
    lt(i,1:lp) = lag;
end
%% plot the final figure
figure(3)
x0=100;
y0=100;
width=350;
height=250;
set(gcf,'units','points','position',[x0,y0,width,height])
 box on
hold 
lm = 25;
clear('rmm')
for i=1:nf
   ind = find(isnan(lt(i,:)));
   lag = lt(i,1:ind(1)-1);
   im = find(lag>-lm&lag<lm);
   rm = rt(i,1:ind(1)-1);
   rmm(i,:)=rt(i,im);
   plot(5*lag,smooth(rm,10),'color',[0.6 0.6 0.6],'linewidth',0.2) % '-' removed
end
mrmm = mean(rmm,1);
mlm = -lm+1:lm-1;
plot(5*mlm,mrmm,'r','linewidth',2) % '-' removed
line([0 0], [-0.1 0.3],'Color','k');
line([-200 200], [0 0],'Color','k');
axis([xlim    -100  100])
axis([ylim    -0.1  0.3])
ylabel('correlation coefficient')
xlabel('time lag (min)')
set(gca,'FontSize',18,'fontweight','bold')
set(gcf,'color','w');
% saveas(gcf,'correl.pdf')

%% compute max and lag
for i=1:nf
    [mc(i),ic(i)]=max(rmm(i,:));
    indx = ic(i)-5: ic(i)+5;
    xx =  ic(i)-5:0.01:ic(i)+5;
    yy = spline(indx,rmm(i,indx),xx);
    [mcc(i),icc(i)]=max(yy);
    icc(i)= (ic(i)-5)*100+icc(i);
end
mean(mc)
std(mc)
% max correlation: 0.19 +- 0.12
% we remove cell 13 because of a peak in negative time lags
% iic = ic(1:12);
% iic = [iic,ic(14:15)];
%%%%%%%%%%%%%%%%%%
iicc = icc(1:12);
iicc = [iicc,icc(14:15)];
iic = ic(1:12);
iic = [iic,ic(14:15)];
%%%%%%%%%%%%%%%%%%

mean(5*mlm(iic))
std(5*mlm(iic))
% lag at max correlation: 19 +- 11 min
% clear all

%% swarm plot of lag times
 x = [repmat(1,length(mlm(iic)),1)];
 mlmc = -lm+1:0.01:lm-1;
 y = [5*(mlmc(iicc)-1)'];
 % make figure
figure
% set layout
x0=100;
y0=100;
width=350;
height=150;
set(gcf,'units','points','position',[x0,y0,width,height])

% swarmplot
% cmap = [0.0320 0.4469 0.7564];
cmap = [0 0.4470 0.7410];
 beeswarm(x,y,'dot_size',2,'overlay_style','sd','sort_style','fan','colormap',cmap);
 
 % x and y labels
 xticks([])
% xticklabels({''})
 yticks([0,10,20,30,40,50,60])
% yticklabels({'0','20','40','60'})
 box on
 set(gca,'FontSize',18,'fontweight','bold')
set(gcf,'color','w');
camroll(-90)
% saveas(gcf,'lag_swarm.png')
