%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN SCRIPT IN SECTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
cd('ANGLESORTED');
N = 22;
nf = 60;
%% get files names
names = dir;
for i=1:N
   file_name{i} = names(i+2).name ;
end
%% get angles
for i=1:N
    load(file_name{i}) ;
    if (i==4|i==6)
        angles{i} = angleArray3(1:50,1);
    else
        angles{i} = angleArray3(:,1);
    end
end
%% cure data
angle_mat = NaN(nf,N);
for i=1:N
   data= angles{i};
   if length(data)>nf
       angle_mat(:,i) = data(1:nf);
   else
        angle_mat(1:length(data),i) = data;
   end
end
%% split 2 groups
g1 = [1:10,12,13,14,16:20,22];
g2 = [11,15,21];
angle_1 = angle_mat(:,g1);
angle_2 = angle_mat(:,g2);
% angle_1 = angle_mat();
%% plot angles
timeM = 0:10:(nf*10-10);
timeH = timeM./60;
t = timeH;
figure(1)
clf;
hold on
for i=1:19
    plot(t,angle_1(:,i),'color',[0.9961 0.5898 0.3672],'linewidth',0.5);
end
for i=1:nf
    indgood=find(~isnan(angle_1(i,:)));
    ave(i) = mean(angle_1(i,indgood));
    st(i) = std(angle_1(i,indgood));
end
plot(t,smooth(ave,5),'color',[0.9258 0.2891 0.1484],'linewidth',2)
plot(t,smooth(ave+st,5),'--','color',[0.9258 0.2891 0.1484],'linewidth',2)
plot(t,smooth(ave-st,5),'--','color',[0.9258 0.2891 0.1484],'linewidth',2)
% for i=1:3
%     plot(t,angle_2(:,i),'color',[0.5 0.5 0.8],'linewidth',0.5)
% end
% for i=1:90
%     indgood=find(~isnan(angle_2(i,:)));
%     ave(i) = mean(angle_2(i,indgood));
% end
% plot(t,smooth(ave,5),'b','linewidth',2)
% lines
l1 = zeros(1,nf);
l2 = 90.*ones(1,nf);
% l3 = 270.*ones(1,90);
l4 = -90.*ones(1,nf);
l5 = -180.*ones(1,nf);
l6 = 180.*ones(1,nf);
plot(t,l1,'k');
plot(t,l2,'--','color',[0.9258 0.2891 0.1484]);
plot(t,l4,'--','color',[0.9258 0.2891 0.1484]);
ylim([-180 180])
% plot(t,l3,'--b');
plot(t,l5,'k');
plot(t,l6,'k');

% ticks
 xticks([0,2,4,6,8,10])
 xticklabels({'0','2','4','6','8','10'})
 yticks([-180,-135,-90,-45,0,45,90,135,180])
 yticklabels({'-180','','-90','','0','','90','','180'})
 
% font size
set(gca,'FontSize',22,'fontweight','bold')
box on

% clear all;
