%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% trajectorySameOrigin_limitedNumberOfFrames('C:\Users\t450s\Desktop\PhD\PAPER Golgi\Figure3-4\Figure4\Freely control',40);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%

function trajectorySameOrigin_limitedNumberOfFrames(folder_name,index_end)
    files_folder = dir(fullfile(folder_name,'*centroid_cell.mat'));  % search only *.mat file
    
    traj_start_0 = cell(length(files_folder),1);
    for i_f= 1:length(files_folder) 
           % load the trajectories, store them removing the first value
           % so that they all start at (0,0)
     if (i_f==2)
        n_f = 22;
     elseif (i_f==13)
        n_f = 35;
     else
        n_f = index_end;
     end
           f_l = load(fullfile(folder_name,files_folder(i_f).name));
           traj_start_0{i_f} = f_l.coord_cell(:,1:n_f) - [f_l.coord_cell(1,1);f_l.coord_cell(2,1)];
    end
    
    % plot all trajectories
    figure;
    pixelSize = 0.2167;
    for i_f= 1:length(files_folder)
%           plot(traj_start_0{i_f}(1,:),traj_start_0{i_f}(2,:); hold on;
            plot(traj_start_0{i_f}(1,:)*pixelSize,traj_start_0{i_f}(2,:)*pixelSize, 'LineWidth', 2); hold on;
    end
    hold off;
    
%% set figure properties
line([-325 500],[0 0],'Color','black','LineStyle','-');
line([0 0],[-220 300],'Color','black','LineStyle','-');

axis equal
axis([-150 210 -200 150]);
% axis([-150 150 -200 150]);

xticks([-100,0,100,200])
xticklabels({'-100','0','100','200'})
yticks([-200,-100,0,100])
yticklabels({'-200','-100','0','100'})

box on
set(gca,'FontSize',22,'fontweight','bold')
end

