 load('trajectoriesFreely_10.mat');
 load('trajectoriesNZ_10.mat');
 load('trajectoriesAngle_10.mat');
 load('trajectoriesAngleNZ_10.mat');
nf = 40;
 %% control (freely_10fr)
 dirRatio_ctrl = [];
 for i=1:17
    coord_cell = trajectoriesFreely_10{i};
    
    % calculate shortest distance and trajectory length
    dist_first_end = sqrt( (coord_cell(1,nf) - coord_cell(1,1) )* (coord_cell(1,nf) - coord_cell(1,1) ) + (coord_cell(2,nf) - coord_cell(2,1) )* (coord_cell(2,nf) - coord_cell(2,1) ) );
%     dist_first_end = sqrt( (coord_cell(1,end) - coord_cell(1,1) )* (coord_cell(1,end) - coord_cell(1,1) ) + (coord_cell(2,end) - coord_cell(2,1) )* (coord_cell(2,end) - coord_cell(2,1) ) );
 
    dist_pt_by_pt = 0;
    for j=2:nf
%     for j=2:size(coord_cell,2)
        dist_pt_by_pt = dist_pt_by_pt + sqrt( (coord_cell(1,j) - coord_cell(1,j-1) )* (coord_cell(1,j) - coord_cell(1,j-1) ) ...
        + (coord_cell(2,j) - coord_cell(2,j-1) )* (coord_cell(2,j) - coord_cell(2,j-1) ) );
    end
    
    % calculate directionality ratio
    dirRatio = dist_first_end / dist_pt_by_pt;
    
    % concatenate directionality ratios
    dirRatio_ctrl = [dirRatio_ctrl, dirRatio];    
 end
 
 %% NZ
 dirRatio_NZ = [];
 for i=1:14
     if (i==8)
        n_f = 36;
     elseif (i==10)
        n_f = 30;
     else
        n_f = nf;
     end
    coord_cell = trajectoriesNZ_10{i};
    
    % calculate shortest distance and trajectory length
    dist_first_end = sqrt( (coord_cell(1,n_f) - coord_cell(1,1) )* (coord_cell(1,n_f) - coord_cell(1,1) ) + (coord_cell(2,n_f) - coord_cell(2,1) )* (coord_cell(2,n_f) - coord_cell(2,1) ) );
%     dist_first_end = sqrt( (coord_cell(1,end) - coord_cell(1,1) )* (coord_cell(1,end) - coord_cell(1,1) ) + (coord_cell(2,end) - coord_cell(2,1) )* (coord_cell(2,end) - coord_cell(2,1) ) );
 
    dist_pt_by_pt = 0;
    for j=2:n_f
%     for j=2:size(coord_cell,2)
        dist_pt_by_pt = dist_pt_by_pt + sqrt( (coord_cell(1,j) - coord_cell(1,j-1) )* (coord_cell(1,j) - coord_cell(1,j-1) ) ...
        + (coord_cell(2,j) - coord_cell(2,j-1) )* (coord_cell(2,j) - coord_cell(2,j-1) ) );
    end
    
    % calculate directionality ratio
    dirRatio = dist_first_end / dist_pt_by_pt;
    
    % concatenate directionality ratios
    dirRatio_NZ = [dirRatio_NZ, dirRatio];    
 end
 
 %% Angle
 dirRatio_Angle = [];
 for i=1:22
     if (i==7)
        n_f = 35;
     elseif (i==8)
        n_f = 32;
     elseif (i==10)
        n_f = 12;
     elseif (i==18)
        n_f = 30;
     elseif (i==20)
        n_f = 24;
     else
        n_f = nf;
     end
    coord_cell = trajectoriesAngle{i};
    
    % calculate shortest distance and trajectory length
    dist_first_end = sqrt( (coord_cell(1,n_f) - coord_cell(1,1) )* (coord_cell(1,n_f) - coord_cell(1,1) ) + (coord_cell(2,n_f) - coord_cell(2,1) )* (coord_cell(2,n_f) - coord_cell(2,1) ) );
%     dist_first_end = sqrt( (coord_cell(1,end) - coord_cell(1,1) )* (coord_cell(1,end) - coord_cell(1,1) ) + (coord_cell(2,end) - coord_cell(2,1) )* (coord_cell(2,end) - coord_cell(2,1) ) );
 
    dist_pt_by_pt = 0;
    for j=2:n_f
%     for j=2:size(coord_cell,2)
        dist_pt_by_pt = dist_pt_by_pt + sqrt( (coord_cell(1,j) - coord_cell(1,j-1) )* (coord_cell(1,j) - coord_cell(1,j-1) ) ...
        + (coord_cell(2,j) - coord_cell(2,j-1) )* (coord_cell(2,j) - coord_cell(2,j-1) ) );
    end
    
    % calculate directionality ratio
    dirRatio = dist_first_end / dist_pt_by_pt;
    
    % concatenate directionality ratios
    dirRatio_Angle = [dirRatio_Angle, dirRatio];    
 end
 
  %% Angle NZ
 dirRatio_AngleNZ = [];
 for i=1:13
     if (i==2)
        n_f = 22;
     elseif (i==13)
        n_f = 35;
     else
        n_f = nf;
     end
    coord_cell = trajectoriesAngleNZ{i};
    
    % calculate shortest distance and trajectory length
    dist_first_end = sqrt( (coord_cell(1,n_f) - coord_cell(1,1) )* (coord_cell(1,n_f) - coord_cell(1,1) ) + (coord_cell(2,n_f) - coord_cell(2,1) )* (coord_cell(2,n_f) - coord_cell(2,1) ) );
%     dist_first_end = sqrt( (coord_cell(1,end) - coord_cell(1,1) )* (coord_cell(1,end) - coord_cell(1,1) ) + (coord_cell(2,end) - coord_cell(2,1) )* (coord_cell(2,end) - coord_cell(2,1) ) );
 
    dist_pt_by_pt = 0;
    for j=2:n_f
%     for j=2:size(coord_cell,2)
        dist_pt_by_pt = dist_pt_by_pt + sqrt( (coord_cell(1,j) - coord_cell(1,j-1) )* (coord_cell(1,j) - coord_cell(1,j-1) ) ...
        + (coord_cell(2,j) - coord_cell(2,j-1) )* (coord_cell(2,j) - coord_cell(2,j-1) ) );
    end
    
    % calculate directionality ratio
    dirRatio = dist_first_end / dist_pt_by_pt;
    
    % concatenate directionality ratios
    dirRatio_AngleNZ = [dirRatio_AngleNZ, dirRatio];    
 end
 
 %% plot
 % prepare data
 x = [repmat(1,17,1);repmat(2,14,1);repmat(3,22,1);repmat(4,13,1)];
 % units
 y = [dirRatio_ctrl';dirRatio_NZ';dirRatio_Angle';dirRatio_AngleNZ'];
 % make figure
figure(1);
% set layout
x0=100;
y0=100;
width=500;
height=350;
set(gcf,'units','points','position',[x0,y0,width,height])
% swarmplot
cmap = [0.8164 0.4375 0.0820; 0 0 0; 0.0320 0.4469 0.7564; 0.5 0.5 0.5];
 beeswarm(x,y,'dot_size',2,'overlay_style','sd','colormap',cmap);
 % x and y labels
 xticks([1,2,3,4])
 xticklabels({'','','',''})
 yticks([0 0.2 0.4 0.6 0.8 1.0])
 yticklabels({'0','0.2','0.4','0.6','0.8','1.0'})

% customize the plot
yt = get(gca, 'YTick');
axis([xlim    0  ceil(max(yt)*1.2)]);
xlim([0 5]);
ylim([0 1.2]);
xt = get(gca, 'XTick');

set(gca,'FontSize',22,'fontweight','bold')
set(gcf,'color','w');
%  xticklabels({'Control','Golgicide','Nocodazole'})
%  xtickangle(45)
%  ylabel('Directionality ratio')

 % a nice box around
 box on
 
%% significance test - unpaired two-sample t-test
 % significance 1: calculation
% [h,p1] = ttest2(dirRatio_ctrl,dirRatio_NZ);
% [h,p2] = ttest2(dirRatio_ctrl,dirRatio_Angle);
% [h,p3] = ttest2(dirRatio_ctrl,dirRatio_AngleNZ);
% [h,p4] = ttest2(dirRatio_NZ,dirRatio_Angle);
% [h,p5] = ttest2(dirRatio_NZ,dirRatio_AngleNZ);
% [h,p6] = ttest2(dirRatio_Angle,dirRatio_AngleNZ);
%
% sigstar({[1,2],[1,3],[2,3],[2,4]},[p1,p2,p4,p5])

%% significance test - Wilcoxon's rank sum test
%[p,h] = ranksum(x,y) for Wilcoxon-Mann-Whitney test
 % significance 1: calculation
% [p1,h] = ranksum(dirRatio_ctrl,dirRatio_NZ);
% [p2,h] = ranksum(dirRatio_ctrl,dirRatio_Angle);
% [p3,h] = ranksum(dirRatio_ctrl,dirRatio_AngleNZ);
% [p4,h] = ranksum(dirRatio_NZ,dirRatio_Angle);
% [p5,h] = ranksum(dirRatio_NZ,dirRatio_AngleNZ);
% [p6,h] = ranksum(dirRatio_Angle,dirRatio_AngleNZ);
% 
% sigstar({[1,2],[1,3],[2,3],[2,4]},[p1,p2,p4,p5])

%% significance test - Kruskal-Wallis test (non-parametric ANOVA)
%[p,tbl,stats] = kruskalwallis(data,group) for Kruskal-Wallis non-parametric test
[p,tbl,stats] = kruskalwallis(y,x); % x - tells the group, y - contains data

%% follow-up to Kruskal-Wallis test -> Multiple comparison test
figure(2);
c = multcompare(stats, 'CType', 'dunn-sidak')
% c = multcompare(stats)

%% [choose the correct figure]
 % significance 2: plot on top
figure(1);
sigstar({[1,2],[2,3],[2,4]},[c(1,6),c(4,6),c(5,6)]);


% clear all