#!/bin/bash
# Ablation experiments on split MNIST
# Hyperparameters for each baseline are individually tuned for a fair comparison

printf -v date '%(%Y%m%d)T'
dir="${date}_ablation_split-mnist"
seeds=( 2019 2020 2021 )

for seed in "${seeds[@]}"
do
    python run_dyn_continual.py --log_dir ${dir}\/full --seed ${seed} --task split_mnist --prob_drift_down 0.0624703 --prob_drift_up 0.05835393 --prob_freeze 0.94452875 &
    python run_dyn_continual.py --log_dir ${dir}\/no_freeze_no_learning_mod --seed ${seed} --task split_mnist --prob_freeze 1.0 --no_lr_modulation --prob_drift_down 0.09587958 --prob_drift_up 0.01798108 &
    python run_dyn_continual.py --log_dir ${dir}\/fixed_probs --seed ${seed} --task split_mnist --fixed_probs 0.5 --prob_drift_down 0.09833934 --prob_drift_up 0.09764242 --prob_freeze 0.9466155 &

    wait
done
