import os

import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

# Global configuration of matplotlib to use custom style sheet
matplotlib.use('pgf')
matplotlib.style.use("style.mplstyle")

# Import the data as DataFrames
data = pd.read_csv(os.path.join("data", "20201207_energy_hpsearch-probmlp_summary_max.csv"))

# Prepare the figure
fig, ax = plt.subplots(figsize=[2.6, 1.5])

# Plot the energy over time as a line plot
data.plot.line(x="prob_release", y="inf_per_energy", ax=ax, legend=False)

# X/Y Labels and ticks
ax.set_xlim(0.05, 1.0)
ax.set_xlabel("Release Probability")
ax.set_ylabel("Mutual Information\nper Synaptic Energy")

# Save the figure
fig.tight_layout(pad=0.0)
fig.savefig("energy-mlp_line_prob-max-info.pdf")
