import numpy as np
from scipy.stats import t


def independent_ttest(mean1, mean2, sem1, sem2, df1, df2):

    # Calculate the t-statistic
    t_stat = (mean1 - mean2) / np.sqrt(sem1**2.0 + sem2**2.0)

    # Calculate the p-value
    df = df1 + df2 - 2
    p_value = (1.0 - t.cdf(np.abs(t_stat), df)) * 2.0

    return t_stat, p_value


def plot_bracket(ax, x1, x2, y, label):
    height = 0.01
    ax.plot([x1, x1, x2, x2], [y, y + height, y + height, y], linewidth=0.5, color="black")
    ax.text((x1 + x2) * 0.5, y + height, label, ha='center', va='bottom', color="black", fontsize="x-small")
