# Baselines

This folder contains code for the baselines EWC and "No Consolidation" referred to as "FT". 

Code was tested with:
- tensorflow version 1.14.0
- keras version 2.2.5 (not much keras is used, so may well work with other version)
- python 3.6.8 (some older versions handle dicts differently, which may cause problems with the searcher_*.py files, see below for alternative)
- sklearn version 0.21.4 (needed for gird searches in searcher_*.py files only)

It is a cleaned up version of the code used for the results reported in our paper. We checked for all programs that they still work as desired. Should you nevertheless find any bugs, please let us know.

## Instructions
- Use the files 'searcher_[algo_name].py' to run baselines. In these files you can also modify the grids over which should be searched. Final results will be saved to file 'summary.txt'. 
- ALTERNATIVE: In the 'worker_[algo_name].py' file, change the line starting with 'inputs = '  (in worker_SI.py these are lines 13,14 for example) and run  ''worker_[algo_name].py'' directly.
- By default any intermediate outputs of the algorithm will be printed to the command line. By setting 'save_outputs_to_log_dir = True' in 'worker_*.py' you can instead print the outputs to a file, which will be saved in the directory 'logs'.
- You can use the .ipython notebooks to view summaries of the results or plots.
