# Dynamic DropConnect
This repository contains code to execute the main experiments of the manuscript _Presynaptic Stochasticity Improves Energy Efficiency and Alleviates the Stability-Plasticity Dilemma_.

## Project structure
- `./` Contains python scripts to run the models and bash scripts to automate experiments, most notably:
  - `run_dyn_continual.py` runs the main model for various configurations
- `lib/` Contains the modules implementing the core functionality of the algorithm, most notably:
  - `ddc.py`: Contains the main logic of the Dynamic DropConnect algorithm
  - `train.py`: Contains the training routine
- `etc/` Contains default hyperparameter configurations for different tasks
- `log/` Default logging directory

## Usage

### Experiments
- Energy experiments can be run by executing the bash script `exp_energy.sh`
- Lifelong experiments can be run by executing the bash script `exp_lifelong.sh`
- Ablation experiments can be run by executing the bash scripts `exp_ablation_split-mnist.sh` and `exp_ablation_perm-mnist.sh`

### Main model
The main model can be experimented with using:
```
usage: run_dyn_continual.py [-h] [--batch_size BATCH_SIZE] [--dimensions DIMENSIONS [DIMENSIONS ...]] [--epochs EPOCHS] [--experiment_clamp]
                            [--experiment_fisher] [--experiment_lesion] [--fixed_probs FIXED_PROBS] [--grad_hard_reset] [--no_grad_hard_reset]
                            [--hard_freeze] [--no_hard_freeze] [--learning_rate LEARNING_RATE] [--log_dir LOG_DIR] [--lr_modulation] [--no_lr_modulation]
                            [--nonlinearity {leaky_relu,relu,sigmoid,tanh}] [--normalise] [--no_normalise] [--prob_drift_down PROB_DRIFT_DOWN]
                            [--prob_drift_up PROB_DRIFT_UP] [--prob_freeze PROB_FREEZE] [--random_hyperparameter]
                            [--relative_parameter_noise RELATIVE_PARAMETER_NOISE] [--seed SEED]
                            [--task {mnist,mnist_energy,mnist_fisher,perm_fmnist,perm_mnist,perm_mnist_cont,split_fmnist,split_mnist}]
                            [--weight_decay WEIGHT_DECAY]

Run experiments with the Dynamic DropConnect model.

optional arguments:
  -h, --help            show this help message and exit
  --batch_size BATCH_SIZE
                        Size of mini batches during training.
  --dimensions DIMENSIONS [DIMENSIONS ...]
                        Dimensions of the neural network.
  --epochs EPOCHS       Number of epochs to train.
  --experiment_clamp    Flag to conduct the probability clamp experiment.
  --experiment_fisher   Flag to conduct the Fisher Information experiment.
  --experiment_lesion   Flag to conduct the importance lesion experiment.
  --fixed_probs FIXED_PROBS
                        Fixed forward transmission probabilities decoupled from importance parameter.
  --grad_hard_reset     Flag to enable resetting gradient cache after every training step (effectively turning it into a simple threshold).
  --no_grad_hard_reset  Flag to disable resetting gradient cache after every training step (effectively turning it into a simple threshold).
  --hard_freeze         Flag to enable complete freezing of weights when transmission probability is frozen.
  --no_hard_freeze      Flag to disable complete freezing of weights when transmission probability is frozen.
  --learning_rate LEARNING_RATE
                        Learning rate for the parameters.
  --log_dir LOG_DIR     Subdirectory within ./log/ where to store logs.
  --lr_modulation       Flag to enable the learning rate modulation.
  --no_lr_modulation    Flag to disable the learning rate modulation.
  --nonlinearity {leaky_relu,relu,sigmoid,tanh}
                        Nonlinearity between network layers.
  --normalise           Flag to enable normalisation of sampled weights by their transmission probability.
  --no_normalise        Flag to disable normalisation of sampled weights by their transmission probability.
  --prob_drift_down PROB_DRIFT_DOWN
                        Weight probability decrease parameter.
  --prob_drift_up PROB_DRIFT_UP
                        Weight probability increase parameter.
  --prob_freeze PROB_FREEZE
                        Weight probability at which proabilities are frozen.
  --random_hyperparameter
                        Use random hyperparameters.
  --relative_parameter_noise RELATIVE_PARAMETER_NOISE
                        Relative noise to be added to the parameters.
  --seed SEED           Random seed for pytorch
  --task {mnist,mnist_energy,mnist_fisher,perm_fmnist,perm_mnist,perm_mnist_cont,split_fmnist,split_mnist}
                        Continual task to be solved.
  --weight_decay WEIGHT_DECAY
                        Weight decay (~l2-regularization strength).
```

### Comparison models
The main model can be experimented with using:
```
usage: run_mlp_continual.py [-h] [--batch_size BATCH_SIZE] [--dimensions DIMENSIONS [DIMENSIONS ...]] [--epochs EPOCHS] [--learning_rate LEARNING_RATE]
                            [--log_dir LOG_DIR] [--nonlinearity {leaky_relu,relu,sigmoid,tanh}] [--optimizer {adam,adagrad,sgd}]
                            [--prob_release PROB_RELEASE] [--seed SEED] [--task {mnist_energy,perm_fmnist,perm_mnist,split_fmnist,split_mnist}]
                            [--weight_decay WEIGHT_DECAY]

Run experiments with a (probabilistic) Multilayer Perceptron.

optional arguments:
  -h, --help            show this help message and exit
  --batch_size BATCH_SIZE
                        Size of mini batches during training.
  --dimensions DIMENSIONS [DIMENSIONS ...]
                        Dimensions of the neural network.
  --epochs EPOCHS       Number of epochs to train.
  --learning_rate LEARNING_RATE
                        Learning rate of the optimizer.
  --log_dir LOG_DIR     Subdirectory within ./log/ where to store logs.
  --nonlinearity {leaky_relu,relu,sigmoid,tanh}
                        Nonlinearity between network layers.
  --optimizer {adam,adagrad,sgd}
                        Optimizer used to train the model.
  --prob_release PROB_RELEASE
                        Transmission probability of the weights.
  --seed SEED           Random seed for pytorch
  --task {mnist_energy,perm_fmnist,perm_mnist,split_fmnist,split_mnist}
                        Continual task to be solved.
  --weight_decay WEIGHT_DECAY
                        Weight decay (~l2-regularization strength) of the optimizer.
```

## Requirements
Code was tested using `python 3.9`. Required packages can be found in `requirements.txt` and installed using `pip install -r requirements.txt`.

## Code Style
This project uses `flake8` for linting and adheres to the [pep8](https://pep8.org/) standard.