rm(list=ls(all=TRUE)) # Removes everything from R (all objects) - a good thing to do if you are starting fresh work
graphics.off()        # Removes any graphics or graphic windows that may exist - again a good thing to do if you are starting to work fresh 

setwd() 

install.packages("quantreg")
install.packages("SparseM")
install.packages("Rearrangement")
install.packages("reshape")
install.packages("MuMIn") #only needed if we want to use DREDGE
library(MASS)
library(Rearrangement)
library(reshape)
library(MuMIn)

disease.data<-read.csv(file.choose())  
names(disease.data)
head(disease.data)
str(disease.data) # gives full structure of dataset
attach(disease.data)
#detach(disease.data)

Month<- factor(Month)
Season<- factor(Season)
Location<- factor(Location)
Sex<- factor(Sex)
Fouling<- factor(Fouling)
Colour<- factor(Colour)
LimbLoss <- factor(LimbLoss)
HemoCol3<- factor(HemoCol3)
Hemocy<- as.numeric(Hemocy)
Hemat <- factor(Hemat)
Control<- factor(Control)
HematInt<- as.numeric(HematInt)
CoInfect1<- factor(CoInfect1)
Sacc<- factor(Sacc)
Trematodes<- factor(Trematodes)
Haplo<- factor (Haplo)
Microsp<- factor (Microsp)
Mikrocy<- factor (Mikrocy)
Vibrio<- factor (Vibrio)
FungiPCR<- factor (FungiPCR)
CFU<- as.numeric(CFU)
Pig.Loss<- factor(Pig.Loss)
ShellDis<- factor(ShellDis)
HematSmear<- factor(HematSmear)

## note: categorical variables are automatically taken as factors 
# when written into models - however continuous variables need to be specified as factors, e.g. CW

disease.data.Pier<-subset(disease.data,Location=='Pier') #subsetting for location for later models
disease.data.Dock<-subset(disease.data,Location=='Dock') 
disease.data.Hemat<-subset(disease.data,HematSmear=='1')
disease.data.Control<-subset(disease.data,HematSmear=='0')

#options(na.action = "na.fail")

#WANT TO TRY: 

#Hematodinium overall ~ infection (then Location separated)
#Having a Co-infection (yes or no) ~ location, season, sex, size

CoInfectALL <- glm(CoInfect1 ~ HematSmear + Location + Season + CW + Sex + Colour + LimbLoss + Fouling, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL) 
extractAIC (CoInfectALL)

drop1(CoInfectALL, test="Chisq") #remove hemat

CoInfectALL2 <- glm(CoInfect1 ~ Location + Season + CW + Sex + Colour + LimbLoss + Fouling, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL2) 
extractAIC (CoInfectALL2)

drop1(CoInfectALL2, test="Chisq") #remove season

CoInfectALL3 <- glm(CoInfect1 ~ Location + CW + Sex + Colour + LimbLoss + Fouling, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL3) 
extractAIC (CoInfectALL3)

drop1(CoInfectALL3, test="Chisq") #remove colour

CoInfectALL4 <- glm(CoInfect1 ~ Location + CW + Sex + LimbLoss + Fouling, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL4) 
extractAIC (CoInfectALL4)

drop1(CoInfectALL4, test="Chisq") #remove location

CoInfectALL5 <- glm(CoInfect1 ~ CW + Sex + LimbLoss + Fouling, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL5) 
extractAIC (CoInfectALL5)

drop1(CoInfectALL5, test="Chisq") #remove fouling

CoInfectALL6 <- glm(CoInfect1 ~ CW + Sex + LimbLoss, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL6) 
extractAIC (CoInfectALL6)

drop1(CoInfectALL6, test="Chisq") #remove sex

CoInfectALL7 <- glm(CoInfect1 ~ CW + LimbLoss, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectALL7) 
extractAIC (CoInfectALL7)

drop1(CoInfectALL7, test="Chisq") #remove nada, CW and nearly limb loss are significant in explaining coinfection presence.

#JUST TO SEE IF DIFFERENCE BETWEEN HEMAT AND NONE#

CoInfectHEMAT <- glm(CoInfect1 ~ Location + Season + CW + Sex + Colour + LimbLoss + Fouling, disease.data.Hemat, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectHEMAT) 
extractAIC (CoInfectHEMAT)

drop1(CoInfectHEMAT, test="Chisq") #drop season

CoInfectHEMAT1 <- glm(CoInfect1 ~ Location + Sex + CW + Colour + LimbLoss + Fouling, data=disease.data.Hemat, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectHEMAT1) 
extractAIC (CoInfectHEMAT1)

drop1(CoInfectHEMAT1, test="Chisq") #drop location

CoInfectHEMAT2 <- glm(CoInfect1 ~ Sex + CW + Colour + LimbLoss + Fouling, data=disease.data.Hemat, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectHEMAT2) 
extractAIC (CoInfectHEMAT2)

drop1(CoInfectHEMAT2, test="Chisq") #drop Sex

CoInfectHEMAT3 <- glm(CoInfect1 ~ CW + Colour + LimbLoss + Fouling, data=disease.data.Hemat, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectHEMAT3) 
extractAIC (CoInfectHEMAT3)

drop1(CoInfectHEMAT3, test="Chisq") #drop CW

CoInfectHEMAT4 <- glm(CoInfect1 ~ Fouling + Colour + LimbLoss, data=disease.data.Hemat, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (CoInfectHEMAT4) 
extractAIC (CoInfectHEMAT4)

drop1(CoInfectHEMAT4, test="Chisq") #drop nada, Fouling (nearly), colour and limbloss all significant

#Now to try individual infections BY HEMATO OVERALL#

HematCoinfect <- glm(HematSmear ~ Sacc + Trematodes + Haplo + Microsp + Vibrio + FungiPCR, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfect) 
extractAIC (HematCoinfect)

drop1(HematCoinfect, test="Chisq") #remove Trematodes

HematCoinfect2 <- glm(HematSmear ~ Sacc + Haplo + Microsp + Vibrio + FungiPCR, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfect2) 
extractAIC (HematCoinfect2)

drop1(HematCoinfect2, test="Chisq") #remove Sacc

HematCoinfect3 <- glm(HematSmear ~ Haplo + Microsp + Vibrio + FungiPCR, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfect3) 
extractAIC (HematCoinfect3)

drop1(HematCoinfect3, test="Chisq") #remove Vibrio

HematCoinfect4 <- glm(HematSmear ~ Haplo + Microsp + FungiPCR, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfect4) 
extractAIC (HematCoinfect4)

drop1(HematCoinfect4, test="Chisq") #remove micro

HematCoinfect5 <- glm(HematSmear ~ Haplo + FungiPCR, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfect5) 
extractAIC (HematCoinfect5)

drop1(HematCoinfect5, test="Chisq") ##NOTHIGN SIGNIFICANT


#Now to try individual infections BY HEMATO BY SITE, DOCK#

#COULD NOT INCLUDE TREMATODES, HAPLO or FUNGI
HematCoinfectDOCK <- glm(HematSmear ~ Sacc + Trematodes + Haplo + Microsp + Vibrio + FungiPCR, data=disease.data.Dock, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectDOCK) 
extractAIC (HematCoinfectDOCK)

drop1(HematCoinfectDOCK, test="Chisq") #remove TREMATODES, HAPLO, FUNGI (because 0) and Microsp

HematCoinfectDOCK1 <- glm(Hemat ~ Sacc + Vibrio, data=disease.data.Dock, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectDOCK1) 
extractAIC (HematCoinfectDOCK1)

drop1(HematCoinfectDOCK1, test="Chisq") #remove sacc

HematCoinfectDOCK2 <- glm(Hemat ~ Vibrio, data=disease.data.Dock, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectDOCK2) 
extractAIC (HematCoinfectDOCK2)

drop1(HematCoinfectDOCK2, test="Chisq") #remove Sacc

#NOTHING SIGNIFICANT


#BY SITE, PIER#

#COULD NOT INCLUDE TREMATODES, HAPLO or FUNGI
HematCoinfectPIER <- glm(HematSmear ~ Sacc + Trematodes + Haplo + Microsp + Vibrio + FungiPCR, data=disease.data.Pier, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectPIER) 
extractAIC (HematCoinfectPIER)

drop1(HematCoinfectPIER, test="Chisq") #remove Sacc and micro (because 0), Fungi

HematCoinfectPIER1 <- glm(Hemat ~ Trematodes + Haplo + Vibrio, data=disease.data.Pier, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectPIER1) 
extractAIC (HematCoinfectPIER1)

drop1(HematCoinfectPIER1, test="Chisq") #remove Vibrio

HematCoinfectPIER2 <- glm(Hemat ~ Trematodes + Haplo, data=disease.data.Pier, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectPIER2) 
extractAIC (HematCoinfectPIER2)

drop1(HematCoinfectPIER2, test="Chisq") #remove Trematodes

HematCoinfectPIER3 <- glm(Hemat ~ Haplo, data=disease.data.Pier, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (HematCoinfectPIER3) 
extractAIC (HematCoinfectPIER3)

drop1(HematCoinfectPIER3, test="Chisq") ##NOTHING SIGNIFICANT!#

###try something new

Intensity <- glm(CoInfect1 ~ HematInt, data=disease.data, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (Intensity) 
extractAIC (Intensity)

IntensityPier <- glm(CoInfect1 ~ HematInt, data=disease.data.Pier, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (IntensityPier) 
extractAIC (IntensityPier)

IntensityDock <- glm(CoInfect1 ~ HematInt, data=disease.data.Dock, family=binomial(link = "logit"), na.action=na.exclude)
summary.glm (IntensityDock) 
extractAIC (IntensityDock)

### COMMUNITY COMPOSITION - COMPARING HEMATODINIUM VS CONTROLS ##

rm(list=ls(all=TRUE)) # Removes everything from R (all objects) - a good thing to do if you are starting fresh work
graphics.off()        # Removes any graphics or graphic windows that may exist - again a good thing to do if you are starting to work fresh 

install.packages('vegan')
install.packages('ggplot2') ##plotting package
install.packages("RColorBrewer") #colour package for plots

library("RColorBrewer")
library(ggplot2)
library(vegan)

Hemat.compo<-read.csv(file.choose())  #PERMANOVA_HEMATCSV_SMEAR
head(Hemat.compo)

hemat.matrix<-as.matrix(Hemat.compo[,2:7])##response variables in a sample x species matrix

hemat.mat<-sqrt(hemat.matrix)

hemat.dist<-vegdist(hemat.mat, method='bray')

set.seed(36) #reproducible results

hemat.div<-adonis2(hemat.dist~Hemat, data=Hemat.compo, permutations = 999, method="bray")
hemat.div

dispersion<-betadisper(hemat.dist, group=Hemat.compo$Hemat)
permutest(dispersion)

plot(dispersion, hull=FALSE, ellipse=TRUE) ##sd ellipse

hematMDS<-metaMDS(hemat.mat, distance="bray", k=2, trymax=35, autotransform=TRUE) ##k is the number of dimensions
hematMDS ##metaMDS takes eaither a distance matrix or your community matrix (then requires method for 'distance=')

stressplot(hematMDS)

##pull points from MDS
NMDS1 <- hematMDS$points[,1] ##also found using scores(hematMDS)
NMDS2 <- hematMDS$points[,2]
hemat.plot<-cbind(Hemat.compo, NMDS1, NMDS2)

#plot ordination
tiff("Fig4a.tiff", units="in", width=6, height=5, res=300)
# insert ggplot code

Fig4a<-ggplot(hemat.plot, aes(NMDS1, NMDS2, color=Hemat))+
  geom_point(position=position_jitter(.1), shape=3)+##separates overlapping points
  stat_ellipse(type='t',size =1)+ ##draws 95% confidence interval ellipses
  #scale_color_brewer("",palette="Set1") + #uses colour brewer pallettes and empty "" just gets rid of legend title
  scale_color_manual("", values=c('#000000', '#FF9900')) +
  theme_classic()
Fig4a
ggsave("Fig4a.tiff", units="in", width=5, height=4, dpi=300, compression = 'lzw')


dev.off()

##Now try COMMUNITY COMPOSITION - COMPARING BETWEEN LOCATIONS##

Location.compo<-read.csv(file.choose())  #PERMANOVA_LOCATIONCSV
head(Location.compo)

Location.matrix<-as.matrix(Location.compo[,2:8])##response variables in a sample x species matrix - so there are 7 rows and 2 variables
Location.mat<-sqrt(Location.matrix)
Location.dist<-vegdist(Location.mat, method='bray')
Location.dist

set.seed(36) #reproducible results

Location.div<-adonis2(Location.dist~Location, data=Location.compo, permutations = 999, method="bray")
Location.div

dispersion<-betadisper(Location.dist, group=Location.compo$Location)
permutest(dispersion)

plot(dispersion, hull=FALSE, ellipse=TRUE) ##sd ellipse

LocationMDS<-metaMDS(Location.mat, distance="bray", k=2, trymax=35, autotransform=TRUE) ##k is the number of dimensions
LocationMDS ##metaMDS takes eaither a distance matrix or your community matrix (then requires method for 'distance=')

stressplot(LocationMDS)


##pull points from MDS
NMDS1 <- LocationMDS$points[,1] ##also found using scores(LocationMDS)
NMDS2 <- LocationMDS$points[,2]
Location.plot<-cbind(Location.compo, NMDS1, NMDS2)

#plot ordination

tiff("Fig4b.tiff", units="in", width=6, height=5, res=300)
# insert ggplot code

Fig4b<-ggplot(Location.plot, aes(NMDS1, NMDS2, color=Location))+
  geom_point(position=position_jitter(.1), shape=3)+ ##separates overlapping points
  scale_color_brewer(palette="Set1") + #uses colour brewer pallettes
  #scale_color_manual(values=c('#330066', '#CC0066')) + #manually changes points colouration
  stat_ellipse(type='t',size =1)+ ##draws 95% confidence interval ellipses
  theme_classic() #gets rid of gridlines #theme_minimal() #has gridlines
Fig4b
ggsave("Fig4b.tiff", units="in", width=5, height=4, dpi=300, compression = 'lzw')

dev.off()
