**Study:  risk of heart disease in  breast cancer patients
** Author: Haomin YANG, weiwei Bian,....... Kamila Czene
** Purpose: Plot cumulative incidence curve for the outcomes in BC patients**
** Dataset: matched_cohort.dta
** Running environment:P:/ drive 
** Date: 20201007
** Last modified: 20211130
** outcome: heart disease
** output: cif_all.gph 

/*plot the cumulative incidence curve in supplementary figure 2 */


use "libro_match_arry1125.dta", clear
drop if cad_hist==1
stset ed_Arrhythmia, fail(ca_Arrhythmia == 1) origin(bc_diagdate) enter(time bc_diagdate) exit(time mdy(12,29,2017)) scale (365.24) 
stcompet CumInc_group1=ci , compet1(2) by(case)
twoway (line CumInc_group1 _t if case==1 & _d==1,sort lcolor(gs0) connect(step)) ///
(line CumInc_group1 _t if case==0& _d==1,sort lcolor(gs3) lp(dash) connect(step)), ///
 xlabel(0 5 10 15 17, nogrid) ylabel(0(0.05)0.15, nogrid) ///
ytitle("Cumulative incidence") xtitle("Time since index date(years)") ///
title("Arrhythmia") ///
legend(ring(0) position(10) rows(2) symxsize(5) region(lcolor(white) ) ///
label(1 "BC") label(2 "REF") ) graphregion(fcolor(white)) 
cd C:\Users\haoyan\z\other_project\cvd\output
graph save  "cif_11.gph",replace

/*list the cumulative incidence at different time point in supplementary table 2*/
stcomlist,compet1(2) by(case)  at(0.5 1 2 5 10 15) saving("CR_Arrhythmia.dta",replace)
use CR_Arrhythmia.dta,clear
keep if compet==0
gen mod_1 = string(cif*100,"%9.2f") + " (" + string(lb*100,"%9.2f") + "-" + string(ub*100,"%9.2f") + ")"
gen cha="bc"+string(case)
keep _t  cha mod_1
replace _t=0 if _t==0.5
reshape wide mod_1, j(_t)  i(cha)
save "CR_Arrhythmia.dta",replace



use "libro_match_Hf1125.dta", clear
drop if cad_hist==1
stset ed_Heart_fail, fail(ca_Heart_fail == 1) origin(bc_diagdate) enter(time bc_diagdate) exit(time mdy(12,29,2017)) scale (365.24) 
stcompet CumInc_group1=ci , compet1(2) by(case)
twoway (line CumInc_group1 _t if case==1 & _d==1,sort lcolor(gs0) connect(step)) ///
(line CumInc_group1 _t if case==0& _d==1,sort lcolor(gs3) lp(dash) connect(step)), ///
 xlabel(0 5 10 15 17, nogrid) ylabel(0(0.05)0.15, nogrid) ///
ytitle("Cumulative incidence") xtitle("Time since index date (years)") ///
title("Heart Failure") ///
legend(ring(0) position(10) rows(2) symxsize(5) region(lcolor(white) ) ///
label(1 "BC") label(2 "REF") ) graphregion(fcolor(white)) 
cd C:\Users\haoyan\z\other_project\cvd\output
graph save  "cif_21.gph",replace



stcomlist,compet1(2) by(case)  at(0.5 1 2 5 10 15) saving("CR_Heart_fail.dta",replace)
use CR_Heart_fail.dta,clear
keep if compet==0
gen mod_1 = string(cif*100,"%9.2f") + " (" + string(lb*100,"%9.2f") + "-" + string(ub*100,"%9.2f") + ")"
gen cha="bc"+string(case)
keep _t  cha mod_1
replace _t=0 if _t==0.5
reshape wide mod_1, j(_t)  i(cha)
save "CR_Heart_fail.dta",replace

use "libro_match_IHD1125.dta", clear
drop if cad_hist==1
stset ed_IHD, fail(ca_IHD == 1) origin(bc_diagdate) enter(time bc_diagdate) exit(time mdy(12,29,2017)) scale (365.24) 
stcompet CumInc_group1=ci , compet1(2) by(case)
twoway (line CumInc_group1 _t if case==1 & _d==1,sort lcolor(gs0) connect(step)) ///
(line CumInc_group1 _t if case==0& _d==1,sort lcolor(gs3) lp(dash) connect(step)), ///
 xlabel(0 5 10 15 17, nogrid) ylabel(0(0.05)0.15, nogrid) ///
ytitle("Cumulative incidence") xtitle("Time since index date (years)") ///
title("Ischemic heart disease") ///
legend(ring(0) position(10) rows(2) symxsize(5) region(lcolor(white) ) ///
label(1 "BC") label(2 "REF") ) graphregion(fcolor(white)) 
cd C:\Users\haoyan\z\other_project\cvd\output
graph save  "cif_31.gph",replace


stcomlist,compet1(2) by(case)  at(0.5 1 2 5 10 15) saving("CR_IHD.dta",replace)
use CR_IHD.dta,clear
keep if compet==0
gen mod_1 = string(cif*100,"%9.2f") + " (" + string(lb*100,"%9.2f") + "-" + string(ub*100,"%9.2f") + ")"
gen cha="bc"+string(case)
keep _t  cha mod_1
replace _t=0 if _t==0.5
reshape wide mod_1, j(_t)  i(cha)
save "CR_IHD.dta",replace

gr combine    cif_11.gph  cif_21.gph  cif_31.gph , r(1) c(3)



use CR_Arrhythmia.dta,clear
append using   CR_Heart_fail.dta CR_IHD.dta  
save cuminc_all.dta,replace
export excel using "cuminc_all.xls", replace


