from sklearn.decomposition import NMF, non_negative_factorization
from sklearn.preprocessing import normalize
import numpy as np
import sys
import pickle

V = np.genfromtxt(sys.stdin, delimiter=' ')

Vnorm = normalize(V, axis=1, norm='l1')

with open(sys.argv[1], "rb") as fp:
    unpickler = pickle.Unpickler(fp)
    nmf_model = unpickler.load()

W = nmf_model.transform(Vnorm)

Wnorm = normalize(W, axis=1, norm='l1')
np.savetxt(sys.stdout, Wnorm.transpose())
