#!/usr/bin/env Rscript
library(tidyverse)
library(tidymodels)
library(magrittr)
library(knitr)

fname <- commandArgs(TRUE)[1]

d <- read_table2(fname, col_names=F)
names(d)[1] <- "sample"
names(d)[2] <- "type"

d %>%
  rowwise() %>%
  mutate(mean = mean(c_across(starts_with("X"))),
         sd = sd(c_across(starts_with("X")))) %>%
  group_by(sample, mean, sd, type) %>%
  mutate(across(where(is.numeric), ~ (.-mean)/sd, .names = "Z{.col}")) %>%
  ungroup() -> d2

is.nan.data.frame <- function(x)
 do.call(cbind, lapply(x, is.nan))

print(d2[is.nan(d2)])

d2[is.nan(d2)] <- 0

d2 %>% 
  mutate(case=factor(type!="Healthy")) %>%
  ungroup() %>% 
  select(-c(sample,type)) -> foo

folds <- vfold_cv(foo, v = 10, repeats=50)

rcp_Z <- 
  recipe(foo) %>%
  update_role(starts_with("Z"), new_role = "predictor") %>% 
  update_role(case, new_role = "outcome") %>% 
  step_rm(-has_role("outcome"), -has_role("predictor"))

 
svm_model <-
  svm_poly(mode="classification", degree=1) %>%
  set_engine("kernlab")

rcp_list = 
  list("Z"=rcp_Z)

model_list = list("svm_poly"=svm_model)

res <- NULL
for (rcp_name in names(rcp_list)) {
  for (model_name in names(model_list)){
    rcp <- rcp_list[[rcp_name]]
    model <- model_list[[model_name]]
    print(rcp_name)
    print(model_name)

    mr <- workflow() %>%
      add_recipe(rcp) %>%
      add_model(model) %>%
      fit_resamples(folds, control = control_resamples(save_pred = TRUE))

    mr %>% conf_mat_resampled(tidy=F) %>% kable() %>% print()
    mr %>%
      collect_metrics() %>%
      cbind(model=model_name, rcp=rcp_name, fname=commandArgs(TRUE)[1]) %>% 
      rbind(res) -> res
  }
}

res %>% write_tsv(commandArgs(TRUE)[2])




