from sklearn.decomposition import NMF, non_negative_factorization
from sklearn.preprocessing import normalize
import numpy as np
import sys
import pickle
import argparse

parser = argparse.ArgumentParser(description='''

''')
parser.add_argument('pickle_file', type=argparse.FileType('wb'))
parser.add_argument('W_file', type=argparse.FileType('w'))
parser.add_argument('-t', '--tol', type=float, default=1e-7)
parser.add_argument('-i', '--init', type=str, default="random")
parser.add_argument('-r', '--restarts', type=int, default=20)
parser.add_argument('-n', '--n_components', type=int, default=2)
parser.add_argument('-H', '--H_file', type=argparse.FileType('w'), default=None)

args = parser.parse_args()

V = np.genfromtxt(sys.stdin, delimiter=' ')
Vnorm = normalize(V, axis=1, norm='l1')

minModel = None
minErr = 1e100
for i in range(args.restarts):
    model = NMF(n_components=args.n_components, max_iter=10000000, tol=args.tol, init=args.init, beta_loss=1, solver='mu')
    W = model.fit_transform(Vnorm)
    print(i, model.reconstruction_err_)
    if model.reconstruction_err_ < minErr:
        print("best")
        minModel = model
        minErr = model.reconstruction_err_
        minW = W

pickle.dump(minModel, args.pickle_file)
Wnorm = normalize(minW, axis=1, norm='l1')
np.savetxt(args.W_file, Wnorm)

if not (args.H_file is None):
    H = minModel.components_
    np.savetxt(args.H_file, H)

