"""
Load the hdf5 file related to Figure 3A&B and all other analyses and figures working with
neuronal responses as spike density functions (SDFs) from Henke et al. eLife.

The file loads the stored arrays and provides them as numpy arrays.

The source data hdf5 file contains arrays with SDFs for each neuron and each stimulus. 
The arrays have the dimension neurons x number of stimuli x sampling rate (30 bins). 
One array is stored for each the measurement and the reproduction phase. In addition, 
there are the corresponding time points in 3D arrays of the same size.

Also there is an array 'Stimulus durations (s)' that contains the 7 stimulus durations
given in the experiments and that correspond to the second dimension in the data arrays above.

There is another array called 'Cell tags' containing the tags of the cells in the same 
order as in the data arrays. The tags are the same as used in the raw data available
at 
Henke J, Bunk D, von Werder D, Haeusler S, Flanagin V, Thurley K (2021) Data for Distributed coding of duration in rodent prefrontal cortex during time reproduction. G-Node. https://doi.org/10.12751/g-node.tarvrs
"""
__author__ = ("Kay Thurley")
__version__ = "1.0, December 2021"

import h5py

# sdf_data_file = h5py.File('henke_et_al_eLife_sdfs.hdf5', 'r')
sdf_data_file = h5py.File('Figure 3–source data 1.hdf5', 'r')
print(list(sdf_data_file.keys()))

cell_tags = sdf_data_file['Cell tags'][:]
stimulus_durations = sdf_data_file['Stimulus durations (s)'][:]
measurement_sdfs = sdf_data_file['Measurement SDFs'][:]
measurement_time = sdf_data_file['Measurement Time (s)'][:]
reproduction_sdfs = sdf_data_file['Reproduction SDFs'][:]
reproduction_time = sdf_data_file['Reproduction Time (s)'][:]

sdf_data_file.close()