#set directory to location of neuronlist
nl_dir = "C:/"
setwd(nl_dir)

#load packages that are required
library(nat)
library(nat.nblast)
library(NbClust)
library(dendroextras)
library(ggplot2)
library(dendextend)

#load the neuronlist
nl2=readRDS('nl_newlabel.rds')

#check that it is a neuronlist
is.neuronlist(nl2)

#compare all neurons in the neuronlist to each other with nlast
test_scores <- nblast_allbyall(x =nl2, smat = NULL, normalisation = "raw")

#define functions to determine the group number with ward linkage cost and differential of ward linkage cost
plot.hclust.cost <- function(h,k=1:10) {
  
  g <- c(rev(h$height),0)
  
  k <- k[k < length(g)]
  
  plot(k,g[k],ylab = "ward linkage cost",xlab = "clusters", type ="b")
  #write.csv(g,file="Linkage_cost_1-120_groups.csv")
}

plot.hclust.trace <- function(h,k=1:10) {
  
  g <- c(rev(h$height),0)
  
  k <- k[k < length(g)]
  
  #g <- sqrt(g)
  
  if(h$method != "single") {
    
    g <- -diff(g)
    
  }
  
  plot(k,g[k], ylab = "diff ward linkage cost",xlab = "clusters", type = "b")
  #write.csv(g,file="Diff_linkage_cost_1-120_groups.csv")
  
}


#hierarchically cluster based on nblast scores
hc_test <- nhclust(method = "ward.D", scoremat = test_scores)

#draw plots of ward linkage cost and the diff of ward linkage cost and save .csv files with the values
plot.hclust.cost(hc_test, k=1:120)
plot.hclust.trace(hc_test, k=1:120)

# This is the code for the dendrogram in Figure 3, panel A of the SEZ split-GAL4 paper
#install.packages("dendextend"
d_copy_n <- colour_clusters(hc_test, k=6)
#d_copy_n <- colour_clusters(hc_test, k=6, groupLabels = as.roman)
labels(d_copy_n)<-with(nl2[labels(d_copy_n)], Cell_type)

d_copy_n <- set(d_copy_n, "labels_cex", 1.1)
d_copy_n <- set(d_copy_n, "branches_lwd", 3)
d_copy_n <- set(d_copy_n, "nodes_cex", 1)
d_copy_n <- d_copy_n %>%
  y_scale(2)
d_copy_n <- d_copy_n %>%  
  rotate(94:86)  
d_copy_n <- d_copy_n %>%  
  rotate(121:113)  
par(mar=c(5,6,2,1))

ggsave("Fig3_dendr.png", plot = plot(d_copy_n, cex.axis = 1.1), width = 21, height =7, units = "in", dpi = 300)

#Plot neurons in those clusters in 3D (with matching colours)
open3d()
#plot all of the neurons from all of the groups
plot3d(hc_test, k=6, db=nl2, soma = T)
#set zoom and viewpoint
view3d(zoom=.5)
nview3d(viewpoint = c("frontal"),FOV = 0)
clear3d()
#plot individual groups separately
plot3d(hc_test, k=6, groups = 1, db=nl2, soma = T)
clear3d()
plot3d(hc_test, k=6, groups = 2, db=nl2, soma = T)
clear3d()
plot3d(hc_test, k=6, groups = 3, db=nl2, soma = T)
clear3d()
plot3d(hc_test, k=6, groups = 4, db=nl2, soma = T)
clear3d()
plot3d(hc_test, k=6, groups = 5, db=nl2, soma = T)
clear3d()
plot3d(hc_test, k=6, groups = 6, db=nl2, soma = T)
clear3d()
#plot a single cell type
plot3d(nl2, Cell_type == 'FDG', soma = T, col = 'black')
clear3d()
#plot all interneurons
plot3d(nl2, Type == 'interneuron', col = 'red')
clear3d()
#plot all projection neurons with all different colors
plot3d(nl2, Type=='projection neuron', col = nl2$Cell_type)
clear3d()

#make the images in Figure 3B
#load the template brain surface, path below is the path to the file
brain.surf = read.hxsurf("C:/JRC2018_UNISEX_63xOri_8bit_scaled_vxadj_face3500.surf")
plot3d(brain.surf, alpha=.05, col='white')
plot3d(hc_test, k=6, db=nl2, soma = T)
#set zoom and viewpoint, then take snapshots
view3d(zoom=.5)
nview3d(viewpoint = c("frontal"),FOV = 0)
rgl.snapshot("6groups_6_front.png")
nview3d(viewpoint = c("right"),FOV = 0)
rgl.snapshot('6groups_6_side.png')
nview3d(viewpoint = c("dorsal"),FOV = 0)
rgl.snapshot('6groups_6_top.png')
nview3d(viewpoint = c("ventral"),FOV = 0)
rgl.snapshot('6groups_6_bottom.png')
clear3d()


