#Sourcecode for Elife paper Figure 5
#By Dr Charles Agoti
#Last updated 29 June 2022

#clear workspace, upload packages, specify working directory
## The aim of this plot is to show the lineage temporal introduction patterns

rm(list=ls())
library(tidyverse); library(janitor); library(artyfarty); library(lubridate);library(scales)
min <- as.Date("2020-03-01")
max <- as.Date("2021-02-28")

plot_color2=c("#000000","#C0C0C0","#696969","#FF0000","#F2D2BD",
              "#800000","#BA6B57","#C9A9A6","#00FF00","#008000",
              "#edfcf6","#00FFFF","#CCCCFF","#161d78", "#b1bca0","#e8e366", 
              "#FFA500","#abf2f2","#647ac4",  "#e85f9f", "#354a2f", "#9933FF",  "#A4C639","#0000FF", "#f8b198", "#C9A9A6","#FF00FF", "#55ACEE")

Fig_5AE <- read.csv("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Data/Source_data_1_lineages_scale_month.csv")%>%
  mutate(month=as.Date(month, "%Y-%m-%d"))%>%
  ggplot(aes(x=month, y=n, fill=show_lineage))+
  geom_col(position = "fill")+
  scale_fill_manual(values=plot_color2)+
  facet_wrap(~group2, ncol=3)+
  labs(y="Monthly fraction of genomes", x="Month in 2020/21")+
  theme_scientific()+
  geom_vline(xintercept = as.Date("2020-09-16"), size=0.5, linetype="longdash", color="black")+
  scale_x_date(breaks ="2 month", date_minor_breaks="1 month", labels = date_format("%b"), limits = c(min,max))+
  theme(title= element_text(size = 11),
        axis.title.x = element_text(size = 11),
        axis.title.y = element_text(size = 11),
        axis.text.x = element_text(size = 11, angle=0),
        strip.text.x = element_text(size=11),
        axis.text.y = element_text(size = 11),
        plot.title = element_text(hjust = 0.5, size = 11, face="bold"),
        legend.position = "bottom",
        legend.key.size = unit(0.25, "cm"),
        legend.spacing.x = unit(0.20, 'cm'),
        legend.spacing.y = unit(0.20, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        strip.background = element_rect(fill="white", color = "white"),
        panel.spacing.x = unit(1.2,"lines"),
        legend.box.background = element_blank())+
  guides(fill=guide_legend(nrow=2, title = "Lineage", title.position = "top"), size=T)
pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.5/Fig_5AE.pdf", width =12, height = 7.02)
print(Fig_5AE)
dev.off()
Fig_5AE

###
Fig_5F <- read.csv("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Data/Source_data_1_lineages_scale_month.csv")%>%
  mutate(month=as.Date(month, "%Y-%m-%d"))%>%
  ggplot(aes(x=month, y=n, fill=show_lineage))+
  geom_col(position = "fill")+
  scale_fill_manual(values=plot_color2)+
  labs(y="", x="", title="Global (all)")+
  theme_scientific()+
  geom_vline(xintercept = as.Date("2020-09-16"), size=0.5, linetype="longdash", color="black")+
  scale_x_date(breaks ="2 month", date_minor_breaks="1 month", labels = date_format("%b"), limits = c(min,max))+
  theme(title= element_text(size = 11),
        axis.title.x = element_text(size = 11),
        axis.title.y = element_text(size = 11),
        axis.text.x = element_text(size = 11, angle=0),
        strip.text.x = element_text(size=11),
        #axis.text.y = element_text(size = 11),
        axis.text.y = element_blank(),
        axis.ticks.y =element_blank(),
        axis.line.y = element_blank(),
        plot.title = element_text(hjust = 0.5, size = 11, face="bold"),
        legend.position = "none",
        legend.key.size = unit(0.25, "cm"),
        legend.spacing.x = unit(0.20, 'cm'),
        legend.spacing.y = unit(0.20, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        strip.background = element_rect(fill="white", color = "white"),
        panel.spacing.x = unit(1.2,"lines"),
        legend.box.background = element_blank())+
  guides(fill=guide_legend(nrow=2, title = "Lineage", title.position = "top"), size=T)
pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.5/Fig.5F.pdf", width =4, height = 3.25)
print(Fig_5F)
dev.off()
Fig_5F
