(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    342535,       7003]
NotebookOptionsPosition[    331484,       6848]
NotebookOutlinePosition[    331918,       6865]
CellTagsIndexPosition[    331875,       6862]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Advanced", " ", "adenoma", " ", "data"}], " ", "*)"}], " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Gm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"57", ",", " ", "16.8", ",", "6.7", ",", "0.6"}], "}"}], ",", 
       "\n", 
       RowBox[{"{", 
        RowBox[{"62", ",", "18.1", ",", "8.3", ",", "1.0"}], "}"}], ",", "\n", 
       RowBox[{"{", 
        RowBox[{"67", ",", "19.2", ",", "9.3", ",", "1.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"72", ",", "19.9", ",", "10.1", ",", "2.0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"77", ",", "19.1", ",", "10.5", ",", "2.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"58", ",", "17.9", ",", "7.1", ",", "0.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"63", ",", "19.1", ",", "8.7", ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"68", ",", "20.1", ",", "9.7", ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"73", ",", "20.6", ",", "10.3", ",", "2.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"78", ",", "19.6", ",", "10.6", ",", "2.7"}], "}"}]}], 
      "}"}]}], ";"}], " ", "\n", 
   RowBox[{
    RowBox[{"Gf", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"57", ",", "10.1", ",", "3.6", ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"62", ",", "11.4", ",", "4.6", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"67", ",", "12.6", ",", "5.4", ",", "0.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"72", ",", "13.7", ",", "6.2", ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"77", ",", "13.5", ",", "6.8", ",", "1.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"58", ",", "10.9", ",", "3.9", ",", "0.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"63", ",", "12.2", ",", "4.9", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"68", ",", "13.4", ",", "5.6", ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"73", ",", "14.3", ",", "6.4", ",", "1.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"78", ",", "13.9", ",", "7.0", ",", "1.7"}], "}"}]}], "}"}]}],
     ";", 
    RowBox[{"Kadv11", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Gm", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"Gm", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "k"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "3", ",", "4"}], "}"}]}], "]"}], "/", 
          "100"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "Gm", "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Kadv21", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Gf", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"Gf", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "k"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "3", ",", "4"}], "}"}]}], "]"}], "/", 
          "100"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "Gf", "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Kadv1", "=", 
     RowBox[{"Sort", "[", "Kadv11", "]"}]}], ";", " ", 
    RowBox[{"Kadv2", "=", 
     RowBox[{"Sort", "[", "Kadv21", "]"}]}], ";", 
    RowBox[{"Kadvave1", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Kadv1", "+", "Kadv2"}], ")"}], "/", "2"}]}], ";", 
    RowBox[{"Kadvave", "=", 
     RowBox[{"Sort", "[", "Kadvave1", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.849542728401802*^9, 3.849542759046578*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e87e0918-434b-44e2-bd7a-070c4e4db06d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "These", " ", "are", " ", "the", " ", "incidence", " ", "data", " ", "we", 
    " ", "are", " ", "fitting"}], " ", "*)"}], " ", 
  RowBox[{"J0", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", "Kadvave", "}"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"Offset", "[", "10", "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8496065949401007`*^9, 
  3.8496066078492813`*^9}},ExpressionUUID->"f69ac1ab-0baf-4f7e-8c8e-\
f5d8eb966b4b"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           GrayLevel[0]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[10]], {{{57., 
      0.055999999999999994`}}, {{58., 0.0605}}, {{62., 
      0.07200000000000001}}, {{63., 0.076}}, {{67., 0.0835}}, {{68., 
      0.088}}, {{72., 0.097}}, {{73., 0.1}}, {{77., 0.10750000000000001`}}, {{
      78., 0.11}}}]}, {
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, {}}, {
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{56.5625, 0.05300000000000022},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{56.5625, 78.}, {0.05300000000000022, 0.11}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.849542772571281*^9, 3.849543936332732*^9, 
  3.8495488809522963`*^9, 3.8495490827473*^9, 3.849549146910098*^9, 
  3.849549348268263*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"661d731e-3aa9-4dbf-b3e8-cec5c6fccbe5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"K0", "=."}], ";", " ", 
  RowBox[{"u", "=."}], ";", " ", 
  RowBox[{"mu", "=."}], ";", " ", 
  RowBox[{"p", "=."}], ";", " ", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"r0", "[", "i", "]"}], "=."}], ";", 
     RowBox[{
      RowBox[{"d0", "[", "i", "]"}], "=."}], ";", 
     RowBox[{
      RowBox[{"ga", "[", "i", "]"}], "=."}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ";", " ", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"rho", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "=."}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "=."}], ";", " ", 
       RowBox[{
        RowBox[{"mut", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "=."}], ";"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ";", 
  RowBox[{"Kmax1", "=."}], ";", 
  RowBox[{"Kmax2", "=."}], ";", 
  RowBox[{"delta", "=."}], ";", 
  RowBox[{"W1", "=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], ")"}], "/", 
      "Kmax1"}]}], ")"}]}], ";", 
  RowBox[{"W2", "=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], ")"}], "/", 
      "Kmax2"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8219007172559547`*^9, 3.82190072194053*^9}, {
  3.821900771143792*^9, 3.82190083261073*^9}, {3.822751604211878*^9, 
  3.8227516236883497`*^9}, {3.822751795701623*^9, 3.822751796209306*^9}, {
  3.82275184496222*^9, 3.822751845090851*^9}, {3.847555794531014*^9, 
  3.847555819431945*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"680b91a2-71ec-4cd9-9c08-250da15d38ab"],

Cell[BoxData[
 TemplateBox[{
  "Unset", "norep", 
   "\"Assignment on \\!\\(\\*RowBox[{\\\"r0\\\"}]\\) for \
\\!\\(\\*RowBox[{\\\"r0\\\", \\\"[\\\", \\\"1\\\", \\\"]\\\"}]\\) not \
found.\"", 2, 4, 1, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.821900785845344*^9, 3.821900832989723*^9}, 
   3.8219084770376577`*^9, 3.821913934039324*^9, 3.82199920173344*^9, 
   3.82200042436294*^9, 3.822012060717566*^9, 3.822055314480414*^9, 
   3.822057801510556*^9, 3.822074384499372*^9, 3.8220744342658653`*^9, 
   3.8221422702122173`*^9, 3.822149854140437*^9, 3.8226653401307907`*^9, 
   3.82266569776163*^9, 3.822666309160841*^9, 3.822672552426071*^9, 
   3.8226858860022*^9, 3.822750320961343*^9, 3.8227504608234167`*^9, 
   3.822751518003265*^9, {3.822751616487254*^9, 3.822751624168354*^9}, 
   3.8227517474086246`*^9, 3.822751796812607*^9, 3.8227518460856133`*^9, 
   3.823725762863351*^9, 3.823739331683414*^9, 3.823782225817688*^9, 
   3.823785496858891*^9, 3.823785792071301*^9, 3.823786164943256*^9, 
   3.8237863537012033`*^9, 3.823786742569347*^9, 3.823787831198485*^9, 
   3.823787914014887*^9, 3.823872092974762*^9, 3.823880390136322*^9, 
   3.847210910003153*^9, 3.8472896024442587`*^9, 3.8475367848098507`*^9, {
   3.8475557981225967`*^9, 3.847555820011994*^9}, 3.847834774816288*^9, 
   3.849542843219433*^9, 3.8495438884611197`*^9, 3.849543937684496*^9, 
   3.8495488810129423`*^9, 3.849549082784309*^9, 3.849549146970646*^9, 
   3.849549348311051*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ef322ff2-76a2-405b-8f29-1cc3f42e7a59"],

Cell[BoxData[
 TemplateBox[{
  "Unset", "norep", 
   "\"Assignment on \\!\\(\\*RowBox[{\\\"d0\\\"}]\\) for \
\\!\\(\\*RowBox[{\\\"d0\\\", \\\"[\\\", \\\"1\\\", \\\"]\\\"}]\\) not \
found.\"", 2, 4, 2, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.821900785845344*^9, 3.821900832989723*^9}, 
   3.8219084770376577`*^9, 3.821913934039324*^9, 3.82199920173344*^9, 
   3.82200042436294*^9, 3.822012060717566*^9, 3.822055314480414*^9, 
   3.822057801510556*^9, 3.822074384499372*^9, 3.8220744342658653`*^9, 
   3.8221422702122173`*^9, 3.822149854140437*^9, 3.8226653401307907`*^9, 
   3.82266569776163*^9, 3.822666309160841*^9, 3.822672552426071*^9, 
   3.8226858860022*^9, 3.822750320961343*^9, 3.8227504608234167`*^9, 
   3.822751518003265*^9, {3.822751616487254*^9, 3.822751624168354*^9}, 
   3.8227517474086246`*^9, 3.822751796812607*^9, 3.8227518460856133`*^9, 
   3.823725762863351*^9, 3.823739331683414*^9, 3.823782225817688*^9, 
   3.823785496858891*^9, 3.823785792071301*^9, 3.823786164943256*^9, 
   3.8237863537012033`*^9, 3.823786742569347*^9, 3.823787831198485*^9, 
   3.823787914014887*^9, 3.823872092974762*^9, 3.823880390136322*^9, 
   3.847210910003153*^9, 3.8472896024442587`*^9, 3.8475367848098507`*^9, {
   3.8475557981225967`*^9, 3.847555820011994*^9}, 3.847834774816288*^9, 
   3.849542843219433*^9, 3.8495438884611197`*^9, 3.849543937684496*^9, 
   3.8495488810129423`*^9, 3.849549082784309*^9, 3.849549146970646*^9, 
   3.849549348335339*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ce3bf1f7-e4aa-48cb-b279-a6e113578464"],

Cell[BoxData[
 TemplateBox[{
  "Unset", "norep", 
   "\"Assignment on \\!\\(\\*RowBox[{\\\"ga\\\"}]\\) for \
\\!\\(\\*RowBox[{\\\"ga\\\", \\\"[\\\", \\\"1\\\", \\\"]\\\"}]\\) not \
found.\"", 2, 4, 3, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.821900785845344*^9, 3.821900832989723*^9}, 
   3.8219084770376577`*^9, 3.821913934039324*^9, 3.82199920173344*^9, 
   3.82200042436294*^9, 3.822012060717566*^9, 3.822055314480414*^9, 
   3.822057801510556*^9, 3.822074384499372*^9, 3.8220744342658653`*^9, 
   3.8221422702122173`*^9, 3.822149854140437*^9, 3.8226653401307907`*^9, 
   3.82266569776163*^9, 3.822666309160841*^9, 3.822672552426071*^9, 
   3.8226858860022*^9, 3.822750320961343*^9, 3.8227504608234167`*^9, 
   3.822751518003265*^9, {3.822751616487254*^9, 3.822751624168354*^9}, 
   3.8227517474086246`*^9, 3.822751796812607*^9, 3.8227518460856133`*^9, 
   3.823725762863351*^9, 3.823739331683414*^9, 3.823782225817688*^9, 
   3.823785496858891*^9, 3.823785792071301*^9, 3.823786164943256*^9, 
   3.8237863537012033`*^9, 3.823786742569347*^9, 3.823787831198485*^9, 
   3.823787914014887*^9, 3.823872092974762*^9, 3.823880390136322*^9, 
   3.847210910003153*^9, 3.8472896024442587`*^9, 3.8475367848098507`*^9, {
   3.8475557981225967`*^9, 3.847555820011994*^9}, 3.847834774816288*^9, 
   3.849542843219433*^9, 3.8495438884611197`*^9, 3.849543937684496*^9, 
   3.8495488810129423`*^9, 3.849549082784309*^9, 3.849549146970646*^9, 
   3.8495493483406363`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cbe32c40-79a6-4ebb-b866-10e7d80f1ffd"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Unset\\\", \\\"::\\\", \
\\\"norep\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 4, 4, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.821900785845344*^9, 3.821900832989723*^9}, 
   3.8219084770376577`*^9, 3.821913934039324*^9, 3.82199920173344*^9, 
   3.82200042436294*^9, 3.822012060717566*^9, 3.822055314480414*^9, 
   3.822057801510556*^9, 3.822074384499372*^9, 3.8220744342658653`*^9, 
   3.8221422702122173`*^9, 3.822149854140437*^9, 3.8226653401307907`*^9, 
   3.82266569776163*^9, 3.822666309160841*^9, 3.822672552426071*^9, 
   3.8226858860022*^9, 3.822750320961343*^9, 3.8227504608234167`*^9, 
   3.822751518003265*^9, {3.822751616487254*^9, 3.822751624168354*^9}, 
   3.8227517474086246`*^9, 3.822751796812607*^9, 3.8227518460856133`*^9, 
   3.823725762863351*^9, 3.823739331683414*^9, 3.823782225817688*^9, 
   3.823785496858891*^9, 3.823785792071301*^9, 3.823786164943256*^9, 
   3.8237863537012033`*^9, 3.823786742569347*^9, 3.823787831198485*^9, 
   3.823787914014887*^9, 3.823872092974762*^9, 3.823880390136322*^9, 
   3.847210910003153*^9, 3.8472896024442587`*^9, 3.8475367848098507`*^9, {
   3.8475557981225967`*^9, 3.847555820011994*^9}, 3.847834774816288*^9, 
   3.849542843219433*^9, 3.8495438884611197`*^9, 3.849543937684496*^9, 
   3.8495488810129423`*^9, 3.849549082784309*^9, 3.849549146970646*^9, 
   3.849549348345585*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f600a616-4e0f-45e5-921c-782c63aed60b"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
    RowBox[{
     RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
    RowBox[{
     RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "Kmax2"]}]], "Output",
 CellChangeTimes->{{3.8227516165171556`*^9, 3.822751624193109*^9}, 
   3.822751747431918*^9, 3.82275179683676*^9, 3.822751846109276*^9, 
   3.8237257628847017`*^9, 3.823739331704125*^9, 3.823782225838985*^9, 
   3.8237854968801003`*^9, 3.82378579209385*^9, 3.823786164966155*^9, 
   3.8237863537247877`*^9, 3.823786742591895*^9, 3.823787831219206*^9, 
   3.8237879140379953`*^9, 3.823872092995922*^9, 3.823880390159092*^9, 
   3.847210910032154*^9, 3.847289602474133*^9, 3.847536784838729*^9, {
   3.8475557981509*^9, 3.847555820050161*^9}, 3.847834774847412*^9, 
   3.849542843251267*^9, 3.849543888487026*^9, 3.8495439377111692`*^9, 
   3.849548881070767*^9, 3.849549082812456*^9, 3.849549147012663*^9, 
   3.84954934835334*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"a6ff4938-7293-4582-8f0c-cfb5a13f2fc3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Ncrypts", "=."}], ";", " ", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"in", "[", "i", "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "i", "]"}], "[", "0", "]"}], "\[Equal]", "0"}]}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "6"}], "}"}]}], "]"}], ";", " ", 
   RowBox[{
    RowBox[{"in", "[", "1", "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "[", "1", "]"}], "[", "0", "]"}], "\[Equal]", 
     "Ncrypts"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"14c3dcce-be25-4433-9563-759a20ce886b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"eq", "[", "1", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{"0", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"R", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "+", 
         RowBox[{"R", "[", 
          RowBox[{"1", ",", "4"}], "]"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}]}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"eq", "[", "2", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"1", ",", "2"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{"0", "*", 
       RowBox[{"ga", "[", "2", "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"R", "[", 
          RowBox[{"2", ",", "5"}], "]"}], "+", 
         RowBox[{"R", "[", 
          RowBox[{"2", ",", "3"}], "]"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"eq", "[", "3", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"2", ",", "3"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"ga", "[", "3", "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "*", "W1"}], "-", 
      RowBox[{"delta", "*", 
       RowBox[{
        RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"3", ",", "6"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}]}]}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"eq", "[", "4", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"1", ",", "4"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"ga", "[", "4", "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "*", "W2"}], "-", 
      RowBox[{"delta", "*", 
       RowBox[{
        RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"4", ",", "5"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}]}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"eq", "[", "5", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"2", ",", "5"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"4", ",", "5"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"ga", "[", "4", "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}], "*", "W2"}], "-", 
      RowBox[{"delta", "*", 
       RowBox[{
        RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"5", ",", "6"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}]}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"eq", "[", "6", "]"}], "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"n", "[", "6", "]"}], "[", "t", "]"}], ",", "t"}], "]"}], 
     "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"5", ",", "6"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"3", ",", "6"}], "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"ga", "[", "6", "]"}], "*", 
       RowBox[{
        RowBox[{"n", "[", "6", "]"}], "[", "t", "]"}]}]}]}]}], ";"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.8219010774592953`*^9, 3.821901097047111*^9}, {
   3.821901772508871*^9, 3.821901923784615*^9}, {3.821901961090354*^9, 
   3.821902045755724*^9}, {3.821913999564899*^9, 3.821914000850603*^9}, {
   3.822000416374132*^9, 3.822000491288059*^9}, 3.822000777521377*^9, {
   3.822057844535811*^9, 3.822057872711205*^9}, {3.822149862126527*^9, 
   3.8221498682812243`*^9}, {3.8226725604863443`*^9, 3.822672598247571*^9}, {
   3.822672689893022*^9, 3.822672740215681*^9}, {3.822672778224484*^9, 
   3.822672868651772*^9}, {3.8227502854718018`*^9, 3.822750297244977*^9}, {
   3.822751857312263*^9, 3.822751877749814*^9}, {3.847555828999666*^9, 
   3.84755583316963*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"3d046b4c-7a9b-43e1-9e38-277c35044da0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"These", " ", "are", " ", "the", " ", "ODEs"}], " ", "*)"}], " ", 
  RowBox[{"EEQ", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eq", "[", "i", "]"}], ",", 
        RowBox[{"in", "[", "i", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]}]}]], "Input",\

 CellChangeTimes->{{3.822750468656082*^9, 3.8227504776295643`*^9}, {
  3.849606615119492*^9, 
  3.849606619490576*^9}},ExpressionUUID->"9ccc8ecf-c33f-4190-a63b-\
a1edb6a295df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"n", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{"1", ",", "4"}], "]"}]}], ")"}]}], " ", 
     RowBox[{
      RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "1", "]"}], "[", "0", "]"}], "\[Equal]", "Ncrypts"}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"n", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"1", ",", "2"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"2", ",", "3"}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{"2", ",", "5"}], "]"}]}], ")"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "2", "]"}], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"n", "[", "3", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"2", ",", "3"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{"delta", " ", 
      RowBox[{
       RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"3", ",", "6"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"ga", "[", "3", "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "Kmax1"]}], 
       ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "3", "]"}], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"n", "[", "4", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"1", ",", "4"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{"delta", " ", 
      RowBox[{
       RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"4", ",", "5"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"ga", "[", "4", "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "Kmax2"]}], 
       ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "4", "]"}], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"n", "[", "5", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"2", ",", "5"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"4", ",", "5"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{"delta", " ", 
      RowBox[{
       RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"5", ",", "6"}], "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"ga", "[", "4", "]"}], " ", 
      RowBox[{
       RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}]}], "Kmax2"]}], 
       ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "[", "5", "]"}], "[", "0", "]"}], "\[Equal]", "0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.82275048187945*^9, 3.822751528241493*^9, 3.822751627272295*^9, 
   3.8227517526975727`*^9, 3.82275179891398*^9, 3.822751879894806*^9, 
   3.823725766427484*^9, 3.823739335055242*^9, 3.823782228055976*^9, 
   3.8237854986398687`*^9, 3.82378579409588*^9, 3.823786201033391*^9, 
   3.823786359807013*^9, 3.823786746839717*^9, 3.823787836384942*^9, 
   3.823787918403605*^9, 3.823872095097597*^9, 3.8238803932728577`*^9, {
   3.8472109067303963`*^9, 3.84721091470289*^9}, 3.847289605064191*^9, 
   3.84753678766605*^9, 3.847555840062571*^9, 3.847834781524537*^9, 
   3.849543944455288*^9, 3.849548881147963*^9, 3.849549082860001*^9, 
   3.8495491470647097`*^9, 3.849549348399498*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"d6fd0595-0d7a-4da5-ba33-5fe87f20e45b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "=", 
       RowBox[{"K0", "*", 
        RowBox[{"r0", "[", "i", "]"}], "*", 
        RowBox[{"mut", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "*", 
        RowBox[{"rho", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"mut", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "=", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ";", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "=", 
   RowBox[{"2", "*", "u"}]}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"2", ",", "3"}], "]"}], "=", 
   RowBox[{"u", "+", "p"}]}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"1", ",", "4"}], "]"}], "=", "mu"}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"2", ",", "5"}], "]"}], "=", "mu"}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"3", ",", "6"}], "]"}], "=", "mu"}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"4", ",", "5"}], "]"}], "=", 
   RowBox[{"2", "*", "u"}]}], ";", " ", 
  RowBox[{
   RowBox[{"mut", "[", 
    RowBox[{"5", ",", "6"}], "]"}], "=", 
   RowBox[{"u", "+", "p"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"rho", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"d0", "[", "j", "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"r0", "[", "i", "]"}], "/", 
             RowBox[{"r0", "[", "j", "]"}]}], "/", 
            RowBox[{"d0", "[", "i", "]"}]}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"d0", "[", "j", "]"}], "*", 
             RowBox[{
              RowBox[{
               RowBox[{"r0", "[", "i", "]"}], "/", 
               RowBox[{"r0", "[", "j", "]"}]}], "/", 
              RowBox[{"d0", "[", "i", "]"}]}]}], ")"}], "^", "K0"}]}], 
         ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.821900708335594*^9, 3.82190071399109*^9}, {
  3.821900826154557*^9, 3.821900847249208*^9}, {3.8219010108984833`*^9, 
  3.8219010555116167`*^9}, {3.8227505468427763`*^9, 3.822750565727356*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"299feee6-2365-4b3d-b905-87d079626fca"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \\\"0\\\"]\\) \
encountered.\"", 2, 8, 5, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348441712*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b8987c35-0969-4c4b-b179-c43e6ccc5afc"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{\\\"0\\\", \\\" \\\", \
\\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 8, 6, 20742840112063043890, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348447949*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"6963438c-237b-4b41-9c8f-9b46be23d60d"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \\\"0\\\"]\\) \
encountered.\"", 2, 8, 7, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348453762*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1c79109d-61bd-467b-a6e3-436f03a6ca89"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{\\\"0\\\", \\\" \\\", \
\\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 8, 8, 20742840112063043890, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348458633*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e8fb7ec8-d9d5-4d60-b0b9-ba05a8cb706a"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \\\"0\\\"]\\) \
encountered.\"", 2, 8, 9, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348463337*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e82986bc-75b3-40a2-8823-d3029d49fffe"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Power\\\", \\\"::\\\", \
\\\"infy\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 8, 10, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.849549348468162*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b0622c4d-74d9-4877-991c-a811370485d2"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{\\\"0\\\", \\\" \\\", \
\\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 8, 11, 20742840112063043890, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.8495493484731073`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"ac6c37bb-11a5-4cd8-81bd-3b16c2cb4b97"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Infinity\\\", \
\\\"::\\\", \\\"indet\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 8, 12, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.822750566057805*^9, 3.822751530695416*^9, 
  3.822751628370448*^9, 3.8227517564679527`*^9, 3.8227518001120977`*^9, 
  3.822751881295884*^9, 3.823725768380625*^9, 3.8237393371353197`*^9, 
  3.8237822334127617`*^9, 3.823785500510586*^9, 3.823785796596332*^9, 
  3.8237862040353737`*^9, 3.8237863617615013`*^9, 3.823786748994779*^9, 
  3.823787839234659*^9, 3.823787921399294*^9, 3.82387209679879*^9, 
  3.823880394027046*^9, 3.847210917201676*^9, 3.8472896108592787`*^9, 
  3.8475367894095097`*^9, 3.847555846219387*^9, 3.847834783655816*^9, 
  3.849543947382716*^9, 3.849548881198217*^9, 3.8495490828975487`*^9, 
  3.849549147111608*^9, 3.8495493484777937`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"8b7aaa47-8a6c-4116-89d0-e10aa005c890"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rbase", "=."}], ";", 
  RowBox[{"multAPC1", "=."}], ";", " ", 
  RowBox[{"multAPC2", "=."}], ";", " ", 
  RowBox[{"multRAS", "=."}], ";", " ", 
  RowBox[{"ga3", "=."}], ";", " ", 
  RowBox[{"ga4", "=."}], ";", 
  RowBox[{"sub", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", "\[Rule]", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "7"}], ")"}]}]}], ",", 
      RowBox[{"p", "\[Rule]", "0."}], ",", 
      RowBox[{"mu", "\[Rule]", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "9"}], ")"}]}]}], ",", 
      RowBox[{"K0", "\[Rule]", "7"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"d0", "[", "i", "]"}], "\[Rule]", "1."}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "1", "]"}], "\[Rule]", "rbase"}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "2", "]"}], "\[Rule]", 
       RowBox[{"multAPC1", "*", "rbase"}]}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "3", "]"}], "\[Rule]", 
       RowBox[{"multAPC2", "*", "rbase"}]}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "4", "]"}], "\[Rule]", 
       RowBox[{"multRAS", "*", "rbase"}]}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "5", "]"}], "\[Rule]", 
       RowBox[{"multRAS", "*", "multAPC1", "*", "rbase"}]}], ",", 
      RowBox[{
       RowBox[{"r0", "[", "6", "]"}], "\[Rule]", 
       RowBox[{"multRAS", "*", "multAPC2", "*", "rbase"}]}], ",", 
      RowBox[{"Ncrypts", "\[Rule]", 
       RowBox[{"10.", "^", "7"}]}]}], "}"}], "]"}]}], ";", 
  RowBox[{"subdiv", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"ga", "[", "2", "]"}], "\[Rule]", 
      RowBox[{"10.", "^", 
       RowBox[{"(", 
        RowBox[{"-", "3"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"ga", "[", "3", "]"}], "\[Rule]", 
      RowBox[{"ga3", "+", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"ga", "[", "4", "]"}], "\[Rule]", 
      RowBox[{"ga4", "+", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"ga", "[", "5", "]"}], "\[Rule]", 
      RowBox[{"ga4", "+", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"ga", "[", "6", "]"}], "\[Rule]", 
      RowBox[{"ga3", "+", "ga4", "+", 
       RowBox[{"10.", "^", 
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}]}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.822001389612699*^9, 3.822001391419957*^9}, {
   3.822011763356172*^9, 3.822011776242856*^9}, {3.822011815913303*^9, 
   3.822011856202443*^9}, {3.8220119349909983`*^9, 3.8220119391093407`*^9}, {
   3.822142801557887*^9, 3.822142806942523*^9}, {3.8221429826782312`*^9, 
   3.822142984943088*^9}, {3.822751903003868*^9, 3.8227519770742683`*^9}, 
   3.8478347972056427`*^9, 3.849544079417569*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"b096e414-0313-478e-b8d6-af1088ecaabd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"paramsNoGa", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"delta", "\[Rule]", "0.05"}], ",", 
    RowBox[{"Kmax1", "\[Rule]", "1000"}], ",", 
    RowBox[{"Kmax2", "\[Rule]", "1000"}], ",", 
    RowBox[{"multAPC1", "\[Rule]", "1.6"}], ",", 
    RowBox[{"multAPC2", "\[Rule]", "3.76"}], ",", 
    RowBox[{"multRAS", "\[Rule]", "3.54"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8237821720505247`*^9, 3.823782180555138*^9}, 
   3.8237824042067738`*^9, 3.8237855395933933`*^9, 3.823785581137244*^9, {
   3.823873173252924*^9, 3.823873173527197*^9}, {3.82387326415821*^9, 
   3.823873274212552*^9}, {3.823880367281076*^9, 3.823880376250374*^9}, {
   3.847219793193181*^9, 3.84721980665932*^9}, {3.847219885922963*^9, 
   3.847219908178465*^9}, {3.848097461378784*^9, 3.848097466905869*^9}, {
   3.849544443048522*^9, 3.8495444448782988`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"adfcbdbb-efbf-4fed-a0be-a698577dc1d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"delta", "\[Rule]", "0.05`"}], ",", 
   RowBox[{"Kmax1", "\[Rule]", "1000"}], ",", 
   RowBox[{"Kmax2", "\[Rule]", "1000"}], ",", 
   RowBox[{"multAPC1", "\[Rule]", "1.6`"}], ",", 
   RowBox[{"multAPC2", "\[Rule]", "3.76`"}], ",", 
   RowBox[{"multRAS", "\[Rule]", "3.54`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8237821837999268`*^9, 3.823782246002077*^9, 3.823782341016363*^9, 
   3.823782404599688*^9, 3.823785582599393*^9, 3.823786367641199*^9, 
   3.8237867629281054`*^9, 3.8237878435990667`*^9, 3.823787926425407*^9, 
   3.823872099730781*^9, 3.8238731738828983`*^9, {3.823880376663726*^9, 
   3.82388039687353*^9}, 3.8472109236572857`*^9, 3.847219908830843*^9, 
   3.8472896539374037`*^9, 3.848097467918415*^9, 3.8495441055132713`*^9, 
   3.849544445354083*^9, 3.8495488822728453`*^9, 3.8495490829780407`*^9, 
   3.849549147192377*^9, 3.849549310319811*^9, 3.849549348513546*^9, 
   3.849606059070162*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"3b3fa749-381e-49d6-bebf-3df04810f61c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gamin", "=", "0"}], ";", " ", 
   RowBox[{"gamax", "=", "0.4"}], ";", " ", 
   RowBox[{"Nga", "=", "50"}], ";", " ", 
   RowBox[{"shga", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"gamax", "-", "gamin"}], ")"}], "/", "Nga"}]}], ";"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.8495442146337748`*^9, 3.84954421538548*^9}, {
  3.849544345382554*^9, 3.8495443458292303`*^9}, {3.849549304090332*^9, 
  3.849549304458856*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"4c2af046-398f-41d4-830d-9d55990fbb8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Fix", " ", "Kmax1"}], ",", " ", "Kmax2", ",", " ", 
    RowBox[{"and", " ", "fit", " ", "gamma"}]}], " ", "*)"}], " ", 
  RowBox[{
   RowBox[{"Rmin", "=", 
    RowBox[{"365", "/", "5"}]}], ";", " ", 
   RowBox[{"Rmax", "=", "300"}], ";", 
   RowBox[{"Ni", "=", "30"}], ";", 
   RowBox[{"sh", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Rmax", "-", "Rmin"}], ")"}], "/", "Ni"}]}], ";", " ", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Rbase", "=", 
       RowBox[{"Rmin", "+", 
        RowBox[{"i", "*", "sh"}]}]}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"gg3", "=", 
            RowBox[{"gamin", "+", 
             RowBox[{"i1", "*", "shga"}]}]}], ";", " ", 
           RowBox[{"gg4", "=", 
            RowBox[{"gamin", "+", 
             RowBox[{"i2", "*", "shga"}]}]}], ";", 
           RowBox[{"Ot", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"EEQ", "/.", "sub"}], "/.", "subdiv"}], "/.", 
                  "paramsNoGa"}], "/.", 
                 RowBox[{"{", 
                  RowBox[{"rbase", "\[Rule]", "Rbase"}], "}"}]}], "/.", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ga3", "\[Rule]", "gg3"}], ",", 
                  RowBox[{"ga4", "\[Rule]", "gg4"}]}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                 RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ",", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"n", "[", "i", "]"}], "[", "t", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", " ", 
           RowBox[{"n6", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "6", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{"n5", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n4", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n3", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{"n2", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n1", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"OtvP", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"P", "[", "t", "]"}], ",", "t"}], "]"}], 
                 "\[Equal]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"5", ",", "6"}], "]"}], "*", "n5"}], "+", 
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"3", ",", "6"}], "]"}], "*", "n3"}]}], ")"}], "/.",
                     "sub"}], "/.", "subdiv"}], "/.", "paramsNoGa"}], "/.", 
                    RowBox[{"{", 
                    RowBox[{"rbase", "\[Rule]", "Rbase"}], "}"}]}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ga3", "\[Rule]", "gg3"}], ",", 
                    RowBox[{"ga4", "\[Rule]", "gg4"}]}], "}"}]}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                    RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ")"}], "*", 
                  
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"P", "[", "t", "]"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"P", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
              ",", 
              RowBox[{"P", "[", "t", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", 
           RowBox[{
            RowBox[{"PPPadvX", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{"P", "[", "t", "]"}], "/.", 
             RowBox[{"OtvP", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{
            RowBox[{"PPPadv", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"0.05", "/", "1.01199"}]}], ")"}], "*", 
              RowBox[{"PPPadvX", "[", 
               RowBox[{"i", ",", "i1", ",", "i2"}], "]"}]}], "/.", 
             RowBox[{"{", 
              RowBox[{"t", "\[Rule]", 
               RowBox[{"t", "-", "4.79"}]}], 
              RowBox[{"(*", " ", "11.97", "*)"}], "}"}]}]}], ";", " ", 
           RowBox[{
            RowBox[{"FullE", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"PPPadv", "[", 
                    RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "/.", 
                   RowBox[{"{", 
                    RowBox[{"t", "\[Rule]", 
                    RowBox[{"Kadvave", "[", 
                    RowBox[{"[", 
                    RowBox[{"k", ",", "1"}], "]"}], "]"}]}], "}"}]}], ")"}], 
                 "-", 
                 RowBox[{"Kadvave", "[", 
                  RowBox[{"[", 
                   RowBox[{"k", ",", "2"}], "]"}], "]"}]}], ")"}], "^", "2"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "1", ",", 
                RowBox[{
                 RowBox[{"Length", "[", "Kadvave", "]"}], "-", "2"}]}], 
               "}"}]}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "0", ",", "Nga"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i2", ",", "0", ",", "Nga"}], "}"}]}], "]"}], ";", 
      RowBox[{"Print", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Ni"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.823740539403901*^9, 3.823740558851613*^9}, {
   3.8237406639129972`*^9, 3.8237406854676027`*^9}, {3.823740791684186*^9, 
   3.8237408904825363`*^9}, {3.823740930085433*^9, 3.8237409326241407`*^9}, {
   3.823741001437001*^9, 3.8237410401627407`*^9}, {3.823741290951734*^9, 
   3.823741291269815*^9}, {3.823741322653777*^9, 3.82374132430864*^9}, {
   3.823741359496435*^9, 3.823741429631186*^9}, {3.823741475132635*^9, 
   3.823741475426045*^9}, {3.823741510522271*^9, 3.8237415323758707`*^9}, {
   3.823742338416526*^9, 3.82374234722024*^9}, {3.823742542937833*^9, 
   3.823742543412828*^9}, {3.823773669785063*^9, 3.823773673184052*^9}, {
   3.823775712399177*^9, 3.8237757128044653`*^9}, {3.823775771584511*^9, 
   3.823775784643126*^9}, {3.8237770826574183`*^9, 3.823777087268256*^9}, {
   3.8237781919388638`*^9, 3.8237781943838987`*^9}, {3.8237788938942738`*^9, 
   3.823778915649535*^9}, 3.823782187947082*^9, {3.823782345279235*^9, 
   3.823782346858636*^9}, {3.823782527163849*^9, 3.823782533795456*^9}, {
   3.823782689369225*^9, 3.823782689883466*^9}, {3.823785592024097*^9, 
   3.8237857420099688`*^9}, {3.823786374700376*^9, 3.823786379462928*^9}, 
   3.823786427242969*^9, {3.82378653789837*^9, 3.823786562873047*^9}, 
   3.8237866281364117`*^9, 3.823787685515657*^9, {3.823788036672035*^9, 
   3.823788059537241*^9}, {3.8237881881160097`*^9, 3.823788189597063*^9}, {
   3.8237884609350367`*^9, 3.823788505281007*^9}, {3.823795760366878*^9, 
   3.823795766745647*^9}, {3.823795821875064*^9, 3.823795828221067*^9}, {
   3.823796033729549*^9, 3.823796033998296*^9}, {3.823872154622699*^9, 
   3.823872156224904*^9}, {3.8472111200074177`*^9, 3.84721114444987*^9}, {
   3.8472199566624002`*^9, 3.847220122777562*^9}, {3.847220175457835*^9, 
   3.847220182350625*^9}, {3.847220247657798*^9, 3.847220252929018*^9}, {
   3.847220412914587*^9, 3.847220445300713*^9}, {3.847221626807235*^9, 
   3.847221627182523*^9}, {3.847221914551855*^9, 3.8472219158871803`*^9}, {
   3.8472221416954308`*^9, 3.847222147112031*^9}, {3.8472392772693377`*^9, 
   3.847239277626576*^9}, {3.847239461751514*^9, 3.8472394620682898`*^9}, {
   3.847239636657604*^9, 3.847239657122932*^9}, {3.847239850893317*^9, 
   3.847239863900597*^9}, {3.84728968365375*^9, 3.847289690944364*^9}, {
   3.847290342956951*^9, 3.847290346432467*^9}, {3.848097496293027*^9, 
   3.8480974966215897`*^9}, {3.8480975345339613`*^9, 3.848097535064591*^9}, 
   3.8495441013963633`*^9, {3.8495443557524652`*^9, 3.849544356009727*^9}, {
   3.849544681217622*^9, 3.849544693676578*^9}, {3.849544967722267*^9, 
   3.849544970255974*^9}, {3.849549128508897*^9, 3.849549128822647*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"94fba39d-a2c6-4763-b571-f0d0b9b49d2b"],

Cell[CellGroupData[{

Cell[BoxData["0"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606074855777*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ea391a02-4522-4411-9d40-bb51b07f01f1"],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.84960608688966*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8e935d4d-a776-46bd-bb65-d822bc4b8d02"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606098565769*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"deefc54f-889b-4be2-8112-ed527255a770"],

Cell[BoxData["3"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606109721389*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d78c01e0-83f3-4f4b-a9e8-2e26c62f20ac"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606120944734*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"3a7bfc39-63bf-4f25-a6dd-13c72b15a60c"],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606132399489*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"866ccea0-5944-4e8f-b08d-f7d6575752ab"],

Cell[BoxData["6"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606144020788*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"5494aca7-3d63-4e55-82b6-e81136569f22"],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606155647526*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8b7e4253-4167-480d-82f8-b4a4e08a941a"],

Cell[BoxData["8"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606167118976*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"098b261b-24a3-4b68-b036-0f38bc65e973"],

Cell[BoxData["9"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606178727654*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9f11a185-f29c-417e-a930-f5546c29bd48"],

Cell[BoxData["10"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606190411289*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8a360d03-9bca-4ea9-b862-913062007cd9"],

Cell[BoxData["11"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606202183996*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"7725d007-6358-4dd7-8812-0b5c46e23b47"],

Cell[BoxData["12"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606213854046*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"4361a173-f46b-40e8-936a-0c883eceef44"],

Cell[BoxData["13"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496062256160393`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"4af16092-0839-4fc1-a091-1b4d3f570a57"],

Cell[BoxData["14"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606237245862*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"c32b416a-e41b-497e-baa6-f207863d7615"],

Cell[BoxData["15"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606248766902*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"718e5ec6-c742-42ac-abb0-5fc230466f2b"],

Cell[BoxData["16"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606260272715*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e4264b0e-8c37-4ad0-808b-4418eaa0f40c"],

Cell[BoxData["17"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496062717497787`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"7ccc1b6c-7f38-4619-9b78-637d187e7fae"],

Cell[BoxData["18"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496062832475147`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"5ef6370a-7400-4db7-9f64-d8a0b7c5155e"],

Cell[BoxData["19"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606295085454*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"1862f247-6825-4f1b-9456-448989fffb27"],

Cell[BoxData["20"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496063070774107`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"79dafb09-06df-42ef-8fa4-7a3f45608766"],

Cell[BoxData["21"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606319174148*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"aef36aaa-381b-4823-a538-fcf2d1e7d5e9"],

Cell[BoxData["22"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606331356001*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ec8c6dc9-843c-4bc6-837a-4440cbb6c09c"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.84960634329696*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"606c06c1-d768-4d48-aebb-5eeeb64cd988"],

Cell[BoxData["24"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606355394987*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f9badc88-7e60-46cc-9763-d07a425d3966"],

Cell[BoxData["25"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496063675785303`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"01bab910-a724-47e6-b568-17b476615736"],

Cell[BoxData["26"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606379090219*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d7b97b10-06b8-4ff6-8951-14ef871361b3"],

Cell[BoxData["27"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606390851481*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2ecde426-7f00-408a-9ca2-88324b1f7429"],

Cell[BoxData["28"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606402518478*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0f1fea4a-e540-4cc0-8fea-3d76435949dc"],

Cell[BoxData["29"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.849606414351368*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"62fa3f72-1209-420d-8c72-842534100503"],

Cell[BoxData["30"], "Print",
 CellChangeTimes->{
  3.848097667662348*^9, 3.849544108601625*^9, 3.849544139885504*^9, 
   3.849544217979319*^9, {3.849544350071333*^9, 3.84954435928911*^9}, 
   3.849544448527253*^9, 3.849548884125545*^9, 3.8495490840978613`*^9, 
   3.849549148321899*^9, 3.849549323554863*^9, 3.8495493599947443`*^9, 
   3.8496064259404507`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"79a27993-fa1c-42ea-b10b-d43cb680b33d"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"min", "=", "100"}], ";", " ", 
    RowBox[{"Do", "[", " ", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"FullE", "[", 
            RowBox[{"ii", ",", "i1", ",", "i2"}], "]"}], "<", "min"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"min", "=", 
             RowBox[{"FullE", "[", 
              RowBox[{"ii", ",", "i1", ",", "i2"}], "]"}]}], ";", " ", 
            RowBox[{
             RowBox[{"Res", "[", "ii", "]"}], "=", 
             RowBox[{"{", 
              RowBox[{"i1", ",", "i2"}], "}"}]}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i1", ",", "0", ",", "Nga"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i2", ",", "0", ",", "Nga"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "0", ",", "Ni"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.823741660106921*^9, 3.823741746782461*^9}, {
   3.8237864134539347`*^9, 3.8237864682406893`*^9}, {3.847220294234045*^9, 
   3.847220328066772*^9}, 3.84722178900259*^9, {3.84722228486516*^9, 
   3.847222285222855*^9}, 3.847239416720626*^9, 3.847239821629327*^9, {
   3.847240021398135*^9, 3.8472400216888447`*^9}, {3.847290147123805*^9, 
   3.847290147573572*^9}, 3.84729083227424*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"d31338e1-6c4e-4877-8f75-fe75c20effb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]], 
   StyleBox[
    RowBox[{"Figure", " ", "2", 
     RowBox[{"(", "a", ")"}], " "}],
    FontColor->RGBColor[1, 0, 1]], "*)"}], 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Rmin", "+", 
          RowBox[{"i", "*", "sh"}]}], ")"}], ",", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", 
          RowBox[{"FullE", "[", 
           RowBox[{"i", ",", 
            RowBox[{
             RowBox[{"Res", "[", "i", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Res", "[", "i", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "Ni"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotMarkers", "->", "Automatic"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"BaseStyle", "->", "Medium"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84722180467761*^9, 3.8472218066320868`*^9}, {
  3.849545257855715*^9, 3.849545266633883*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"7095c15e-b54e-4bf0-ab64-0143ddd3d35a"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJxTTMoPSmViYGCQB2IQDQYOQQ4bXL+vSpv+d78LCKiEOMy+xtyrpP9/f2cH
EHCEOVwIsFx6rpHhwNkzQPAm3GHD3kN1aQ8YDwiCwMVIhx08ISazklgOhILA
1mgH5rOXpyyZx3Fg1kwQiHUIW/sijItB6MC9u0BQG++Q1Nu4xuOtEET/xgQH
+f//38wQEz5gDAKLEx1uHjfdyWEnDDFvapKDQ1Po6vvBwgfKQaA92SGjfwLb
pThhiPmVKQ4rNLhWdpUJH9izGwiyUx0YMwu8TBuEIfbFpjnU6DV/yGgWPgD2
b0C6Q9yfh9lCf4QOKIGAU4aD98RVkWfShQ6A/W+S6XBn3/++4J+CB9JAQC3L
4XHW++S6dsED4PCQyHY4z3g0eeYUwQOrVwEBV45DJL/nn+rlgpDw+ZPjIDuR
Q/LPHcED79+BQK7D4sQUw9JnghD/Psxz0MgL3X9ORQji38v5DkzWRm9Xb+WF
mJdU4HB0P1P810p2iH9uFziI7ri2RZyfBWJ+SKFDzjJmZ5l1jBD/nS10EFJ6
cJZj3f/9YPvcihwkomZZCK38sx/s3wNFDhX6Zl73xX7tBwAPu+ch
       "]]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[6.272]], CompressedData["
1:eJxTTMoPSmVmYGCQB2JGIGZigAKHIIcNrt9XpU3/u98FBFRCHGZfY+5V0v+/
v7MDCDjCHC4EWC4918hw4OwZIHgT7rBh76G6tAeMBwRB4GKkww6eEJNZSSwH
QkFga7QD89nLU5bM4zgwayYIxDqErX0RxsUgdODeXSCojXdI6m1c4/FWCKJ/
Y4KD/P//b2aICR8wBoHFiQ43j5vu5LAThpg3NcnBoSl09f1g4QPlINCe7JDR
P4HtUpwwxPzKFIcVGlwru8qED+zZDQTZqQ6MmQVepg3CEPti0xxq9Jo/ZDQL
HwD7NyDdIe7Pw2yhP0IHlEDAKcPBe+KqyDPpQgfA/jfJdLiz739f8E/BA2kg
oJbl8DjrfXJdu+ABcHhIZDucZzyaPHOK4IHVq4CAK8chkt/zT/VyQUj4/Mlx
kJ3IIfnnjuCB9+9AINdhcWKKYekzQYh/H+Y5aOSF7j+nIgTx7+V8ByZro7er
t/JCzEsqcDi6nyn+ayU7xD+3CxxEd1zbIs7PAjE/pNAhZxmzs8w6Roj/zhY6
CCk9OMux7v9+sH1uRQ4SUbMshFb+2Q/274Eihwp9M6/7Yr/2AwAa3+cj
      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{68.27083333333334, 0},
  BaseStyle->Medium,
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{68.27083333333334, 300.}, {-4.878329999930084, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8472218099568872`*^9, 3.847222066696353*^9, 
  3.8495489060576553`*^9, 3.849549106665489*^9, 3.849549182557564*^9, 
  3.849549685507366*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"0a9e3b83-bb32-416d-aea0-16fe0e51c0b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Rmin", "+", 
        RowBox[{"i", "*", "sh"}]}], ")"}], ",", 
      RowBox[{"Log", "[", 
       RowBox[{"10", ",", 
        RowBox[{"FullE", "[", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"Res", "[", "i", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Res", "[", "i", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Ni"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8496064351915073`*^9, 3.8496064557415648`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"bba932f2-3723-4c3c-908e-f5130948ac08"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"73.`", ",", 
     RowBox[{"-", "1.8494631460529085`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80.56666666666666`", ",", 
     RowBox[{"-", "1.9490075596235445`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88.13333333333334`", ",", 
     RowBox[{"-", "2.0633824260822635`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95.7`", ",", 
     RowBox[{"-", "2.23457049400141`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103.26666666666667`", ",", 
     RowBox[{"-", "2.548145684065812`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110.83333333333333`", ",", 
     RowBox[{"-", "3.077462351525925`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"118.4`", ",", 
     RowBox[{"-", "4.500039442016108`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125.96666666666667`", ",", 
     RowBox[{"-", "4.731722541243785`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133.53333333333333`", ",", 
     RowBox[{"-", "4.772067740559378`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141.1`", ",", 
     RowBox[{"-", "4.810580152423392`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148.66666666666666`", ",", 
     RowBox[{"-", "4.831907918066065`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156.23333333333332`", ",", 
     RowBox[{"-", "4.842598059247258`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163.8`", ",", 
     RowBox[{"-", "4.865763322110219`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171.36666666666667`", ",", 
     RowBox[{"-", "4.87520328818414`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178.93333333333334`", ",", 
     RowBox[{"-", "4.878329999930084`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186.5`", ",", 
     RowBox[{"-", "4.746164022129134`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"194.06666666666666`", ",", 
     RowBox[{"-", "4.601365471873872`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"201.63333333333333`", ",", 
     RowBox[{"-", "4.493482813224286`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"209.2`", ",", 
     RowBox[{"-", "4.382318078506361`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"216.76666666666668`", ",", 
     RowBox[{"-", "4.395116385363919`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"224.33333333333334`", ",", 
     RowBox[{"-", "4.413558904608942`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"231.9`", ",", 
     RowBox[{"-", "4.465805426738624`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"239.46666666666667`", ",", 
     RowBox[{"-", "4.475056430579943`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"247.03333333333333`", ",", 
     RowBox[{"-", "4.535944928731205`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"254.6`", ",", 
     RowBox[{"-", "3.7137068301157123`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"262.1666666666667`", ",", 
     RowBox[{"-", "2.934550039550205`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"269.73333333333335`", ",", 
     RowBox[{"-", "2.5073694351222096`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"277.3`", ",", 
     RowBox[{"-", "2.21001484255685`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"284.8666666666667`", ",", 
     RowBox[{"-", "1.9799888650906081`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"292.43333333333334`", ",", 
     RowBox[{"-", "1.7912771426250682`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"300.`", ",", 
     RowBox[{"-", "1.6305840395825424`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8496064447541637`*^9, 3.84960645614417*^9}},
 CellLabel->"Out[65]=",ExpressionUUID->"5eb9df18-099d-4100-96e3-cad2aa74561a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"paramsNoK", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"delta", "\[Rule]", "0.05"}], ",", 
    RowBox[{"multAPC1", "\[Rule]", "1.6"}], ",", 
    RowBox[{"multAPC2", "\[Rule]", "3.76"}], ",", 
    RowBox[{"multRAS", "\[Rule]", "3.54"}], ",", 
    RowBox[{"ga3", "\[Rule]", "0.2"}], ",", 
    RowBox[{"ga4", "\[Rule]", "0.07"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8237821720505247`*^9, 3.823782180555138*^9}, 
   3.8237824042067738`*^9, 3.8237855395933933`*^9, 3.823785581137244*^9, {
   3.823873173252924*^9, 3.823873173527197*^9}, {3.82387326415821*^9, 
   3.823873274212552*^9}, {3.823880367281076*^9, 3.823880376250374*^9}, {
   3.847536744560308*^9, 3.847536773796451*^9}, {3.8475370968485518`*^9, 
   3.84753709772395*^9}, {3.8475386558482857`*^9, 3.847538657363153*^9}, {
   3.8475388255075417`*^9, 3.8475388263707457`*^9}, 3.847546181166205*^9, 
   3.8475466204414167`*^9, {3.8475558580097303`*^9, 3.847555859249243*^9}, 
   3.849544579498268*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"19738409-65d1-4484-aadc-020ed4e3068f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"delta", "\[Rule]", "0.05`"}], ",", 
   RowBox[{"multAPC1", "\[Rule]", "1.6`"}], ",", 
   RowBox[{"multAPC2", "\[Rule]", "3.76`"}], ",", 
   RowBox[{"multRAS", "\[Rule]", "3.54`"}], ",", 
   RowBox[{"ga3", "\[Rule]", "0.2`"}], ",", 
   RowBox[{"ga4", "\[Rule]", "0.07`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8237821837999268`*^9, 3.823782246002077*^9, 3.823782341016363*^9, 
   3.823782404599688*^9, 3.823785582599393*^9, 3.823786367641199*^9, 
   3.8237867629281054`*^9, 3.8237878435990667`*^9, 3.823787926425407*^9, 
   3.823872099730781*^9, 3.8238731738828983`*^9, {3.823880376663726*^9, 
   3.82388039687353*^9}, 3.8472109236572857`*^9, 3.847241881092606*^9, 
   3.847289616422267*^9, {3.8475367388610783`*^9, 3.84753679443436*^9}, 
   3.847537098196645*^9, 3.847538658440775*^9, 3.8475388269751*^9, 
   3.8475445333895206`*^9, 3.8475461819097*^9, 3.847546620843401*^9, 
   3.847555860048883*^9, 3.847834818839498*^9, 3.847844166925994*^9, 
   3.8495445803912487`*^9, 3.849548906071171*^9, 3.849549106679141*^9, 
   3.8495491825738277`*^9, 3.849549685527207*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"c552176b-5797-4561-a5af-416cd50917ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Fix", " ", "gamma3"}], ",", " ", "gamma4", ",", " ", 
    RowBox[{"and", " ", "fit", " ", "Kmax1"}], ",", " ", "Kmax2"}], "  ", 
   "*)"}], " ", 
  RowBox[{
   RowBox[{"FM1", "=."}], ";", "  ", 
   RowBox[{"Rmin", "=", "150"}], ";", " ", 
   RowBox[{"Rmax", "=", "270"}], ";", 
   RowBox[{"Ni", "=", "20"}], ";", 
   RowBox[{"sh", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Rmax", "-", "Rmin"}], ")"}], "/", "Ni"}]}], ";", 
   RowBox[{"KKmin", "=", "1"}], ";", " ", 
   RowBox[{"KKmax", "=", "3.5"}], ";", " ", 
   RowBox[{"NK", "=", "150"}], ";", " ", 
   RowBox[{"shK", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"KKmax", "-", "KKmin"}], ")"}], "/", "NK"}]}], ";", " ", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Rbase", "=", 
       RowBox[{"Rmin", "+", 
        RowBox[{"i", "*", "sh"}]}]}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"KKsub1", "=", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"i1", "*", "shK"}]}], ")"}]}]}], ";", 
           RowBox[{"KKsub2", "=", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"i2", "*", "shK"}]}], ")"}]}]}], ";", 
           RowBox[{"Ot", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"EEQ", "/.", "sub"}], "/.", "subdiv"}], "/.", 
                 "paramsNoK"}], "/.", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rbase", "\[Rule]", "Rbase"}], ",", 
                  RowBox[{"Kmax1", "\[Rule]", "KKsub1"}], ",", 
                  RowBox[{"Kmax2", "\[Rule]", "KKsub2"}]}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                 RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ",", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"n", "[", "i", "]"}], "[", "t", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", " ", 
           RowBox[{"n6", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "6", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{"n5", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "5", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n4", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "4", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n3", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "3", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{"n2", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "2", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"n1", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "[", "1", "]"}], "[", "t", "]"}], "/.", 
             RowBox[{"Ot", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", 
           RowBox[{"OtvP", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"P", "[", "t", "]"}], ",", "t"}], "]"}], 
                 "\[Equal]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"5", ",", "6"}], "]"}], "*", "n5"}], "+", 
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"3", ",", "6"}], "]"}], "*", "n3"}]}], ")"}], "/.",
                     "sub"}], "/.", "subdiv"}], "/.", "paramsNoK"}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rbase", "\[Rule]", "Rbase"}], ",", 
                    RowBox[{"Kmax1", "\[Rule]", "KKsub1"}], ",", 
                    RowBox[{"Kmax2", "\[Rule]", "KKsub2"}]}], "}"}]}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                    RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ")"}], "*", 
                  
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"P", "[", "t", "]"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"P", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
              ",", 
              RowBox[{"P", "[", "t", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", 
           RowBox[{
            RowBox[{"PPPadvX", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{"P", "[", "t", "]"}], "/.", 
             RowBox[{"OtvP", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{
            RowBox[{"PPPadv", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"delta", "/", "1.01199"}]}], ")"}], "*", 
               RowBox[{"PPPadvX", "[", 
                RowBox[{"i", ",", "i1", ",", "i2"}], "]"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"t", "\[Rule]", 
                RowBox[{"t", "-", "4.79"}]}], 
               RowBox[{"(*", "11.97", "*)"}], "}"}]}], "/.", "paramsNoK"}]}], 
           ";", " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "Also", " ", "calculate", " ", "contributiion", " ", "from", " ", 
             "different", " ", "pathways"}], " ", "*)"}], " ", 
           RowBox[{"OtvP1", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"P", "[", "t", "]"}], ",", "t"}], "]"}], 
                 "\[Equal]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0", "*", 
                    RowBox[{"R", "[", 
                    RowBox[{"5", ",", "6"}], "]"}], "*", "n5"}], "+", 
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"3", ",", "6"}], "]"}], "*", "n3"}]}], ")"}], "/.",
                     "sub"}], "/.", "subdiv"}], "/.", "paramsNoK"}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rbase", "\[Rule]", "Rbase"}], ",", 
                    RowBox[{"Kmax1", "\[Rule]", "KKsub1"}], ",", 
                    RowBox[{"Kmax2", "\[Rule]", "KKsub2"}]}], "}"}]}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                    RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ")"}], "*", 
                  
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"P", "[", "t", "]"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"P", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
              ",", 
              RowBox[{"P", "[", "t", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"OtvP2", "=", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"P", "[", "t", "]"}], ",", "t"}], "]"}], 
                 "\[Equal]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"R", "[", 
                    RowBox[{"5", ",", "6"}], "]"}], "*", "n5"}], "+", 
                    RowBox[{"0", "*", 
                    RowBox[{"R", "[", 
                    RowBox[{"3", ",", "6"}], "]"}], "*", "n3"}]}], ")"}], "/.",
                     "sub"}], "/.", "subdiv"}], "/.", "paramsNoK"}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rbase", "\[Rule]", "Rbase"}], ",", 
                    RowBox[{"Kmax1", "\[Rule]", "KKsub1"}], ",", 
                    RowBox[{"Kmax2", "\[Rule]", "KKsub2"}]}], "}"}]}], "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Lasp", "\[Rule]", "1"}], ",", 
                    RowBox[{"Laspx", "\[Rule]", "1"}]}], "}"}]}], ")"}], "*", 
                  
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"P", "[", "t", "]"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"P", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
              ",", 
              RowBox[{"P", "[", "t", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]}], ";", 
           RowBox[{
            RowBox[{"PPPadvX1", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{"P", "[", "t", "]"}], "/.", 
             RowBox[{"OtvP1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{
            RowBox[{"PPPadvX2", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{"P", "[", "t", "]"}], "/.", 
             RowBox[{"OtvP2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
           RowBox[{
            RowBox[{"PPPadv1", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"delta", "/", "1.01199"}]}], ")"}], "*", 
               RowBox[{"PPPadvX1", "[", 
                RowBox[{"i", ",", "i1", ",", "i2"}], "]"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"t", "\[Rule]", 
                RowBox[{"t", "-", "4.79"}]}], 
               RowBox[{"(*", "11.97", "*)"}], "}"}]}], "/.", "paramsNoK"}]}], 
           ";", 
           RowBox[{
            RowBox[{"PPPadv2", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"delta", "/", "1.01199"}]}], ")"}], "*", 
               RowBox[{"PPPadvX2", "[", 
                RowBox[{"i", ",", "i1", ",", "i2"}], "]"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"t", "\[Rule]", 
                RowBox[{"t", "-", "4.79"}]}], 
               RowBox[{"(*", "11.97", "*)"}], "}"}]}], "/.", "paramsNoK"}]}], 
           ";", 
           RowBox[{"(*", " ", 
            RowBox[{"Now", " ", "calculate", " ", "the", " ", "error"}], " ", 
            "*)"}], " ", 
           RowBox[{
            RowBox[{"FullE", "[", 
             RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "=", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"PPPadv", "[", 
                    RowBox[{"i", ",", "i1", ",", "i2"}], "]"}], "/.", 
                   RowBox[{"{", 
                    RowBox[{"t", "\[Rule]", 
                    RowBox[{"Kadvave", "[", 
                    RowBox[{"[", 
                    RowBox[{"k", ",", "1"}], "]"}], "]"}]}], "}"}]}], ")"}], 
                 "-", 
                 RowBox[{"Kadvave", "[", 
                  RowBox[{"[", 
                   RowBox[{"k", ",", "2"}], "]"}], "]"}]}], ")"}], "^", "2"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "1", ",", 
                RowBox[{
                 RowBox[{"Length", "[", "Kadvave", "]"}], "-", "2"}]}], 
               "}"}]}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "0", ",", "NK"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i2", ",", "0", ",", "NK"}], "}"}]}], "]"}], ";", 
      RowBox[{"Print", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Ni"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.823740539403901*^9, 3.823740558851613*^9}, {
   3.8237406639129972`*^9, 3.8237406854676027`*^9}, {3.823740791684186*^9, 
   3.8237408904825363`*^9}, {3.823740930085433*^9, 3.8237409326241407`*^9}, {
   3.823741001437001*^9, 3.8237410401627407`*^9}, {3.823741290951734*^9, 
   3.823741291269815*^9}, {3.823741322653777*^9, 3.82374132430864*^9}, {
   3.823741359496435*^9, 3.823741429631186*^9}, {3.823741475132635*^9, 
   3.823741475426045*^9}, {3.823741510522271*^9, 3.8237415323758707`*^9}, {
   3.823742338416526*^9, 3.82374234722024*^9}, {3.823742542937833*^9, 
   3.823742543412828*^9}, {3.823773669785063*^9, 3.823773673184052*^9}, {
   3.823775712399177*^9, 3.8237757128044653`*^9}, {3.823775771584511*^9, 
   3.823775784643126*^9}, {3.8237770826574183`*^9, 3.823777087268256*^9}, {
   3.8237781919388638`*^9, 3.8237781943838987`*^9}, {3.8237788938942738`*^9, 
   3.823778915649535*^9}, 3.823782187947082*^9, {3.823782345279235*^9, 
   3.823782346858636*^9}, {3.823782527163849*^9, 3.823782533795456*^9}, {
   3.823782689369225*^9, 3.823782689883466*^9}, {3.823785592024097*^9, 
   3.8237857420099688`*^9}, {3.823786374700376*^9, 3.823786379462928*^9}, 
   3.823786427242969*^9, {3.82378653789837*^9, 3.823786562873047*^9}, 
   3.8237866281364117`*^9, 3.823787685515657*^9, {3.823788036672035*^9, 
   3.823788059537241*^9}, {3.8237881881160097`*^9, 3.823788189597063*^9}, {
   3.8237884609350367`*^9, 3.823788505281007*^9}, {3.823795760366878*^9, 
   3.823795766745647*^9}, {3.823795821875064*^9, 3.823795828221067*^9}, {
   3.823796033729549*^9, 3.823796033998296*^9}, {3.823872154622699*^9, 
   3.823872156224904*^9}, {3.8472111200074177`*^9, 3.84721114444987*^9}, {
   3.847241934183662*^9, 3.84724194845147*^9}, {3.847242004058773*^9, 
   3.847242027553996*^9}, {3.8472421792173986`*^9, 3.84724218422472*^9}, {
   3.84724228471891*^9, 3.84724228544108*^9}, {3.847242511419094*^9, 
   3.847242518011792*^9}, {3.847242764691923*^9, 3.8472427877489033`*^9}, {
   3.847536860512219*^9, 3.847536883723002*^9}, {3.8475452287830667`*^9, 
   3.847545321907789*^9}, {3.847546889828889*^9, 3.847546904357794*^9}, {
   3.8475470591401663`*^9, 3.847547066089571*^9}, {3.847555751208117*^9, 
   3.847555753103827*^9}, {3.847555875921488*^9, 3.847556043540943*^9}, 
   3.847556131759028*^9, {3.847556315035549*^9, 3.847556319450506*^9}, {
   3.847556669288349*^9, 3.8475567056864223`*^9}, {3.8475569408742523`*^9, 
   3.847556945150056*^9}, {3.847557018109974*^9, 3.847557018232543*^9}, {
   3.8475580612315683`*^9, 3.8475580710928717`*^9}, {3.84755925436763*^9, 
   3.847559254640094*^9}, {3.8475602864844503`*^9, 3.8475602938281927`*^9}, 
   3.847834830812689*^9, 3.8478353515181513`*^9, {3.8478440222251177`*^9, 
   3.847844054139206*^9}, {3.8478441771001863`*^9, 3.847844184483346*^9}, 
   3.8478442921062813`*^9, 3.847844483737144*^9, {3.84788377356609*^9, 
   3.847883774036627*^9}, {3.8495446514915*^9, 3.849544673224262*^9}, {
   3.849544705177753*^9, 3.849544716230287*^9}, 3.8495448807815323`*^9, {
   3.849544960775053*^9, 3.849544963358039*^9}, {3.849549052005706*^9, 
   3.8495490535626717`*^9}, {3.849549124556616*^9, 3.849549124806221*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"f3fcf404-71de-49a2-bd23-75be16afd80c"],

Cell[CellGroupData[{

Cell[BoxData["0"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849591383266343*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"89b16570-01a8-4101-b2ae-db34818115d9"],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849591553315879*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6d336647-1d93-4b28-85aa-a04a9a488dd5"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849591722865766*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0cb86a45-b42d-4088-9957-11e4e5fae947"],

Cell[BoxData["3"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849591888266275*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3053e27c-b8a2-43ee-8d8d-ac151323f24d"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849592052766829*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"41d48f02-720f-461a-9abe-7f86665c5562"],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849592220117429*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d670526c-1b10-4b42-acea-53ac3ac66444"],

Cell[BoxData["6"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849592390535226*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"179c5fbb-bc28-4125-a1bc-a64cd650f61f"],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849592558537768*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8f5c041a-6f70-43b4-9c39-b75e047328bc"],

Cell[BoxData["8"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.84959272827814*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ca0e208d-b314-462c-8910-7338026410a1"],

Cell[BoxData["9"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849592896241281*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"43118b9e-9940-4529-b2ca-07651bd284ad"],

Cell[BoxData["10"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849593062931937*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19e0fac0-da2b-4a62-982a-2766a7e0cab8"],

Cell[BoxData["11"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.84959322937462*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f7dc5155-1b40-40c4-9788-c8b928d63ef9"],

Cell[BoxData["12"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.8495934068137207`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bf9cbb38-78be-470e-a4fd-daac2a256514"],

Cell[BoxData["13"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849593585861429*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"61dfd60e-9e78-4c5d-8ee8-261e96ab23c3"],

Cell[BoxData["14"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849593772401286*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bbee838a-042d-421c-be63-15cb5293d149"],

Cell[BoxData["15"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849593946216872*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7ae6c374-7104-4861-b3a1-6c8dceadfc6d"],

Cell[BoxData["16"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849594116855053*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b4e4a764-94d1-42d8-93e4-51075d6f116c"],

Cell[BoxData["17"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849594286758515*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ccca2c69-d176-425c-b94d-e9da154cf53d"],

Cell[BoxData["18"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.84959445725912*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"56f49fee-1d95-4884-a16a-0abb1f912ea9"],

Cell[BoxData["19"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849594628717198*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3cc681d7-47e2-44fe-9fcf-9aecbd08c1b8"],

Cell[BoxData["20"], "Print",
 CellChangeTimes->{3.8495498434251633`*^9, 3.849594799223126*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a3045ee7-ece6-4414-8d1e-ade9c3f35bd2"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"min", "=", "100"}], ";", " ", 
    RowBox[{"Do", "[", " ", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"FullE", "[", 
            RowBox[{"ii", ",", "i1", ",", "i2"}], "]"}], "<", "min"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"min", "=", 
             RowBox[{"FullE", "[", 
              RowBox[{"ii", ",", "i1", ",", "i2"}], "]"}]}], ";", " ", 
            RowBox[{
             RowBox[{"Res1", "[", "ii", "]"}], "=", 
             RowBox[{"{", 
              RowBox[{"i1", ",", "i2"}], "}"}]}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i1", ",", "0", ",", "NK"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i2", ",", "0", ",", "NK"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "0", ",", "Ni"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.823741660106921*^9, 3.823741746782461*^9}, {
   3.8237864134539347`*^9, 3.8237864682406893`*^9}, 3.847242059011528*^9, {
   3.847242211828987*^9, 3.84724221244799*^9}, 3.847242544003962*^9, 
   3.847242820868999*^9, 3.847546231213904*^9, 3.847546668970592*^9, {
   3.847546915707309*^9, 3.847546915849886*^9}, {3.8475561832215967`*^9, 
   3.8475562377025137`*^9}, {3.847834884174465*^9, 3.847834884483049*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"0664d610-50ad-4afa-a70a-57fb9efa6d8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   StyleBox[
    RowBox[{"Figure", " ", "2", 
     RowBox[{"(", "b", ")"}]}],
    FontColor->RGBColor[1, 0, 1]], " ", "*)"}], 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rmin", "+", 
          RowBox[{"ii", "*", "sh"}]}], ",", 
         RowBox[{"Log", "[", 
          RowBox[{"10", ",", 
           RowBox[{"FullE", "[", 
            RowBox[{"ii", ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"ii", ",", "0", ",", "20"}], "}"}]}], "]"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.848097175646476*^9, 3.848097191726124*^9}, 
   3.849545323353035*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"8c690d38-2922-44be-afbb-14cd45674f6a"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJxTTMoPSmViYGAQBWIQDQYHkhwO/MqxulIncADMb0h2OOL98YC4kyCE75Di
8M9Fap8mtxCEz5DqsO/fp5MnT0L5B1IdeNd9jHgUKAzVn+YQw9D/72gblO+Q
7uD3gjtpfzOUz5DhkGiZZLy6C8o/kOEgGbfXYecsmP5MB8U3pu49R2H6sxyM
Gn6Vvi2A6c92mP9W5MOjcJj+bIcvMbcCN7LB9Oc4nDNs11eE8R1yHRo+tr+T
Z4bpz3OwkJn25QYDTH+eQ/Oln+nhB6D+ach3uHCySmruRihfocCh/cAV87Zs
mHyBg+yWwsshWVD+gwIH58iK/jdcQgcAX+FrMw==
       "]]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[6.272]], CompressedData["
1:eJxTTMoPSmVmYGAQBWJGIGZigIIDSQ4HfuVYXakTOADmNyQ7HPH+eEDcSRDC
d0hx+OcitU+TWwjCZ0h12Pfv08mTJ6H8A6kOvOs+RjwKFIbqT3OIYej/d7QN
yndId/B7wZ20vxnKZ8hwSLRMMl7dBeUfyHCQjNvrsHMWTH+mg+IbU/eeozD9
WQ5GDb9K3xbA9Gc7zH8r8uFROEx/tsOXmFuBG9lg+nMczhm26yvC+A65Dg0f
29/JM8P05zlYyEz7coMBpj/PofnSz/TwA1D/NOQ7XDhZJTV3I5SvUODQfuCK
eVs2TL7AQXZL4eWQLCj/QYGDc2RF/xsuoQMAaZ1rNQ==
      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{147.5, -4.},
  BaseStyle->Medium,
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{147.5, 270.}, {-5, -4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8480969173540993`*^9, 3.848097192440218*^9, 
  3.8495948030238733`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"96a58033-2d72-4f16-b315-9a8bdd147e8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rmin", "+", 
      RowBox[{"ii", "*", "sh"}]}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", 
       RowBox[{"FullE", "[", 
        RowBox[{"ii", ",", 
         RowBox[{
          RowBox[{"Res1", "[", "ii", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"Res1", "[", "ii", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"61565391-260c-4234-b732-b06abcfe551a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"150", ",", 
     RowBox[{"-", "4.123856461431103`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156", ",", 
     RowBox[{"-", "4.314543738105332`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"162", ",", 
     RowBox[{"-", "4.510901422837604`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"168", ",", 
     RowBox[{"-", "4.697058825927966`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"174", ",", 
     RowBox[{"-", "4.829965009451837`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180", ",", 
     RowBox[{"-", "4.881614663580049`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186", ",", 
     RowBox[{"-", "4.878659755684636`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"192", ",", 
     RowBox[{"-", "4.88541870390904`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"198", ",", 
     RowBox[{"-", "4.9010973086911`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"204", ",", 
     RowBox[{"-", "4.942917931238328`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"210", ",", 
     RowBox[{"-", "4.860280841268876`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"216", ",", 
     RowBox[{"-", "4.8358266365789`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"222", ",", 
     RowBox[{"-", "4.7565357961204775`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"228", ",", 
     RowBox[{"-", "4.7559859682337`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"234", ",", 
     RowBox[{"-", "4.7530514975045435`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"240", ",", 
     RowBox[{"-", "4.750827619230272`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"246", ",", 
     RowBox[{"-", "4.687833428023285`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"252", ",", 
     RowBox[{"-", "4.673450864548116`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"258", ",", 
     RowBox[{"-", "4.605004188881259`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"264", ",", 
     RowBox[{"-", "4.603839210333743`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"270", ",", 
     RowBox[{"-", "4.510668031425953`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.849605618261714*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"4be48f55-0e90-415f-94cf-46804175e93d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   StyleBox[
    RowBox[{"Figure", " ", "2", 
     RowBox[{"(", "c", ")"}]}],
    FontColor->RGBColor[1, 0, 1]], " ", "*)"}], " ", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"PPPadv", "[", 
          RowBox[{"i", ",", 
           RowBox[{
            RowBox[{"Res1", "[", "i", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Res1", "[", "i", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "5", ",", "Ni"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}], ",", "J0", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "Medium"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847546680989979*^9, 3.847546701571383*^9}, {
   3.847547157677669*^9, 3.8475471581559973`*^9}, {3.847558473783019*^9, 
   3.847558521582822*^9}, {3.847558653821419*^9, 3.847558681138041*^9}, {
   3.847559663241703*^9, 3.847559667744853*^9}, {3.84757098318797*^9, 
   3.847570991137973*^9}, 3.847651208068325*^9, {3.847807116325759*^9, 
   3.847807141868799*^9}, {3.847834950790412*^9, 3.847834963118701*^9}, {
   3.8495450381144257`*^9, 3.84954504355864*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"18489fa5-18f8-4b90-bc0e-93c03387a03a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"-\\\", \
\\\"4.788365714285714`\\\"}], \\\"}\\\"}]\\) lies outside the range of data \
in the interpolating function. Extrapolation will be used.\"", 2, 20, 13, 
   20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.847558488589669*^9, 3.847558522022533*^9}, {
   3.847558656087089*^9, 3.847558681578809*^9}, 3.847559539816045*^9, {
   3.8475596639768763`*^9, 3.847559668792755*^9}, 3.847570945677387*^9, {
   3.8475709846201563`*^9, 3.847570991648445*^9}, 3.847646286585745*^9, 
   3.8476510729544497`*^9, 3.847651209269594*^9, {3.847807120714909*^9, 
   3.847807142382102*^9}, {3.847834955908926*^9, 3.847834963574561*^9}, 
   3.847844264294778*^9, 3.847882406884138*^9, 3.847893689373396*^9, 
   3.849594803872549*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"81b11f2d-7b38-47f4-9b7b-a98b62770924"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"-\\\", \
\\\"4.788365714285714`\\\"}], \\\"}\\\"}]\\) lies outside the range of data \
in the interpolating function. Extrapolation will be used.\"", 2, 20, 14, 
   20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.847558488589669*^9, 3.847558522022533*^9}, {
   3.847558656087089*^9, 3.847558681578809*^9}, 3.847559539816045*^9, {
   3.8475596639768763`*^9, 3.847559668792755*^9}, 3.847570945677387*^9, {
   3.8475709846201563`*^9, 3.847570991648445*^9}, 3.847646286585745*^9, 
   3.8476510729544497`*^9, 3.847651209269594*^9, {3.847807120714909*^9, 
   3.847807142382102*^9}, {3.847834955908926*^9, 3.847834963574561*^9}, 
   3.847844264294778*^9, 3.847882406884138*^9, 3.847893689373396*^9, 
   3.849594803926486*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"bbb23b28-563b-4bc5-afe3-24c30511d050"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"-\\\", \
\\\"4.788365714285714`\\\"}], \\\"}\\\"}]\\) lies outside the range of data \
in the interpolating function. Extrapolation will be used.\"", 2, 20, 15, 
   20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.847558488589669*^9, 3.847558522022533*^9}, {
   3.847558656087089*^9, 3.847558681578809*^9}, 3.847559539816045*^9, {
   3.8475596639768763`*^9, 3.847559668792755*^9}, 3.847570945677387*^9, {
   3.8475709846201563`*^9, 3.847570991648445*^9}, 3.847646286585745*^9, 
   3.8476510729544497`*^9, 3.847651209269594*^9, {3.847807120714909*^9, 
   3.847807142382102*^9}, {3.847834955908926*^9, 3.847834963574561*^9}, 
   3.847844264294778*^9, 3.847882406884138*^9, 3.847893689373396*^9, 
   3.849594803969902*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"d2e3698b-7e1b-4bcb-8d13-3fc5d06bda5e"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 20, 16, 20742840112063043890, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.847558488589669*^9, 3.847558522022533*^9}, {
   3.847558656087089*^9, 3.847558681578809*^9}, 3.847559539816045*^9, {
   3.8475596639768763`*^9, 3.847559668792755*^9}, 3.847570945677387*^9, {
   3.8475709846201563`*^9, 3.847570991648445*^9}, 3.847646286585745*^9, 
   3.8476510729544497`*^9, 3.847651209269594*^9, {3.847807120714909*^9, 
   3.847807142382102*^9}, {3.847834955908926*^9, 3.847834963574561*^9}, 
   3.847844264294778*^9, 3.847882406884138*^9, 3.847893689373396*^9, 
   3.849594803975404*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"a4b053ba-d7ff-48de-9c2d-8155eb487c57"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVlWc4Fm4fhu29Hzsee2TvjNz3z8jOeoxCVpFCERqUXVSIsiIhZUVGdjwh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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#1"]& ], 
     TagBox[
      {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl2c4Fe4fxu1ExrHJOGRvGR2p5/lG2ftYFTLKKLsUUhRCKEr2LpukkMQJ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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#2"]& ], 
     TagBox[
      {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl2cgFe4fxY1Itmtku5S9rpmR5/ka2SE3kYxSWUlGhKzsWZQklYSQzH4U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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#3"]& ], 
     TagBox[
      {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV1WcgFe7fgHF7Zm/Ze68Tkdz3F9myDpHMQxQlKlso/KIIDWnYJYpsIU5W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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#4"]& ], 
     TagBox[
      {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVlWc4Fm4fhu29V8h47L2SrNz3z8jOeoiQjMhKKLJC2avQEiEkIxpCJZ6s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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#5"]& ], 
     TagBox[
      {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl/c/Fu7fQI3s7bb3be+ZrFzX2x5RuJEP2UVGRkmIVAhlh6SQUVF2JHKL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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#6"]& ], 
     TagBox[
      {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVlWcgFf7fQGWP7L03WVkZGd/vB2UTrj1uoqwkFX4SUlbDThklMyGKQoUr
RFkhJCSJWyFlXIkoz/95dV6c8/5I+px2OEFNRUUVuIeK6v9ZEOtDr368GVmk
iCX8nVLEnSMS1i4SeXij1LJ385wi3n3VGi8hUYmJBq+VGPYq4oK2VHE6ied4
0OlnjgtWwMGG4ad+i/dg9c38/wofy+OR7YDsFfEJfNK3LDCtVwZHvBZTW66b
xAPJSwWcZ2Ww0I3Rvh8mU7j0VYRlppAM9lEEmu/+n7Dyn1TfuBBpHFnN8nzt
/SwuogvZ/CUphRk+zMr/EF/Ay8rOCTTB4ni8jRS+NL+A217Z+x+eEMNV5bkv
v9ct4u3u+nUHczFse9b26KLJEk4aUSB1KYniW0xNt775L2Pl26K9TQzCmOtO
N/Xq+zVs0ZX7L4CTH2+zNVaGGlBw3zeNP5z5fJh8qdRupYiCtcr53d1k+HCj
f+zd5cB1nPny4K+nhrzYXfOA3s/tXzhNaD/xRDw3Lu4tPPNdfAtbMh+SZXDl
wOu5DYqfUrawn+iWZOMsOzb175sb3trC77ZYONsF2PESzW+nppE/WJDWgDiX
xop1DW31ribv4D2Gr9+klzDj6yzHKdHrO/hAu/mFpGUmPD1xvjr02F/s8qoh
oxwz4YSIe2Ku+v8wq+J/wqYLDHjo0Q61/PIu3tbK69E9Roe5MBORdT8V2BRF
Dta+osX6ctl6ycepYE43NVVAlRanrVdSot5SwfW+KPd8Rhp8IPPdCZ8HeyDS
KdCu4CMVJkZ6G0993gOlHOtqPW5UOPnodzFnAWr4YLut6Vy3iyZV9oxbJFID
fcxxj/mWv+hir7Kl+lEaeD97eKGE6w+qqHsq9+AmDRwfsj7++sAWGs41ppHt
p4GJQXIG2WMTyfi7tggcpIWpOs4jg882UC9Nwn4qbjrIeOGTOfyAgtYX2Vii
LOjgzdav3n3ra0h0OO8b5SIdlBfVONMaraHQokdF35boIPzzSD3n/AriM/zA
NfiKHorGdi/MjSwhkPFbNv9LD7npYeGkyu8okGW1r0OTAfa9d3VsTl5ELRP0
iY1FDFAYTOP7yGMefW3LPKb2ngFm/LnnTtp/Q+wVIqiKlRH8rOUWxm2/Ip8I
jd8FUYzwUWle3t6bjFK8SCP8dYwgOzpTKxU2hxoOmddmfmME37bT3urps4iR
mxiY6MgELi/mRrImZ9DDR1c/BO9nBvYyl5nopA9okWsxxfIYM4yTVzosNCeR
fIQl2pfNDJd7SNty38dRkQFL8dwWMySrleY4XxhDU4UnHdqVWWCMJZvNivAO
CdL00xQeZYHfBoE02VqjKKsnxc+9iwUeOpxJ8xcYRgPKP/h1N1lALyNaN1vg
LWLJsOnhVdoLSe9ErrhJDaEEZzbltxl74YlD/kVyaT+KmEtfNfNkhRfl8TZn
dV+hx6YrJbLprMDqli3H0d2JlivtHGk6WCF9NnNh2f8lCgjlfNoqzwaqn+qj
/461obKRMwF33NngJCPfwrTlC/RZe1gwKpUNPHuJVi50JOT+Nytai8IGb8Ou
0PMNPUO3vCkq3HLswPGy9yF5uhGNvCR8WnFlB6UjwQGujA2IQ74+Y+A6Owj3
iXo0WD1B1td4jKtb2eHdfPpDXFGHrvwIo1xdZQdD93PX9EVrkU9F0LAmFwfE
lKwqTxJqUCFLXzznYQ6IVXVrpmGvQMjwgmcckQPUb0UOTdbcQ1MhSlrL/3FA
Yc6xeBRRiqKKPrASMzngak649FO/YiQwfP1rfxUHZFOUqPK376JGGoMX+p0c
cOGQ+VuOsNvIUWspp+ojB0QuULvNaeaiNb87oYK/OeBwlZi2lO5NlJlrbXGF
gxPO2xIZpmOykFrvjuRvBU74WZBwUp46Aw1sV/85YcIJQ20V1GIJ11GwitfI
qCcncDRLDFqGJyPmo6zVJhGcsKdp4/zG23hUkUFKeJz+P29TC8bZcci045SX
ZCUn2DKUt98NvoDIFFHtjA5O8J3sVo09HoHiZQfYdj9wArPGqOkJ2rNIyiX2
26lfnFDqXk6jcikYtV3Z3zbFxgX2Y8VPK4T8ELFpOtdqHxdE8tQVdpC80c73
tDNNRlyQfm/Ud/eeK8oXxZYKHlwwWPC6uyfRHukeWZbKDeMCXqHB+qn3Zmgs
rnCbPo0LiE3x3FP3EAp/fGQ0/D4XjG/EvW001EA85N1qchsX8D1Kr5iNkEaP
eWsTCZNcELhPQeNNCieyM/MmdlC4oKKh9JFp1m/Dn5EcOuqs3PBSwY9LwGPI
MKWqjb1Ijhsssuvkb4ZYGCpOhc6zATeMc7o4DH9sNexmlWyPcftf/ybONlaK
Cvnjt3lLZ7nh8z2OMyeD+BBVyUbTh+vcoCQxGelRJ41yaUWmesu4QTgqoNJ2
SAmp+Rv9fU7ihryEworUCg3U3eMnVjnGDQWtha5XIwyQt3IKzl3mhqDK6sM+
nYfQZlqddzIjD7SMUJ1i77NCGatjlyIkeeAMzQ21JF57tM9xp+SEHg88WdvJ
WvNxRG2Nkp2OBB7ISr+svHjFFbkKmn0xCeYBvknpv8HJXmjlQjC9ZiIPSASG
XjZ8dAxdmc6Ul7rLAwwtU5LMDCeQhNFTc86nPNDxZcxTpC8APSudCqQa4gGb
r0TNsO1gZEdPfX15ngfGiE3DjP2haD5Avnp6Dy/81Epxi7I7h+L6rN+8EeKF
+Jc4hJ83AgnsP/uzRZMX5iLoj0Wpn0e1GTns1da8cEbMp6ywPBqZU1rUbp/g
BT4vhTsmenFoxmnW/losLzDKBqfl2lxGkc8Yzp3P4QVO/60K29QEVBnj0ODS
wwuX3CjO05lXkfHMf2Oms7ywxOS9+NQ5BU0aF/zW2uaFMh4ndm7LdHT2XoeA
LA8fyDmA1jmDTMTMOH+QR4UPhjTSV+rWslBJEKsHjSkf2CjnPO96nY303mhE
rxH5oBi5ZjxsvoWCsmJahzL4oLuGzn93Nx9R/yr59KKSD+4wr/n52xWgfJdu
qkcdfGASlxNW9qIQaTT9kLz7gQ8CFrtGWBWKUa8It0nqOh/k3XyQSd9Ygnwu
6h6PZuUHekvD6OhrZejPZ6/Ek3L8IFLEK3w5vRwp3a94beHKD3w3aLOTBqtQ
J9PAvO4ZfhjxtoupmqpGnsEUpn3X+KGzbDlZre0hSlFH1vQt/BCZfsvHF+rQ
UvPIUIe4AFRc1+ifSm5ACWJbq3W6AtBJ9hJ809yIRC6JcRfbCwDDWBn0bj9F
1qaBThfjBYC5yMdstKgJkSvSIkLuCMDG7PsKJ/oWFM1Sn+PVIADVoJ3XF0lC
NUP/JvS/CUDhu+PeJOM2ZKops61IJQjnDBkecHO0o+mbFiJCgoKw/vN9kAu5
HbF5ZBM3LQUh+FR+jUDJSxTyRWGu/qEgkKW0026Hv0YzxAnG9h5BMBTqcN2f
3Y0I41f2vyELwu+TVVyU5h6k2/ft/BchIVD1zmsplu9HNHX3OPiShYBQnTvz
4vkQilB00pYqEYL6/0KXX51+i+ZLaT33k4TgYp4B2lD8359u+d43pQhBaHmv
KWvdCMqNlkT/HRWGPB5u2b9/xxDzxpBvfJQwKJNraUQ+vUcxp+Oupt8Uhker
Rte+d40jH59Po/f7hGFH0m3qc9kkUjYvODmuIwI+B5Ziv1dOo7vt1plkBxEg
OqxuejV9Qpz6O40rp0QgjpifcDlgBm2oeFAzlYnA2X8Ow3lXPqN2bsG8gxyi
YBFGM39qeQ4dSO1uPawkCva33Bo9M8monD6SbG8qCk1h1hfvaX9BKVtjqkHR
okBelJs9fv0rcv6U/Sp/XhSqzWp5oogLqNv10FI5jRiMBk0qCogsIv1hCucT
MTG4n1DSeeTjIpLocvDqcxSDs0yK1+4HLaHFKo717TYxGHAkp5HqlpGnTJsg
45QY0PF+3Qo3XUGDBacxz28xMA4w/fWrYQX9747XlFXEQXXX3bI1fxVdjEiR
9MoTh5AfTUnDFyiIWTJB/pOuBMS+SGUXKvyNug0yVWMPS8AIx1UuD+lNlOR6
V0fUQQIsvHxORVRuIuqMZ2YeJyUg++6HNLPmLfTn35L/+wIJONA1LFz6axt9
n3KqGKSWhOKkQtUmXypctelTG8IuCRvFtH2WDVQ4gCf0GauIJJDpE/2nGPZg
stW1bistSRj92aPEULsHTzW1zr/2l4TQXZq8/L00uD9XXqGtXxJ++um8bPxN
h6/VH1A/OiEJdm31xE9u9Nh8yOjgvy+SIBPAJyxMosedDJ4WBruSYE2OjB1K
YsAtERmBz9SloGWbrcJBngnXOG5V1t6SggV7m9H7BXtxGkefYrG3NPzgf1JB
q8mFn+uINtiGSIMKy74/Sxe4MJl4Gu9ckIaO0NX1K11cWL+G29ElRxrOx35R
n3bnxvMWnjGsA9LQzMM2wZrGg03ifwye15eBtvd3Lvzj48chVdhd3kIGHudY
3fA9yY/z32aSR51lwH3FtiihjR+viGtvqZ6VgbramKCdYAF8tyVW6muFDLTb
lYYODgjizV/s4Q58shAtZ/smoFEES4v67O5Ky0JRsl7hSz5RbHuo/mqNuixE
3ZS5//k/UXwvy/Uuo40suO8IKwQaiGEH1eLXrfGyIDgZtfl4QBzXBGgIKa3K
QuZqi7hViiT2+eD4gqZfDp56HHKVlJLFzLc/nzozIQcK8rzc/V6y+LF7iMin
r3Kw9wLl32SeLKaZTD7ftEceQh5Gistxy+Gy8SbNMzry4Ct7cTGCWR5/fSdR
MV0iD5wlJr8V9irgoKGljOfn9wFLUGf2pqcK5so4j+WT98Gl9oeHYu+p4KYj
9D+zs/fBgpBdzKmfKphlUNwq9NE+EJqr2X/10n5c/caBTv7LPjiulSHcVK2K
f/Y+O59tpwBGas61WSzq+ExXgs9peUXYyqbNK7iricXIpvQbmoowF5Uw0/RK
E/dRM1VFgyIk2tY6MS5rYllIXb3qpggmXWXsB+AAnmi6GVd2XRFWhdVqh8gH
sFFt+d2JZUXQ6LHg3a+jjTlvd0+aPFOC8Lv/Wa5SHcStz6/F9nYqQfe5wG0t
1YP45Li1lP1bJTjis8BW43UQd/G+DSQuKgFxKqlKo/kgPp8xsRkpogyaMZ8G
CiL18OfERb6HccpQpGtUTPtXH9eF7iUIWKiA3sx1ltvKGPfnc5+vcVaBmUVV
tlcnMP7aKVRofFwFflBuyKoWYiwkqPA9+KIK2H8ZpyYyAU5oPxzf3qACPYkh
48diATtzXXwSJLUf9q1NLtuHGOE/T1a5Sdv7weZO92VdPxNcfOHkopqLGnS9
mmLzfW6G1dqYNpO91GB3XZuL9MEMt9FW0H3yVYNv4QyJWv/M8EwqWSI1VA14
a5dWLpmYY7EiL5eFq2qQ0r0ScG3QHOd3HuksblGD6h+0An4/LHAW64G7XFLq
UJ4yZtkA1vhy4Y79+pI6GMQ9SKoqs8N2as/OKFHUoY9+8Gjkczss1n4u02dL
HQyNZ985D9jhptnFoSE6DUgVDXxxeNMOr8lOHKkR0wB+29WbS9b22Ke6wcbP
TgNqxh+3+W3ZY6PnIRbjTzQgquTAdbujBEw1MgMtUZqwrHdsSOCYM05YaC2O
uqQJSc1mIpeinTETVQH1wSuaoJ/lub6b44y5VNw6G25qwsTN/CSjQWcsm/zW
7FGtJtgZKcy+Qy7YUr/DtuSrJszG3/5uJ+WKb5SWel5xOAB/U+U2t/+4Ybkw
v0hHRS2YufjKOnvDC6vofSIUqmnB/pNbLlO8RHyAylV1UVsLdp4E39bXImLj
FIuvF020YLo+hhHCiJhYpuz4wFMLDEcUFXwoRHxrdE2VOl0LwmJbKAIbRzGd
1sVvjyhaUPCUmXua/hgm/8pxZiFpg5V7UVflIV9cYqR57uNLbUjs4aphcPPF
R1MH0h/1akPCWm5V+ClfPClD10MY14Y/Yuz8l2/54reEs/p3KNoQV7Cw67Xg
i1vrrCVUFHVgjC3VVznrOM45tWfRNkcHUh8b0EasnMCWX4Jiss7oAp/3sbCo
2QBsGiNdfShSF24Glnb1/gnAxrxTkxuxurA0GV+rwh2I9Q7b6Hqk6MKR8Z5k
pUOBWPGeKkX6vi7Qh7HXMN4PxCwn1gMapnRBd6bKxTE0CPeTYxzHzQ5CxWf5
xlTOYGxLzlASE9MDV/1K+keZp3G/EnnUU0YPXn5rIPLXnMZW53RibyvqAeeV
nD03uk9jc+rpIQEdPZAWe+zauXsaG0soRXDb6UHPH377KzqhWMuzq43xsh4o
xY7uq6kIxSKjW06UL3rwOGavT0LWGbz40ieuu0Yf1tSLaiYTz2HxzPGgtHp9
GJS2cE7JOYcdibZOjs36MDLLYmJVeQ63bh5UnOnWh/U5GpbV/nM4S4Vz9Pec
Pvx70m7ykScM6+e8kJcXMgB2bepWfD8MpwSJDCYmGYCOZLdO4Fg43s85Jmpy
1BC8gz19dbwjMTP+dWyKgsC86Wcp6orBZj/cf0s5AQR25FApuFzG4x3H97gr
G4Gy7CqfjkMSbrjSSZT4ZQQfWTbcvG9dw3504TMDA8Zg/vH2KavhdOx79kLD
3nwTeKBqz/G0OAur+isNWB87BCUUruStazfxIJcyS/jBw/Ch73NC+Voubn54
+bYyjSkEvvNzFHO8gy/sUbTr/2gK1OKZ8yL8RZh5Kso8pN4MIvYy2h1iL8Ff
yiWzC6PN4eBAIfEPpRRn7xOkfe5kAc2HLwvxsZXjjHy/18ckLMG5uik7hrUC
u2d7Dez9ZglVDWri1kxVePPQva3CVit44tEs1ahVjee+GEd2JFvDJd1O43h4
iEsM1YXfHLOB0+cJ+bsGtbgmMZzTX8UWTsl4Oz81q8PJTr5WNL9swSF04+l9
m8dYa6q4MvnNERgmREfuBj7BuQq3a95Y2cGYU0jA0XP1+GJbaq7VczsQuRHc
8TKrAdsIO93rlbGHwJPMOTnVjdgo5LUH51V7yD0qfFroyVNcKOIj0//LHhJf
XN42HHyGZV7ev2Xr4QBgo8m68/45zlDpUBxudQBT4QHPnckm7EehfdujSACP
qPlVN0oz9qlbk7iaToDP7yx+uGy24ODLhB3LTALsPSw2P7fTgsMJ9e/33iCA
YX7c2Ok9JHzlV3haxi0CtH34lprMTMIPD25t5xQQwPgfm3+jCAlvte+OlT8g
wIkJ9XZOIxLOGN6b2vmaAGJL9EwvrpJwfumpgKQeArTkOp61SCPh0rABE/M+
AuQ9+jcwkkXCjXwZf/oGCKCi6eszf5uEp9y5A0beEYBP02qV4yEJy88JmszO
EUBTMuHh0WESVquPEiv7QoAGWTqbhTES1kv8sHXiGwGaVgamz34gYWv5gtqF
RQKYrepMJZJJ+OxJCbHVVQL8NjREDzZIONrg0tZjCgEm+GcjDmyTcCLr7GjY
LwI4fu0qIe2ScO6j0uubmwRQjzw8OsjYikviaP2b/hBA6PX0hCtrK35gf8I4
eocA1ZKPhz9ztuJ6qVei6B8BamxaW4P4WnErRW5rd5cAZA7quxShVvx/KLw2
pA==
        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#7"]& ], 
     TagBox[
      {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVlXc4Ff4fxe1srmtdWVdW9miSz+dtZidXi4wI2fTNTFGUkJmQMrJJiRDK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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#8"]& ], 
     TagBox[
      {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
       1.], LineBox[CompressedData["
1:eJwVl2c4Fv4Xxu2MyA7x8JjZJEXx/R57Zj1UPyskhIyKIqIks0IqkcgmZBbi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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#9"]& ], 
     TagBox[
      {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVlWc4Fm4fhu29Hzt77xEa6L5/KDvhsVLIHokWIUXhT0aIrIxQVgghZKcI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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#10"]& ], 
     TagBox[
      {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVl3c4Ff4fxXGzs/e6Ltl7lIz6fN5SsrIuKXsUokTF1wyVEDJCpciIEIWQ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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#11"]& ], 
     TagBox[
      {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVl2k0FWwXhkVmR8455jhmxzzXG/E8GxmTcBBCpUwp0VtkioqQoaNMCUWT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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#12"]& ], 
     TagBox[
      {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVl2c8Ff4fxWVzEdcle+89KoTv9xORlXCTFUVWlCg7RUkoQgkpu4SsQiRu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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#13"]& ], 
     TagBox[
      {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVl2c8Ff4fxW2yr4sQ17Vlr1Lh+/1EZK+LhKxCIZHIiooyKqFsIZQRGUko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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#14"]& ], 
     TagBox[
      {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVl2c4Ff4bxu09z7Gzd/ZoKPl+H1slybH3JkWZIYkfQqijIZSKVIiMoohj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        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#15"]& ], 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVlnc4FXwfh22yj0323puU/H5fRFbWsbLSKRERQlYhRKSO8iA9shpGZhTK
CSkzCWUWZaYhnYQo7/P+9bnu67r/vz9SpNOOvnQ0NDSWtDQ0/9+C8yQmreOP
0f6Y1js9hvtw57CkjavkDeylFCJh+GYv3nlBSZKULMcNz64ZN5/eiwvaMiUY
JZtx9drhjTf3DPApo4igdYkeTP5ulxAguwcPb/lnf5cYx0z2o3G9h3RxZJe4
5krdBO6vDazzWdfBItdH+r6aTuHozwZnvhbrYJIy0H/2m8aWyrWC85vaOOo+
W/OP0Y/Y9XSornyjFmae/KjwVeITDrCKSgivUcdjba0RX5Y+4VWzCxvykuq4
4m7es891y7h56KpT/jU1bBtme2TZ9AsmCYpUNsWp4pxdLTmLfiu4jFwRdtFX
GfP82023OvoDv/ZuDN26KI+3OB+Wh+ynYuZASlYIjzyeSyy1/15ExZ/mPY/E
FMrhh37nb62c/InZCylrQJHF7jq6+75trWEL0kiNDacMLu4tDP0ssYm/ki9S
Fj5L4J95jcrTlzdxkOLeEW8ZCWzu1zc7tLmJa6KhWs5bHH+hX3duGf6N1YpS
k5PeiWIDI9t9l1K3McmTfKWFTgRnsB2nxv3cxuJSiTdnicL4/Xj0/ZCjf7D4
IUNBmTIhnBx5R9zN8C/+V8tcs+ewIB6s2aZTWNnBSxm2rV9m+DAP3uXNoU4D
3z5J8zNY8WFD+ex9qcdpoNlT7+JmIy++8rOcGvOaBoijtpdIOTxYN+uNL6mS
Flbivyz6RXFj7ygfk6kPtJD/4voT5xUunHrks7iLEB3MERo0FaiceEKNdswy
hQ4yZ28cDmflwPG9qlZaR+hhXEvFVS1yFy6reyRf+Q89+E2aKKYUsOChPBN6
uX56iD9e/uZRDzOW9XN7IrSXAUY7Rk9HaDLhXvpkdRpeRigNXrbq0qPHP5c5
2WIsGUFouPxe4AU6LDZ0Y5EazwgSYcV6McO0OKSopmjxCyN4cVRfLbhAgwWM
JnlevWCC+eWJ3nn5bQSyJ1Ys/jAB7QRafkK/hU6yrfZ16DCD+c95/tSlTfRk
nCnlYREzYMbFhaSedbTQlnVUc5QZzpQ36p9//gtxlYmiCg4WeDNcu/i7ew2R
IrXXC2JYgCAg0MG6QEWXvVqHBetY4NTkz398d36gxgMWtVmLLLCZ+EliSOIH
YuH1PpnitAtyX/6pOB3xHVXXXJo8pc4KvE1+M3YfltEyz/Jlq6OsELSeCtw5
n5BCpBVSzGaFlFbfa7ecl1DRfrbi2U1WKHhnlh/0cx5NFQY6tquywYk9lFzH
4TkkTN9PX3iEDRIEZ/htn8yiaz2XT7g/ZwObAHaZ15Uf0IDqV0GDDTbomrq8
uV03g9jIh3r4VdjBqsLsKVfSNEp24VR9TWYHr+pfQ0wbkyhy9urqQU8OqNp3
p0nkwRtUb/69RO4qB7BGLWh4WI+glXJ7J/oODgh/SkcXRx1C/iGERxQFTqgM
vD2yEjqIbg+H+v/rzgmEIpVugasD6IP+kHBMJieMx4WPabr2I/c/1+L0qJzg
47/EomnYjXJ8qGq88lzAHfXZ/K7zCzT8jDj93Y0L/PMY6qXSOxG3QgN5IIML
aHokxpdHO5BNOp/JfQoXRO5SsrZC7Sjtazj10ioX3KwXUidEP0WksoAhHR5u
0AsJzJ0qfYIK2fqSCGbckG3M73L7/COEjGI9E7y5oYgoutih0oimglX0Vs5y
g34CV3s47QMUUzTJ4Z3FDT4vXtBa/61FQkMZC/0V3HDOSvdKlXE1eki//6lh
Jzcs73nm5fiqAjnpfcmteMcNNsTlqrsl99CPE/+GCK9zw3z+4Zb+ptsoK8/G
Mo2bAB/Y2ykLnCVIs3dbal2JAGBX/FXtQCEa2Lr/29eUAH+HQvbvvM9Hp9S8
hkc8CWBVbP8hZSkHsR7huG8aSYCah0VEJo/rqIzcmlx/lQCPuNpZn2uSkXlH
kJdUOQEGHWS22bvT0RxVTJ/cQYDcP3OW4u9TUJLcAOfOJAGqdqd+Nc9LRNKu
5xeD1ghw1+p6pcTbWNSWpt42xckDpxXGP9LnRCDvlvd51oo8kPr0iLfN4RC0
/flKaIsxDwiz2q7z8/ijfDFspeTBA1YjXpqlokeRgd2KdF44D7QmvTPrtnBF
bxMKt5iu8ED0FJ3ij6+HUES93UjEPR6g+NhegEFjxDe3c3+ujQe+Wu/j4KfT
QfX8tSnECR6oWWtJipORQvYHfbw7qDwQE6MyMszAjL5Fce/R4uAF0oRj/+zq
tNHlijauInle8PRzZN9442akPBWyxAm8EN5qEH7Kvc+om0Oq/dxhXkiRuKVy
doEV+eHXN76E8QJynaSW0EkjmpJfLZMZvOD8aKNXTEMd5TGITvXe5oWXBoOy
LZx6SNPP+E9zKy9IHToqpKNujLp7ToiXv+WFByWZgqrxVshH9TLOW+GFqLaz
h5+LOKKNK3U+qSx8cGGf5IfScBdEXn2bGCnFB58jG9PM5jyQotN2ie8+Pgia
oPfTcT+K2h5KdToR+UAuJmMsKcwXuQkfnDc9xQe38leF+AwD0PfYU0w6KXww
YaivOPfgNEp7n6UgfYsPvlSr0sd8C0OSxo8sCI/4IHJ1MtnYIxI1lU6dpBnk
g/7ePymDKAbZM9FlrCzxAcN8enJL7Xm05K9w/z0tP3AUGbfFjyWihD6bly9F
+IElmPrkVWEyElIP+/ZEhx/CptwNDlWnolpyLtd9G36w+XxWe4M+A1lQn2je
9OWHnHyrysGiK2jG+aND+nl+qHq6PDt9IAtFNTGfic7lh8KTvQeOnLyOys85
Nrr28IOsscb6XbM8ZDJz9q35R35oCm6wOP0nH02YFKzrbfEDc3fIst1CAQq7
0yEkxycAufLawbIJRYiVZWkvn5oAeNfhtVq5ElQSwOFBby4AQTB3mm6+FO17
qR33w1sAfk2dmch5egcFXDtHGSQLwAW/0jd3e8sR3VrJ9NNyAaBbDsjS+lOJ
8l27aWo6BGCt5NR1Mbtq1CvKa5r5UwBuf9efuVlRh0jxBsfjOAQh65xVRgvj
A/T7g1dKoLwgGLSUMNwIa0Aq98q6LN0EwWTUIvN20iPUuWtgySBUEBYSlbXH
FZuR5ynqLsV0QagLiRqc+tCCLmshG6YnghBYkyDrk0VBXx4PD3ZICMGZGZX7
PjHPULL45mqdgRA42bptBZZ2ItFEcd5iByEYCCP9CBp7jmzMTzrHJ/3H5aVB
Xn7daK7sSmTwv0Kw5nBds729B8WxNeR6NQrBNyXyvlrFPlQ1+HfccFEIhAlX
rfpEB5C5juyWMo0w9PMYHPOpeIXe/2MpKiIsDCdZH1oWlQwiTo9s7w0rYUiK
/6Ax4TCEgueVZhuqhSFj9K5LNsNbNOM9ztLeIwzb03ZNHsKjiDiWpv5yThhy
Wsd1V/THkEHfYvS8iAgUkz/8S5M5gejr7nALpIrA2eGq+dCyaRSp7KwvXSIC
FL80lhtJM2iplMFTvVUETiWeN3q/578e5Ry7Z04VgY9/0Fm3mo8oL04KnT2y
G+44IYtXk/OI9dfgsaSY3bD0yThyd8MCOnc64dLVf3bDIFPuvZdZi4hEmh65
17cbfA/tv3jb6xNStSgIHNsjCrEHixymDb6iW+02WXOOohBJG/9QDH1DBMPt
h9+DROFeUH3CPssV9EvNg27XbVFQv6TXXNr0HbXzCt/Yyy0GE8QtFmVGKtLN
7KaYqYiBVuJ8F3cRFd1lippzMBcD+RozI2n0E13efKsRECcGL8zaSLNJa8hl
OvtF/pLYf3+DeX+d/gbqdjvw5S69OFyrYHNs+7yBDIeohAfi4uA/pXdI//Ym
knzu6NXnJA4dleG8wRJbaLmC++dWmzjIFkjyduK/yFO2TZhlShzCXRw6Wrl3
0KuC05hvXRyqUi7JO83voP9qmK6qJgGeCW0dzf00OD7yspTXDQkQfzb4XSqX
DrNKJStMG0gC6VANg3YaE+7en6Vx3kwS3K4EDCozMeOLbrf2iDlKAsXSaGIh
hRnTkZsOegRKQkDlVsSDdBb8++8Xv9ECSbCLLQheLmfFn6ecy17RSUG4c0KA
qjEXrtgg1QZzScG9Ji/9giku7M8X0sQhKgXmJgOGf/dz4znr9G5rPSlgO8mS
bfGOG0+1UJa6/KSg8qVofY0SD+7PU1Bq65eCEEWrIG4qH05v0NU6Mi4F8xpG
rvP2/Nhi0Hjv33kpEPr2Yqyrhh93Mnta7t+Rgj/jdlyPQwTwk0jyySYtaSg+
z22asCOIq5w2y2tzpEE+jP9yo8NufIW7T7nYRwYuX1Ql7zkphZv3iDXaBsuA
KNPd4J4aKTznfRpvx8rAwKW7WbzrUtiwitfJNVcGxCv7lEZSpfGSpec5jgEZ
mHhw1USiXgabJn19FW0oC+cKE1aKleVxcAV2V7CUhZvaNOFS5+Rx/uusuREX
WcharDT0G5TH3yX0NzXCZMFjoorLMloB33pyXnqhTBY+Tp5QPD+iiDfWuCIc
BeTAkZuRI7ROBcuIkXZ2ZOTAZ4mi3cqtim0PNFyq0pIDoRCjtHchqvjONbdb
LIfkgL6+2uiWjhp21CjuoiTJwTU3PiWDZ+q4yl9bRGVVDiT1WSmdjFqYNOn0
lL5fHixsHV6jUl3MevNDUOi4PJgYezGNTevievdg0ekFeSBz1wbNieph+onU
6BZaBZDqVMJueXr49liLTugeBXB65+7yMFsfL7yRLHtfogDzveIFhaUGOGDw
C7k5WhGUlFK62kSNMA85GiukKoLiET6aKH8j3GLH9C07WxHUQ39bVTcYYbZX
EtYhNYpw3CM++4YtwvdfOjIqzCsCu/XMkfA0jL/1NkVn2yvBmMoSiwmrMQ59
nkw6raAMn1rSeTS7TbH4nDnTLx1lOMsrraxLNcV9dLsq4kAZqE0EtXDxA1gO
MlcvHVYGojTEl0UcwOMt/yTczlAGAWqn6IK8GTauvXtrfEUZ/FpQ4utsc0y4
2T1h2qQChxiEVI0KLTGlOf18b6cKVKxX626/tsSBYzbSDq9VgDlNn22LwQo/
53990ntZBSK09t9sCrTC0eTxjShRVfibKJ2rv98af0hZFqhOUIVUTaczbp9s
cF0IO1HIUg3ixHzWYvbZ4/583ugqFzV4NhshFOpujxc6RQpNjqtBi9OZrisx
9lhEWOnzqXg1SGQ2ZjN+bI+T282S2hvVoNd3eeMCcsAuPPEPAqTVIb8m/WO6
jSP+/WCVt3VLHRQexPULpzphvvcbex13aYCtcjFR8r4TVmeh8VkU0IBY5uO2
9q+d8DFPzvsEbQ1wjxx+oyrqjPsZVA6c8NcAeESpGn/gjG85Hw/neqMBnLbU
y5yfXXBxbOCypqsmKK7/8TgYfRhrtu3aSPXShE3RPRvPiw7jNoYyxuljmhD2
cLdEQPdhPJM5J5kZoglj9+ZVZYTcsXiRl+unS5rgahSqeLjZHed32nUWP9GE
mt/shZN0nvgah+4tHmkt2NpMTg2r98YXCrcdfn7Rgr00djvDJiRsr9kUqkLV
gjPtKQpL7iQs3n4mi7SpBW45/uZcZ0i45ePy4CCjNhAW6kJySkn4h9y4XZW4
NjCwvqpPYzyGSfcbD52w14bHPTw9f/uPYePmYMuxB9qwy/WxKAT4YprhGXgS
owO1sk2OV977Y/nwE1FOynrg9U/EsfGGEDy3luvC1qoP98xp0ZhrBLaaDzh3
LdQAxoHAiXljse0cWUVcfB8cjAvRHnmQgJefkRK6qwxBgHHPYv1aElYnvBUz
PWIEGUosCsODqZgVrx2doiLwymOvF2rMwAe/uq9LOwNIZyi4poqR8VjHcVp3
VWOoYdJTpIu7hhvTOr0l14yB5WwLjdtQNj7BGDEzMGACbcc6ObnO5eJjYbGN
7Pmm8ELjfrqgcD7W8FMZsDl6AE5LBN9JffYvfsWjyhax1wwc/SPCzj4vxI+r
L9xUpTcH/gSdNBfXYhxLq2zf/84cyj3Ld6lslmDWqRiL4IaDUNYi+pOm+Dae
vyuVXRhnAT9mj7pzGdzF2YrCDM3OlpDx7lzs+J97mJx/ouuopBWc/LaoUVVb
jt2zvQbYF61A9VMAs7hvJd44cGezkGINCrve+j61rMKz8yZRHak2cEe3wXtD
sAaXGGntfnn0EOy6FSEymlGLq1IiCH5qtnBTyejsjfg6nOp8zJp+zRZ4vPe6
7ITVY72p4vLUl3aQYOex53X8A5yndLPqpbU9XDSjYxWOb8DxbZl51s32UDX7
i/NYXiM+tNv5Tq+sA/w6EsgrWfcQGwd3eRAuOcCdsoOVWy2PcKEoSbZ/zQHO
/OBJjJpuwrLP7uXYejhCwCGh/cd/NmOyWofyEMURRhvSN0jMj/EJKsPrHmUi
dOnVaV7Xe4JJdT8kL10lwpn85CZOYis+dYG4bZVFhAalvTvcbq04gtgwyn6d
CLRd51J5vVpx2lrEFXIOETJP5XoK+7Xi6r2bW7kFRHivqC6kGNuKN9t33t6t
JMJI1vpLh9JWTB5iz+zsIsLexMDtN9RWnF8a5H+xhwi52u2+MxutuDR8wNSi
jwj6G2Vcn/+04ocC5N99A0TgouWSo2Wh4Cl3Xv/hN0S4PODirClKwQqzwqYf
Z//zk2c78w9QsGZDjPjteSLoEkp0yi0peF/K5KbvIhFyGs98fGRLwTYKBbWf
lomAUjRp3rpRcFigpPjqKhEqGLUN+YMoOG5/4mY9lQgyvJXlcmEUnMLxcSR8
jQhpzeuu+mcpOK+mNGNjgwjzhC9n3BIpuCSBwa/lNxFM55I+nLxIwZUOviZx
20RwIr+6EptBwQ3SL8TQXyJYy3fFZpIpmEKV39zZIcKRh6Sywn8o+H9TfjJi

        "]]},
      Annotation[#, "Charting`Private`Tag$39613658#16"]& ]}, {}}, {{}, {
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        FormBox[
         StyleBox[
          GraphicsBox[
           {EdgeForm[None], DiskBox[{0, 0}]}],
          StripOnInput->False,
          GraphicsBoxOptions->{DefaultBaseStyle->Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0]]}],
         TraditionalForm], {0., 0.}, Automatic, Offset[10]], {{{57., 
       0.055999999999999994`}}, {{58., 0.0605}}, {{62., 
       0.07200000000000001}}, {{63., 0.076}}, {{67., 0.0835}}, {{68., 
       0.088}}, {{72., 0.097}}, {{73., 0.1}}, {{77., 
       0.10750000000000001`}}, {{78., 0.11}}}]}, {
      {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}}, {
      {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->Medium,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 80}, {0., 0.12194719382542832`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8475466816105547`*^9, 3.847546702144023*^9}, 
   3.847547158912759*^9, {3.8475584772284393`*^9, 3.8475585220727777`*^9}, {
   3.84755865614109*^9, 3.847558681762579*^9}, 3.8475595400053463`*^9, {
   3.847559664197661*^9, 3.8475596690022182`*^9}, 3.8475709458705587`*^9, {
   3.847570984856842*^9, 3.8475709918956223`*^9}, 3.8476462868304853`*^9, 
   3.847651073210684*^9, 3.8476512094361277`*^9, {3.847807121058607*^9, 
   3.847807142639283*^9}, {3.847834956233021*^9, 3.847834963828012*^9}, 
   3.847844264519146*^9, 3.847882407120286*^9, 3.847893689594358*^9, 
   3.849594804278207*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"7c1945b5-668d-48cc-af5a-127e6272ab64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   StyleBox[
    RowBox[{"Figure", " ", "3", 
     RowBox[{"(", "b", ")"}]}],
    FontColor->RGBColor[1, 0, 1]], " ", "*)"}], " ", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ",", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ",", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "5", ",", "11"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ",", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"KKmin", "+", 
               RowBox[{"shK", "*", 
                RowBox[{
                 RowBox[{"Res1", "[", "ii", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "12", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}], ",", 
    RowBox[{"LogLogPlot", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "3000"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "Medium"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84782252005134*^9, 3.847822531095489*^9}, {
  3.847822801336659*^9, 3.847822820618773*^9}, {3.847835002266754*^9, 
  3.847835012480644*^9}, {3.8478824969234343`*^9, 3.847882504619582*^9}, {
  3.847882548000523*^9, 3.8478825613843184`*^9}, {3.847883662246011*^9, 
  3.8478836671504498`*^9}, {3.8478937320995817`*^9, 3.847893738160687*^9}, {
  3.847893802668939*^9, 3.8478938155603237`*^9}, {3.849545007289926*^9, 
  3.8495450146616917`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"eebf182f-a45d-4d33-8689-2bcab4aa5f74"],

Cell[BoxData[
 GraphicsBox[{{{}, {{
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         FormBox[
          StyleBox[
           GraphicsBox[
            {EdgeForm[None], DiskBox[{0, 0}]}],
           StripOnInput->False,
           GraphicsBoxOptions->{DefaultBaseStyle->Directive[
             PointSize[0.012833333333333334`], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[1.6]]}],
          TraditionalForm], {0., 0.}, Automatic, Offset[6.272]], {{{
        7.406648715797514, 7.138013788281542}}, {{7.291519461147811, 
        7.022884533631839}}, {{7.2147666247146764`, 6.831002442549003}}, {{
        7.138013788281542, 6.677496769682732}}, {{7.022884533631839, 
        6.639120351466165}}}]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         FormBox[
          StyleBox[
           GraphicsBox[
            {EdgeForm[None], 
             PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}],
           StripOnInput->False,
           GraphicsBoxOptions->{DefaultBaseStyle->Directive[
             PointSize[0.012833333333333334`], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[1.6]]}],
          TraditionalForm], {0., 0.}, Automatic, Offset[6.72]], {{{
        6.984508115415272, 6.40886184216676}}, {{7.022884533631839, 
        5.871591987134816}}, {{6.984508115415272, 5.564580641402277}}, {{
        6.946131697198704, 5.142440041020036}}, {{6.907755278982137, 
        2.8398549480259896`}}, {{6.831002442549003, 4.681923022421226}}, {{
        6.792626024332435, 3.2619955484082315`}}}]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       GeometricTransformationBox[InsetBox[
         FormBox[
          StyleBox[
           GraphicsBox[
            {EdgeForm[None], PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}],
           
           StripOnInput->False,
           GraphicsBoxOptions->{DefaultBaseStyle->Directive[
             PointSize[0.012833333333333334`], 
             RGBColor[0.560181, 0.691569, 0.194885], 
             AbsoluteThickness[1.6]]}],
          TraditionalForm], {0., 0.}, Automatic, Offset[8.16]], {{{
        5.334322132102872, 6.216979751083923}}, {{5.142440041020036, 
        6.101850496434221}}, {{2.302585092994046, 6.025097660001086}}, {{
        3.146866293758529, 5.909968405351384}}, {{4.1830295856058495`, 
        5.794839150701682}}, {{2.302585092994046, 5.718086314268547}}, {{
        3.4538776394910684`, 5.602957059618845}}, {{2.302585092994046, 
        5.52620422318571}}, {{2.302585092994046, 5.449451386752575}}}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}, {}, {}, {}, {}, {}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxFxXss1AEcAPDz8zrX4fK8n84jS5PHyCS5wuI0lsdqXuXKWspuXbJyRMgq
VNy41d1Vt1ozmUce1zRFLjfOY5I1LPJK10xjcZz3rscfvt8/PvvsvZB2KoWg
UCiR//yfOkLQVT5LQTvnB0o9c9j46ivPaO9QXJ2ZIHoaiyvIemZaFi7gJrow
2/Gf6oZAXrgGVi4npZslL8MRU1s6vzYtHHB73TtucQ1unnxRfJHchHW0Eurp
9G24YX7Yw/+lDraNkrfp8inBO8sMPmu/VuvBI4/tCuoVBLxWWuy0Mq8P9ye7
WBwyMoQviSTiBdIInnXz8LLhGMOs57/JgCQq7J81zBx4YAKTTWU1o29ocENn
tnC6ZxfsEVRUGK+lw9xHysFeUzM4I8bJq+6YOVzdfICh78uA0xvHmjwV+OtJ
GZcRtxsOyRbIF2dwdtf7QTrfAq4KYWxME5Yw3yu3Ty7Eq6K2Ko/ut4JD7NUR
RCt+JFEt7eJYwxU92sXgcfxypYPmXaoNLDwob7uqwV2X4sq/FdnCLAdL8zBL
Jnw3b1qcWoOHnezqLj5MwrxeK6W6AyeyM1Tr8XbwimThOk2Nn5kTuA/l7IGd
f/HqRhksODRBMDL+DB/bENGkPvZwH7V7NkaBs7pThJxwB3imxTpIM4kTzAmp
jOcI10t82XQ+nmhbMpGThjfasJ3P3sC51k9qyTy8xSK2XVyO800//ShrwZml
+woprXgn/ZbrtQ+4Hd2dH63Ee2j3V037cWcqx+ThFD5QJKvd/I7fNF6J5Knx
QaMKUfgcnmuox6Iu4673EtoztfiQQWPy7BruZnC+UrWND995e8LvD/5Rz1j7
heIEizt8VDQCv1JwTnJcH/8LxUERLw==
        "]]},
      Annotation[#, "Charting`Private`Tag$39613802#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0877004699853936`, 2.5034996265961946`},
  BaseStyle->Medium,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.615805480084347, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.615805480084347, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.0877004699853936`, 7.406648715797514}, {2.5034996265961946`, 
   7.138013788281542}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}], 
    Charting`ScaledTicks[{Log, Exp}]}]], "Output",
 CellChangeTimes->{
  3.8478225319597273`*^9, {3.84782280209545*^9, 3.8478228215145407`*^9}, 
   3.847835015854457*^9, 3.847882505032753*^9, {3.847882548986841*^9, 
   3.847882561859056*^9}, {3.847883663152212*^9, 3.847883668459263*^9}, 
   3.847893738589224*^9, {3.84789380454277*^9, 3.8478938160845423`*^9}, 
   3.849594805273752*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"7dbad42e-27de-4ec2-8b0d-f5898bf21599"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"KKmin", "+", 
        RowBox[{"shK", "*", 
         RowBox[{
          RowBox[{"Res1", "[", "ii", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"KKmin", "+", 
        RowBox[{"shK", "*", 
         RowBox[{
          RowBox[{"Res1", "[", "ii", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8496056497609386`*^9, 3.849605692219358*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"e9f73158-45d0-4300-9937-2b992013f3ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1646.8978654828688`", ",", "1258.9254117941675`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1467.799267622069`", ",", "1122.018454301963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1359.3563908785254`", ",", "926.1187281287937`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1258.9254117941675`", ",", "794.3282347242813`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1122.018454301963`", ",", "764.4222742526002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1079.7751623277093`", ",", "607.2021956909883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1122.018454301963`", ",", "354.8133892335753`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1079.7751623277093`", ",", "261.01572156825387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1039.122303835169`", ",", "171.1328304161781`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000.`", ",", "17.11328304161781`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"926.1187281287937`", ",", "107.97751623277094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"891.2509381337459`", ",", "26.101572156825373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"207.3321573485954`", ",", "501.18723362727246`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171.1328304161781`", ",", "446.683592150963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.`", ",", "413.68204023885073`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23.263050671536263`", ",", "368.69450645195735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65.56418494179789`", ",", "328.59932476006543`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.`", ",", "304.32198871077225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31.622776601683793`", ",", "271.22725793320296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.`", ",", "251.18864315095797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.`", ",", "232.63050671536263`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.84960565615497*^9, 3.849605692945375*^9}},
 CellLabel->"Out[52]=",ExpressionUUID->"ecdf4d75-045f-47a8-9262-568d5782286a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\</Users/komarova/Dropbox/AJAY/ASPIRIN/EPIDEMIOLOGY/RESUBMIT/Data3b.dat\
\>\"", ",", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"KKmin", "+", 
           RowBox[{"shK", "*", 
            RowBox[{
             RowBox[{"Res1", "[", "ii", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ",", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"KKmin", "+", 
           RowBox[{"shK", "*", 
            RowBox[{
             RowBox[{"Res1", "[", "ii", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "0", ",", "20"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.849605853423211*^9, 3.849605858082615*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"abe358f4-d5e4-4b4a-996d-7ca582699471"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   StyleBox[
    RowBox[{"Figure", " ", "3", 
     RowBox[{"(", "c", ")"}]}],
    FontColor->RGBColor[1, 0, 1]], " ", "*)"}], " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"I", "*", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PPPadv1", "[", 
           RowBox[{"ii", ",", 
            RowBox[{
             RowBox[{"Res1", "[", "ii", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Res1", "[", "ii", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"PPPadv1", "[", 
             RowBox[{"ii", ",", 
              RowBox[{
               RowBox[{"Res1", "[", "ii", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"Res1", "[", "ii", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "+", 
            RowBox[{"PPPadv2", "[", 
             RowBox[{"ii", ",", 
              RowBox[{
               RowBox[{"Res1", "[", "ii", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"Res1", "[", "ii", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PPPadv1", "[", 
          RowBox[{"ii", ",", 
           RowBox[{
            RowBox[{"Res1", "[", "ii", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Res1", "[", "ii", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"PPPadv1", "[", 
            RowBox[{"ii", ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"PPPadv2", "[", 
            RowBox[{"ii", ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "5", ",", "11"}], "}"}]}], "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PPPadv1", "[", 
          RowBox[{"ii", ",", 
           RowBox[{
            RowBox[{"Res1", "[", "ii", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Res1", "[", "ii", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"PPPadv1", "[", 
            RowBox[{"ii", ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"PPPadv2", "[", 
            RowBox[{"ii", ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"Res1", "[", "ii", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "12", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "15", ",", "80"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "Medium"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.848139101957189*^9, 3.848139112629674*^9}, {
  3.848141102784562*^9, 3.848141103180842*^9}, {3.8495451256075077`*^9, 
  3.849545135659012*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"0803ce38-bad4-445d-828e-d7ca577f1d87"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzGs0lAkcx3EzVk1mETOlWq2kbMdhiKGS/P+kyWWMMU8uS6mIxigSRaXs
0crWbqWsMLbNbi2WpEblrhubcxqXYXIrxphHZaMbuU3Y2Re/8z2fNz+zsFhB
BFVLS8tHs/9b3JpqpaXFwtHuievht6UQMHrU3EGXhbz+KcOUu1Kg0KNXiJgs
PPPb6NK8SikEcQiafB0L4/S85uQPpbCwzpws9GNh4prSLL5MCvuKG/J8r7Pw
raL1adQnKZimLaBf49ggLysjxt6hGbxWNo7/zrFFWRFDvKmuGbrV3voVReux
KkRnue27FlD+4GIQNGaH+rMTGyT0NhCnrqlP3sBGih1dYnG9DQ6U6hWtyHZA
jl8O+4iPDKpPhR1zVTjinc06ZuMfZbDqWHWa0m0jWl/Mrbr7dzs4ftBBnfxN
KO1tsHEI74AmvTrlnSEnfD3K0PJgyiF+R2J9F8cZdcfO/fRVtxzErldTz2Rs
QT2Mlv916TnEldwfr+xwwUMRTq/+9OwE22vDfLvliOUlS2JajbpgqMY6T1qL
6FGxpcW6tQssDo6lmse4YjLr5yvb8rrhwUuJq7OJG8qc7PklYT1wxXRdQm69
G/JJej39m16YnvjWvTxmKwrSazMuDfSC+I9n6YYMd+TaS+TqrBfQNDAttGp0
xwWy4dflAS+B129mtihhG3oxw4OOGPSBYdk819KYg0e0D2WKKvpgL3P3UloT
B/3Y9xoChf3wnptAWB7cjpnJul5CmgKebz29X9/AA89PpB74Pl8B21sZy8vq
PTDfxGaw1nQAJq2DXX4N88Qb1NChbfsHwN5sNcWR6YXUfV/auu4MwNN2lTj3
sReeeDuNRlMDkBsYUuQa4Y1x6x5d/uSohMlDO4iCJVy0ws2PBElKyNylfdi3
mos7kDbZIFFCOu3m/uoQHywVPlTfG1bCQo/OGaUuD4v3yowaVw9CY/B9Cu8W
Dy1XOjfd8h+ExdRlBUd3+2JBqEQ35twgcOuNFXFUPqqdw48nVQ1CbXB+wFmC
j5Gbg1Kyhwbh8KNhk5QSPjq9OTHAZajgqaH+yuxZPnKp9pE6zioIsxqLPh/g
hzmKraamkSqwtPAvIEv90O3qC6OT51WQsejyitB5P6ycOhCVflsFWyou9t0L
FOAepuzNE7kKzvKEvTbFAmxzqXXQ/qwCSmPdY121ADtXFW5kM0h4oCOffiIg
sG2uXzvWjgQT20bRtRsEihwuFdrzSBjv0R79uoDAfrFn5U2NpafdYo8XEuio
Kitb60vCia4H8f7FBApFOQJjPgm9p6qT6bcJ7FMHRU37kZDTXHYhsYbAgGMX
+iv9SWBGiyW+7QTGGkfQ1u4iYYTZw67rIPCfwI5JscYN9cYVls8J9GafaVkc
SkK8UVaNTjeBr0np+i8at1ddbKjpI3AmO7xNtoeEDFpa53fDBC4J6Y1L2keC
UPIkKOtfzf/9Z10jGuNO6gvqCIHutj5r90aQ8L4sRdH3jsCWxYxEz0gSeIHH
32SOE/iQajWxTEiCBaVKRJkgkKYwzf1F49niyZGYSQKnHjeZa0WRcHMu4aPn
DIGpI94fXmn8Y1F5fIWaQIrAxi5YRMJOwafPa2YJHJvrCWnWmP3FNunyHIEv
T/IPYjQJ9ILYmfl5Ag0CsyPLNf4PRcNH1A==
       "]], LineBox[CompressedData["
1:eJwVyXk41Akcx/Exss5YV6VlW/FMpUwS1nb4fh07rjGOXzQPpWelJ0tRiGpt
pFWP9lHWETMdstMyaVDYJsMMHdJTJoUMck2u31jSopRrdvaPz/N+Xs/HMiIu
6BCVQqH4qfZ/y1rTt1AodHwuuf1Zf5MUQiaTrBx16Dh2TdlcYysFNd2YtdEm
dFw8Mfw4zF4KbAah1bGRjq25tZ7lO6WgKbYaLg2kI3ve+FY4SwqRZU+u+vPo
2NLjEbmQIIV1GV/pFjG24h9PNRvNG6XgY9E0e4Nhh+yHNr59YS+ha8FXX8jf
hsL1C8Kz4laQp7kYsGfscYC+OFWf9Qq46daSlO8dMInLfbnb/TUcKV/JX1vg
iEkWea5RRm0gOhNxynXACUVWLrLZvjb47pQoQ+7mjE/b5QJ6Uzs4fdBAjZs/
oKjoA5Vf1QHPVorl90Z2oHMpN9WA8wYS9iRLZIxdOOGYbKx+rRO4rtfTz2fv
xu2k0iwnXwbH79yffdDugvmJFO2m7C6wK1IE2JshtlzpPV1Q2g0jdbZXW+oR
Wb6nrly82wO0ozPpVrGuyCa9BLntb6Ght8p1l7kbBvOdhTUzvXBl3cZEjsQN
+QdT9Tar9cOXT996VMe6Y0VhV3+59QBwi19cMDT2wHGdt4mE2SA8G/wStaXJ
Awu21QyV3B4EVr+lpXbijxhpJDDkOcjBsFLJtFnNwP2m9TS3ajn8ZHJgldYz
Bh6Vjd/gOb+DKWYiYXPUE5eLg/u07r2DN+7nDusbeKHT57x97euHwLPV2KxS
4oU6cTaxTpwhmLMNdcmL8EYXzYehddRh2G65Xs3JxAfp1RMPLsYNQ3PbEJfz
yAdNwzjXKjqGgbM3jO96yBeT0DptxnYE5o7tIUpMmaj/J2/KL3MEcverx/uL
mKjBjT2X0z0CF7QEh0VhfqhXeCC+xmoUNL065+U6LDzhWvvVzrhRaAq9r8aq
YOFzxwp9z3uj8DV1TUnSAX90PGKa5jM7CkzJ6oHj1ADM9u793Ewfg/rQmyGZ
RAC+sGzknY0cg/iHCvPUOwGYYRm+YY47Bs2G+hYFSwHoT2O/OvJ8DCK2zMRk
hQSiAVzaETM/Bja04JLh8kC8OvnztDeNhGztnLXhykD8JosjS2OSsFt4ue/v
vUH4MeQfGT2BhExWVM/WsiDUex+6U55HglqT+JHOQhAKJtUrpNUkNGh0fHkc
RGBlMXMNrZ0Ec7um6KJbBG7Mixckvydhtlt9Uq+EwOvThTcmVW455xZ3upTA
VfdpsQenSPhF1pAQXEbgYCbvL9YHEnrOiFJ07xLYucBKtpomoVBaeSm5jsDp
8w0VTz+SYBLDrfJvU1krRTizSMKESbeDuJ3AtnDtmENLJDyRrBbavCGQyWEu
daqcYJRfp9FF4IoNFpLaZRLaai8/qesj8NUxStWvFAVka2V0blAQaMbIilGq
KyCq6jE7f5xA5Qsbg7gVCsB91LfUCQJ/z7bI6Vd5qjJ1oO89gX4Lm5zEGgpg
7T1N5s4SSHhPzZ3UVABNrTZa7ZPq7/YsGFN5qWxuInaOwIJ491UhWgoQLCf+
6z1P4IyXT7W9tgJ+41cnCBcIbBRHvb6p8r6g6Y/WSwTuvxPQqq+jAIdFu5M5
ywSeLdYtT1FZtyRuXqkk0GgzL3pc5f8AfmxSNA==
       "]], LineBox[CompressedData["
1:eJwVzXs0lAkYBnDGTonSlmkHi0LZVgwVsm15X5emSZgxX7mNErHkuhml0u1M
YXWPsNSidCY7he4WGRSrdhuKMaQ0hPi+LZfQLCo7+8d7nvM7z3POaxYazw+n
aWhoeKnv/5Q0i6w1NFjolPEpwzNNBr7v91o46LDQS6RDCk7JQFM32iiKwULi
VGJtzHkZ+LMJbflyFu4s6ZzIuCiD2dUWfdd8WLh4qUHKaJkMwiT1F7lFLLxQ
cN5c1SGDxSmzdAvYttieGnnI1LoJPEwaxvPZdvhjaVFMqaIJOqY365UXr0Tb
Jal6tqxn0HPUeb7/2CpsWWjC3TvyDPJES6UH19ijbef4loSq5xBTMq/YKMcB
L8zSPnvqagtUHg7d76J0xGTFTf3pE62wZH9lSo+rE15/ucvBPEMOjiN0pBf+
gM2Zg+aNl9vg8bzqnlv9a3HfyScnoyQKEG5Jkraz12HEUceEN/J2yHP5TZR6
bj3WGo6e3j7RAbuv3x//o9UZLYOWrfQy6AS7ApK3yhAxL6HEo1DwEvqrbC4+
fYBoYjrZ9O+ZV2AZOyayiHPBT+zKBL/uLqh5ddtlnbErBobnmlTaKCF78fLE
XKkrahycKfJY1Q2TH03d78S54X6t2hDpi27Iu/x32gJ9d3TaQDusEvbA4+7J
SOsGdwxZKMmsYr4B79dmZnMSN+DuUQua8d03sKBsxtOKyUZlhEWAs0svhDCC
v9F+zEbxP4Wvt8p7YdgzkbCK3Yj5spHhk3590OZ2LEJvPgeTvp9ym9fSBxub
9Q3LpBy8pTC0beL2g8om0PlC6CY0AhmTJ+2H1Wbmmo4MD3TvY6bkst5CY0tv
Xu5DDywaF1lvy3oLuX6CYpfwzbj6I8OmfOgtqH7eQogXeaLrnm8fPeEMQOY2
rQRupSdmJudP1GYPQJr2jYhKgReqhGRdXdcAzOYopnp0vHFCXiJYtGwQGgLv
a3qXemO6cYXjpdBB+JpmIN4bzMUVOk8frikcBE8pU7mbxsOZG6bvuW2D8CCw
0Ded4OEYGViTQichoY40PnKdhxqCbPsOBxIaF+iZ5HzmIR2WgyiYhFDrsejT
vj4od1T4OqWTYGW5VdxX4oMWXbyoqVISzs3JMNo+44PJDq17sppJWF9+tuue
Hx+TfsnJ9hkhId07stNWwkfu0O/c/LkUaDZUP9SZ5mN6WtGGXZYU1NDlk4/4
BMbe9Q8LRQqM7RqiCq4SGLxjaEePLwXjL7TezxUTGKA6scbVj4Knx1zjD1wj
sPEDMXxF7eT2GuFWCYGpX+XQwvwp6DxceVD3pnrfpF/RF0DBr7KyM0lVBG6m
RcR3B1HAiM67zW0h0Py1m2ddKAXvGC/sq1sJ3HOFs810JwX1Uma5VRuBfGET
L1lt4cKsKnqHug9OVdqHUdBScba+qotAZ6c/L4nDKTinnaL4jiSw1yO64Hgk
BZG3H/lnUQSW23K6lGpjEO0l7R2BA1zOl7W7KBguO6LsGiLwL2YnOaK2t9+B
wcxxAumHAiIF0RRYalZEaX4kcK3BT7X31P4sUb2LUxE4weifnh9DwY0viaOb
pgisCQ8xqVf7ePEdYfk0gQXsBC3TWAqC+B8mln4mUHLFWJaktv0nu30ZX9T/
VkcdeK62rjh+amaGQLI0THdFHAX/AQmzS1A=
       "]], LineBox[CompressedData["
1:eJwVz3s01HkYBvAZjpLrKpmytTVpKcdtW2wS70t2XGNmvkKIE9ksRcVGamkV
1tHFIbV0walwBjthQzMZ3SbtZg1yS6RxKeM3uqDcmmZn/3jOcz7n+ethRsRz
o9RoNNpOVf5vniTdgkazwqm/9ihivNsgYPKoiZ2WFcIBMCacNqBrxxrHGFrh
49zTjk6BbRDEIppdm6xwg8g9mxHZBkubTEbLOVbY2mjkOJrSBvt4jy77XbdC
2m+KnAFeG6zLWKJdzLJGz/IcmpeOBLzWimeusWxw/XEH/scuCfQteus1VHyH
dh/v723paAfpSWf9oOktGGkeLhwXdEBR+kbRiR9ssX5SdL6H3wkHqnUrjC/Z
Ia/hp6jap89AkBpxzGXIHucjZzmFY12w/pggQ+q6FWn5nGLjzT1g/14DNUoc
MC/23taVyb3wRLdJWjO2DTdpha3Va+6DBP8kUS9rO5oVhKWr2/RDkcvV9Mxc
J5wb3KfnfuEFHK6sn2l85oxbwvWsaxYGwKZYxt6yGvGSOKR/d9ZLGBNaXm69
iyicI2brvgyB6cHpdJM4F6xuSJIZPX0FzQO1LtvXuOK4d6YsN08KF9dtSiwU
ueJqxvEzLK9hmP/0jVtd3A78IIuQeuqOQFHp0yyDFW6Y5O6g7G0agSev5qMt
xG44kMUQ1P0yCr4vmcxliT9i7/tvw/czx8CAr/QxZ7BwZtVySXfjGOw1DDfS
fMLCrZTp9Q7ua3jnk0jMD7rjmcW97VV9r6F7x6n9evoeuPyKyaHfuW/AXbJi
NV/kgdPTBeqRrW9g1jLY+UKEJ1bn6pjW2Y7D98wNdHtDL3QNkbXTr4xDS+dI
UeEDL1Qw7nEt5sahMDCkwiXKG42sQt2SWTKYPeRPylb6IPODziQ/Xwb5e9SP
+Al80LLDLnNztwyyNKv2C0J24s/e9lUN+hOw1KNnQarli5wzlvXZnhMgDq6n
+/7pi1VjDv6lKRPwldqqsqPhfnhy2MfGqHICfESMocNqbMy5qbnbt2sC7gaX
BGQTNrpWpw2x5yfgyH3ZmrRKNo78Wvl46TcUtBjorb2kYGNpkMJsnxMFERbT
sWcDOLhkxZumzFAKzE13lY1Wc/C2Uv1YajIFucvyjMOUHOR67Dl7IpcCp4bz
g7cDuSi58U9+XAUF2b7R/dY8Lm7++8gtjSYK6OKmB1qLXMyp9BPWSSho1uia
f8glaGAgdIsbpmCNjTim+AbBkq9JysUpCmaeq0/qlBF8y05//ULl1lOu8Snl
BD360xyZ0xQc721O2MVT7S81SypV7k8VnNC+RXBbFMu/eYaCP/7ln0sSEpSK
1Q8Pf6LAMLao1q+TYE2RZyNjkQK54XPbpmcEH5ro+wWr/EjEaDDvJni1tF5y
ReWE5QVCjT6Ck/Ot55ifKei8c/6RcJDgzcs0DXOF6r9mRo+ZjGBGwP0+eyUF
0bUPgwomCL6fyTZIVhlD1V6oyQkqsxtt76j8jp82NPiWoEAtepsjTQ6+gSnj
+TMEmy2ndjjT5WBKvxND/0Rww7XW9lSVFbxZedwswaSDOz2aVa76kvjBc4Hg
nG7ELKjJ4XRFXULDIkF2i4b1SZVDuVMfNyoIfubHc+6pbPvZJjnvC8HWmvIw
mroctMviF5RKgim1twNQ5f8Ax0lQ9g==
       "]], LineBox[CompressedData["
1:eJwVzns0lAkYBnDGWhNhC6mJJEWsJrmuVO9L41JuYz6XFt2sthCpkRLFManT
aUubhFFUOlgpmy5Tg7Fkurd2XcYtt+hCvu+rKKFhv/3jPc/5nfOc57ymEXsE
O1gqKio/M/d/ljWmW6uocFHY5Gq3+YYCgslEMwdNLi4rYZc2SBSgqhXDidbn
oq2TVjC3TgGbPAh2y3IuSo0V/uwWBWjUmA2WBHBxMrgyWDGhgMiyhnz/IqYf
91bY5t4GJhnfaxV6rESSfzJsW28bbDSWjxV42KD8le/JX+Z3QPuUt46kdBVm
mYozSlq7oD9tne6mUVvcbGDW6JDUA+L0pbIUJ3sUZRT+4XKqD3Zf1y7l5Dig
pWg3J3uqH6RHIpJcex1RMOR5pct3ABYnSTP63X7Cegu1lE+Vg+D4QR3VLzlj
vLP5tzWsN/BYu6b/5uvV6BTPyTq3/C0IAw/I2jzW4Pt2yWFn/3cgdr2YfuzM
WizIve/r4TUEe6/dHbvXvA6zR9882b9kGGwKh/i2CxBFrp+pjx+H4XXVivzn
1Ygp4S6l1nnvwTx2NN0szhVbKq06x+xGoPZlpesaIzccsBRrqtwegfMmyxPy
ZG64sDjUrmU+CRNfFvFuxa1HUYmGcXsCCeLLz47P0eOhizRsLV1NQk4of7TD
gIcDSt0ybRkJ5/Rat1yZz8NA3bfuP9aScCqjx8FuEQ/D85K0I+tISIv6OBBo
yUPygYh8Jifh11WGmAs8bA97emj/3ySsqov4umg3D7l2x7637yXhcd/ELms5
D3NXJHJTp0mQpXV2vX3EQ7Zv0c2oGRJuL67yK3rKQy9V+WlChYJL21LsOf/w
8M53Q5uWsShI6pue0ejioWb+ndV16hRY9anlDHzgYc9dZVHnbApO9mrLxUbu
WDd5ISqHQ4Ffj6nprAR3DKkeTRTYUzCnYsbHytAD67MbS2q3ULBdf+s89mMP
9N+7WFqVQQHtk0BYxXqi9yIv0/KrFLSuF+3U0fXCUKrbrF5GgWej3oIKmRcO
s+UanDYKxleErjsXsQENQh6+lgxTYGe6RNVRfyNy6NbblkoKHjUNiPPqN2J+
y8X9r2bTkBcSVuq6wxu7vX4/X7eAhvH4QKLYwAdjPhfk6prTkLVZbZ+/1Afd
dCVznG1oOM4u3ykN88XmeZd1TJxp0PBSTPZr+mFq/4z9X640yEPvqvrd8EOL
l+Mt4140/MCaX5y41R+LPQMNVfk0+MgMe/ey+CjAVQ1kEA3VoZeCTxB8nJgr
7LQPo2Ff3ZBR6jU+8mmXuF3baHg0R8c4R8lH6cA01RxJQ4T1aMyp4ACsXRn2
xDaKBivzoOLB6wG4N79cahRLw5lZZzlbZgIw++G3hMR4GtZKMrvvhAhwu/PC
4BdCGk747epcWSZAZU53z7VEGlTlNfWaUwK8Mxhp4pFEQ616y8QDAYGsoyz+
q2QajGzk0YVXCWyt87UwO0LDWIcaObuYQLtkVps14+citz2HSgicij4mcmSc
3FYrDCojMGNapXkD484j0hStPwl8xhv0jmec+6Li9IEqApVZycXVjPVjxJX+
TQQurP1Ng0ilYUS/w76mmcDYF5lEOOMGmaHEqpXAPUEnLuxgLJybXaXeTmBP
ZuSyg4yb7mc2VHUTKLv3cu5FxmfYGQqLIQJzzTs3v2G8q/LBpuxhAgsk/ybR
jDGc1cUaIVAvvunsV8Z0RWpvN0VgJDlapZlGg1/IoXdZYwSa6rUNcxmbq96P
Vv1C4GCfE+3EWFk2PhI3TqC7suwDMi6fTvi4YZJA67LnwwLGR0tvCSVTBMLh
wwNhjMMFnz4vVRJostS9I5Kx/Tebg2enmf9kS5/HMtYq3jM5M8PsxxhXJzL+
D+bCsaM=
       "]], LineBox[CompressedData["
1:eJwV0Gs0lAkYB3DDMhq6kFKOkupUO2VIQh15nmGSmAbz5rKatrIpq1zCZlm0
TffOllsqU0mnPWgiRZmMZopGqWVHbmEIoczMK22Udd93Pzznf34f/h/+j3VI
FD9UV0dHZwd1/6dYKVyno8NCplNFYo5ICQGDR1dsZLCwhq4uVN9SAs3okEW4
GQvLr/MuOt1RQpAHYdi0hoXOA6/9VRIl0GUr+vL9WJgZUFvq1qyE/WLFNZ/b
LGwo283eZlgPVqcMjG562KKJX77qPKcevJZUj+R42KFXxJCCUVkPrRPecyQF
69H/37nv43veQM/vrnODhu0x4vy9shv6jSASrpQnOTngw46qR93OTXC4aHaB
xZWN+Dgx6pXLjWaQpoQksLsckeFtkSaYboFlCdJTPW7OqNoqF+pntILjZ33U
z92EV0z4vdnr26FmtqznQf9m1PmpMN5GoYLYnfHytx4u6D0831z/dCeI2DeE
p9O2oGxm/xbHDV1w5G7ZyONGVzSnddZlRHaD3U21r/1iRPfCdEVoQA/0V9hc
q32CGCW4YOlu8x5WRQwLV0SycenDA33LTHvhaUcJ28XSDV1e/1HHJnvhstWa
uGy5G8ZtcG5tLO6DsW9LOaWR7jiOWXtjE/pBdOuvMybzOfgDO9LgZ+YHqOke
C1tXzUHr+zJpU8cH4L2ztp4VtxVLWfbfa5I/gknxDJdp7oHjdAak0Adgn9me
hYY1HhjOMb24MHUAhrhxBDNiG3Iv504m09TQ7H7i4Jy5npj+y1pjzQE1bFPO
X1ws90Sr7D0zTa/UMGoT7HopZDsaTw6V51hqYIP1cpqjmRcmpwompg5r4GVD
ryi7ygulRY+TIko1kB24q4Ad6o3sqmcxoZ80MBq9k8hbwMVN+0hF82otZO7W
i/GRcjHg6PUSepAWzhgWHpTu2oHpKnyhEGqB7tky3sPgYcaCUJG4UAvVwWU0
3j0eHtA7UmRQr4V5uovyju7xQb7FmPbZFy1w5eZdR3R9Ufnm1p2180h4Epwb
cI7wxZBPBbIUJgkxlWrLY3d9MZe4l3CWQ8JLkzlLrkz54pDD4EdJMAkh64YP
XQjww62+0Xol0SQwV/nn9RX54dXj3g9CT5KQNivD4scZP3T4bPuak0XCFklq
56NAPk4/cHcxyyPhHC+s3VbMx6tTS3OED0mgVcuqGBN8FNK9vl6qJOGpftPY
cz6B6Q3/Hhf/TYKlXXX4zT8J3O9wfdFQGwkjbXqDxnkErp98GW/VTkLtCbeo
xHwCRZlhL3wo//b2aay/mEABx9r+PuX2FGmS0X0CdyRbcaJVJFytK74YX0Fg
nUNF4GAHCWaHRCU+DQQafEkMU3WRQJq1OcgaCay47VQ1q5sEhdxcwmwmkNC1
MXamHGuaVaHfSuB0TFv0JcoN5amKik4CpQHvkrk91H7DUy2r1QSaSCrvlr8n
IazkeVCWhsC+5lqjj5RRoKvSJQk8nhMpMOslYaj4WFfnJwK9fC8oIynzAhMH
MkcITDvTOrW8j4RVtPJw2jcCx4M39/pQnhKPkpGjBHo27C1Polw4HffP9nEC
2TGmzi2UTxaUxkomqP63gm7dfhIE/C9fV04RyGixSLSl7DBp92vGNPUPScR3
AspGeVHjMzMELnPNP3aW8n8+Olip
       "]], LineBox[CompressedData["
1:eJwVzns01HkYBvBxW4MVosSSLLk1yRa6rLzvKGLSML5yL5u2zaFSGbXRSY2V
ZC1lJUrKaohKaZcQtTXknG5bjSg7MaEY5je2QYyd7G//eM9zPuc5zzmvbVxS
yA5NBoOxib7/s/qZgMVguOIuo1zzp5liCJMfsPPQd0XtU+ananLFoGGQaJlg
5orqJMmWnEIxRPgRptjJFU1zMgd4l8Wg22I3UMlzRVzMilSJxPB9tehc0G90
79UlatTuBJvMLwzK/JahhHXv82RmJ3Cs28Yv+Lkh+6GD4cq8V9A9s3FOQ9U3
OJBY+bR/uBukR72NIpTLsfPMkxT56h4oEdi3Hl7pjqtyFBeuF0hg1zXDKssi
DzTqfsiMXtAHTUfiDrF7PTFmv+PJ0FApLDrUlCn1WYXbBRbGy6rfgeeYDupc
XI0aHuwQvfF+6DBskd4cXIM3K9SJPdaDkBx6sLXLzwvV2TdS5/LeQwm7VHA8
fy26yx3faG35APtq6sdvv/TGyxaTq5TcIXArGw5eboF42Fj/nqHXMAw2Lz33
+A6ihB3ffpkhA4fdSoHdHjamli2y4TXL4O7fdWwvKx/kpN2H2MgROGPjxC9u
9UFnVe6Ef/cITE8uXH9rzzocK+hTfcUdhZJLj7JMTNfjx8q6iJ6aUejom45n
ta3HE87wjKspB+5bW1s9vi8Wd1it9OTIwaR2NtDF3A8Tqq6ZnsyQwzaz2PnM
Dj+MzL9i035bDopAPnHZvQH5Ceez9/bLoXNdxs45Rv54PpdqaNSlYMMzU4va
Vn+UHps3I3Gm4NPSKO9f4wIQZf7uRb4UrLD9WsPTjIMZpVrOXbEUPHzRX1J8
n4Mif+MPMQcoKA6PrmLv2IiMyCQydILe7w0lwnmBGKcdY9hUQkHBFq39QU2B
ONNeLBNcoSCLeXVnU/QmnHKsdRLUU6Dr/0ol1edi7LcvfZweUNAWVa/Bvc7F
1eLod6InFBhrLhAeiA1Cp/gRnn03BYGt5r37NIPRO1m5ZLCPgjtRF8OySTBu
JeHi34co2P/nsFV6TTCmpWtxEsbof03mWBepg7H0w6mRqUkK4ljKxNwwHppm
sR+nqClwcdgsHLjGw9ou5VFfLQXk65223DrLw/KL+TJvpgLWNuRJ/ggPQenE
5qMrDBWQzY1/s6w6BNtZ05f4JgrQaGu5rz8TgvWy1wlB8xRwV0c8/SCEoHrD
28IlFgqwcmtLKKsgmKI6Pj/dSgHjr7XkXwoJ3vyBFZtL+3GGT1JqJUH+O1X5
OdppXXeTN1cTvJBmaXWb9psjTYcNbhAU250Vj9E++6T2l4PNBKfKnb/bZq0A
s8SSuqAXBN2FYZT3QgWMmr12b3lJcPCvyrJA2qJW8waXToKXuqIDo2gnzy1s
1ukmGJyiLEqh/aIxT9QsIbitwmSqhnY+M/OV4zDBgKyfJeY2CoivexBRKCPI
8uzxXUwbYzR7NEcJ5pCqK8tpK2rTeyUUwaEK0fZNtLnhqUMF4wSZDI9yAW0H
jcYEjUmCz48L3+fRVld/Gt3ziaCBdoVDKe2rn/n/BKgIEiqguIH2T1W3khtm
CHJuTTwS0Y4J+Thhryaot8Zd9Zy2+79uP57+TFDpomvfS9tAmKSanSV4Zune
gFHa/wEsUkqh
       "]]},
     Annotation[#, "Charting`Private`Tag$39614485#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0Hk4lYkXB/B7xc+uVEIjSwwS710ZTeUc0s1YruVVhBJtYizRkPZEMhVa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       "]], 
      LineBox[CompressedData["
1:eJwVz3s0lAkcxnHDuoutppR0UVYSZlzSZcvvRxKZDN6KSMpWOoQa0mg7bak0
ColK2K5qSGq8M5nRaBCm962km1xrNacrG1ExLpWd/eM53/P587GKjA/aqq2l
pbVRs/9b8jjFXkvLERUVmT0H3GhY15M0Z4GRI/K0Z4bfXEADwzjGIprpiIOL
hB1trjSEeBMGTbaO6LWJZzbfhQZ9xZy3RYGO2FF4M1fKomFLSX0Bt9ARt9W4
7NxtS8PMI3rGF7xZ+CC2f0XGFBoeXB5hNAWwcDUYbt1vTkNSTe+QQRgLo0zm
ZcVOpqFxtPk9L56Fj3oz9L2ZNOzjFdV6n2VhkOfJ6E4zGtojfPb2drFwKJsp
l+jRsGq68tt5bzYSvu45b75QUL9o/tq5HDZmrCsaSu6nwH3NyXJRIBujElOt
TfsocDkenlSzgY1k3bk2Vg8FlsMDahWPjdLq7rGQDxT0NtmMWl9gY1kg/6NX
BwUn0wWM62o2pv2Ru/zsXQpaR/1MZcVOyEy/prNEQMEnJTdbdcMJ7d77hcan
UqCVRUw2kTihhfNno8LDFNhah83YrHDCtIHOA7oHKUjmRDsaP3PC5WbBvdJk
CizOCfwjRp2wwe3ElMZoCja4KzP1/Z3xX/udra1+FKgOuJuFfHXGH/H9VQJD
CvJTrKv2LXTF3eOfYAb/Huy4Ma7YIncBOqsHo+LvK0G+PzLZo9MN52d2NntZ
KGFWsvyIynMRznnQzRteUw9ufbqoe3Exckf+prZk1QE9TqEi3y3Bq17nxXbt
tZCwZk9Vi/dSnJXWIqubUgv5HudSUrOWodZEGN4YfRd2XZd+q3jujrzpiQ7C
ezXAvtAV4DwVMVf0cHjBjBp4V+lQ0HAHsdQrODGDWQ02sV9T5sR5YAp9/sOx
jwqofin2WGrpiVZpHZv6m+/AmZm2iXlVnri4XeFk2F0Jw4MzvCRxy9GqJb95
6Xc55F96eHT8RC/0CBxTRLLkQL8e3m6v9MLwnrZLXyNvg/8/VlaGiSswXZW9
+WlJBYwXjXHszL2xtd58RoNJBWxmRkw2oL2ReF2tDouXwWdOImEXuxL554/o
xnyUwovlh6JMzXwwtD01Oj1OCisfT5wqqvJBV9+mK5MGykHtEOp+KtIX+4bt
F+tllIOL1WyGG3MVFm+a2y74rRyoZ2/y82pXob2hz6Ec+hbkBYcVe2z1Q2ex
QPWFfwvUO9cQwkkcnFhsfPDmvFuQE67D48o5qOfAd3n6TgJHDUqj5GGrsdVw
mt6ZYgno+zSPqIz8sVD7eM65GAkoQ6UM/5v++PR+30/+Qgn8qj1FmBTBxdiu
gssyHQlwqsw7d2kHoMmQKOFoixjuhF5cl0YE4NB9QX6DSAy8u12Wf10PwFKh
yak4gRio8abTc38EIDHTdNvnbWKItP8ak7EuEMMVXL/uFWKws1krfHsjEJN+
OeabYyuGLMNsi41jgZjvGFJQayaGZbITr8qDg3Be46Bql5qENP/t7aySIDQs
O3lU5w0JDKWi1mg0CO/t+LJ+6AkJ1bpNw3VBBD4f7WzkV5NgyVZGX7hC4IT+
10uHykj41qbTYyIk0Pf3TG6lxg2HPOP3FhHISTY/tF/jP1uqE9aWEGi5+CxH
V+P2/fJ9xmUErhJwtjNFJJx9JMrcU0ng3kdh8kU3SGDG5Iu5zwhMaqwT5F0j
4ROzzVXxnMBJMr2rmzSurzKX2b0gcHaqlmquxgkTTlfqthLo4D4gkxaT8Oz2
ifrKVwTOv9P9+kURCVkGR5rndhHoVMo1txCSsF1cF3K6m8D+vpd2b66SgBu0
O7Q/EVi261R4qcafRX91vuol8OGBiFmgsX/w3o853wicPjXRYtsVEmwYt6MZ
gwRGRm22YWv8o0T9KU5NIF/XNXCkkITSn4n9viMEujGidE5ofLhYkiAbJXBa
gPTYeo03BH0ZsP6h+f+UZltr7Pqdzc/+SeBhvTMDvZdJMBbGj4yNEcjaPant
tsb/AdkxxUQ=
       "]], LineBox[CompressedData["
1:eJwVx3k81AkfwHEGEdshR0VrK54aljEzZhjE94vClhh+wkaJ2rLGPaJBKobI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       "]], 
      LineBox[CompressedData["
1:eJwV0nk4lAsbBnDDkaJQiEIlUqkYDM0Iz0Oyx/Daskb6OJSIEop6LaXsKkwU
GdRMGkZRZCiRVucoS5u4olVS9ihnvj/u675+/97XrRZwwHmvqIiISKIw/29O
B7lZREQbF+wo5dq95YPbt8PqBpLamPbQ1PT9P3ygSIWuDJHXxjbTnomk+3zw
sCQWvtigjT89Els/cPkg0ag+WOGkjT7embHqcXwI5Ny/4FiqjcY6uXHHlPmw
OnmB1CVLHaRr+u3I3lMNtqqt4xctqeh3SLZ1UKYK7tM3ua63p+K6BI04UfEq
MHXJvslzouLMP335LuM80D/jc7jZm4qjzveMqQ95oDIzMTVwkIpEONWtJ5IH
Iy80ZzUuUbG2TflT75PrkJ12isKdoiLb4/g1vfRK6J21k667oosexfZeMdu5
MNzqmDNQqYvpd3ZeCNTngkgWsXxxjS5K+HUN+6hzYYOG1yr/Rl2kxOXlxIpx
IcY+RFuqUxc3LpBK87zPgZVFpxz8ZnXxeDzbjWPNAW/T1gwJBz0sH+6Z0/O6
CgPHTWU8xvRw0/6nHsZlFfBJ6VdJ8LQeWoxpRaTlV8BI1U1azG89vHP1u87H
MxUw17/ZkyWhj1FD/dF3DlaAkply2RtlfawknRSGsAKYlGkjfwt9LEt71bju
XTkITlT/L+ScPoYeeqO3Rr0cWKSG4OhWGkblToZMt7Fhx/onBrPGNCxsDup9
0MCG0ceRlTHmNHxb/lu5pIoNVgothYd30rCxr282nMWG8Qr/uPA9NNwTcG0u
KYwNDk8v0gMzafi35NmNh5TYIKa0osbuIw2fgYi8fmQp7KtccmVlngFeCxGL
22h+GapFiO3bCg3QWFpDVcC4DJNEfp9XiQEGyzzw3KV7GU78WqtQxDXAxIT8
zNI1l+G8FZ1c3WyAnZ61uinzJdA8EOCt8dkAaU+WzcULSkBu+S1Z7W2GaDQq
9UnerATq4wNizN4ZIv8kWyXPvRjYfbkzHYOGeBHSbWWZxZBu2hrj+8UQdQof
5mdaF8PuP+tj4yYM0eRE17FiRjFIxH+LvSm1FS+lc5slVYrB5diRoxvpW5Gv
qNA/1XIJvsVlJCzN3oqTfT23mIMXYU1MffKAOR1lziJnxKII5spL5d2s6Ti9
1LbrX3oRvHyRVvpoJx0l+1/SBJuLIIfqd7fGg46CFdL7+fJFIPZJ7HdyGB0n
Is2eSgwVwge3nVFaLDruZZgs8DtZCFxaf0DkDzrayKndTum8AIaj4ihezMB7
LdWLlp5gwbUnaT+Vyxi4L2+sjhfNgrVX5cr0OAw0kFG86xLGApkANcndNxg4
fE/1WbUXCz49N35R385A0yUS2+oMWcCqiwwO/8HAON8J3pdvBTAfP5D12twI
f3DWJnfsLoD2JY0D1UNGqNqgu5V0z4dIl2hBj6Uxur4qUCvzPg8ssyIyJcsE
3WUlB+8+OgsR3NrxW89NsUopn5cRnQvUS5+ZeisQ1yhH9Voa5cBQw5YLT+4g
8qb3xo4yskFz/xipHmaGvcFa09uss6DpDd/MWMUcudOcpuixDDi/ekNUgcAc
3cbbJ14Vp8PM5CqLmrDtWLNkHdHnnQaskscnl8pZ4Ftzbd5epzPQ3j8TvLnV
Aq+vM6N4Mk+DQ5+a2qKoHZj3dTS0MjwVlvLm7bUULfF7nZKmde0p8Jf3W76w
3RKX6exJCqGcgu/2UYTWfiusUKz9ohhyErq2JwZJy1ijSWrTDfPBFLDqkFvB
E1hjH6d9KNY/Baa2eJqeDbBB264EZuxYMuirraUYytvi05bAZ6Mnk+FB53tW
wT1bFP9LPfnrhmQocPe6YrbXDvsEG5QbepNgKtyFKFewxxcjlEmp00mQ6yN2
0LHeHiczu0OLrJLg5MJrQfVeO9EhsKM7YnESSFh3/xqQdMCsx6wztp2J0OpZ
S3G47oCGW0eaaCWJICuqVH7YzxF3y805rolIBHuB4rsIUSbeivRWKbFOhDue
xW6pBBMLTT8r12gkwsG7n1USuEwMqqYwWZREeLBUWjXvNxMHPT/Y6A6SELB5
LDTdzQmfszvGuA9I0NJ0LR+sdELZ0yYWj66TkLUoZ6XvvBMyUtd4arJIMKnL
fHvT3Rlr7HxHvVNISHUIfqXDcUZVltcRzcMkUFob70nOOqNN7u0SRjAJTeIv
ZlqcCTQ3XDuk5UVC8KO8ICkXArv/OkH540nCskyvLmdXAu27oxn/Ch2o9L5q
wJ3AGTGZuWihJTf9DJr3JrC0Tfpx2y4S3Jiy3UZBBKZ+qEv924OEEZY9vzqO
wAjzcNcWVxJUqK0hl9gETtnRM9qYJIy/FPu2uJzAXBGrDxeEfpJofiC2gkD2
kSjfCKHjepoiXTkEBvmI81SEfhVff1SqisCvmWMdUY4k5D8V3ryBwH3UGws3
OZAgH8riO3YSKEgwlOfZkTAs/5LW+JzAjNOvfU4JfV+gWKfVRWBYaVSbv9CR
y841iPcSeLfed1xe6M7bmfcb3hKYHa9w76itcN+Fyd3rPxOo6Kyn6mwj3Iff
4nHuC4EbQvqdtgiN3qKvRYcJbLMeYy8U+jsv4d3bEQJbZDXKm6xJcHCP/ZQ7
TmB9WYOcjtCalNshlEkCf1QVGEkJ/ZszNRw2RaC06/mEj1YkXPsT9cPmF4GH
Vz3cUyx00pWayLpZAs9l/BQ9JrS3888Jjd8Evj6g2rxLaNoc9UjOHwLr1M0u
GAotVX7g1/w8gf4yrmflhP4PdU+zXw==
       "]], LineBox[CompressedData["
1:eJwV0ns41HkXAHCjaFzSiIpCLOWSpFaUR76HMrnl8vsybJSSS1FKqVSS5aXa
lrzuKX4jYnK/ywyjqSZWya5bCUthq11qpc26TN7v+8d5zvP54zznnOccHf+T
VKC0lJRUNIn/5+LOWGMpKRO4o7z09vpWEeJMntPdLm8CKqs38dtFIsRQCF0b
omoCJ5Rjw882iZA3GzN7DEwgsf9Bwy9VIrSsWXesyN0EvgU8ZIbdEaGA4ie3
XfNNYLBbvpMXLkLr42UVaPYWePGM4S2lIUKOmuIvuWxTkEmb6DYOf4hezTsp
NfC2QiYn9fpvK4ToTYz1Cu/pbaBSMLdcO0OAsmP1hFEWZqBeKdou8WlEx8uW
89ZmbocsDm+mzrQB8aP9L9gMm0N7+vNQZlAd0r7Aj39juwOU7zi3aVbXIPO/
ZUCGuxO6cix6nayrUdvy5jdV45ZQ5cj6NLCiCp3xOC98ybYCdeWkj9pjFSjb
Jic2IXkXqJlY0roq5Si8pP7Lg25riIllC1tjS5Ep/cFtmzrAw5R9IxMyJWhc
sPn28yYAW4dpy+GO+2jjielY3TAbUMmfnf++gIdaBqttrDRsgVnzhXkwvwhl
rDeIuCW0hatnWVX6nYVo9qvWnpqw3WCrrzfYL12IsvOeXVVW2QNyremMH364
h9pGZo8ai/fAdqZjQE9dAXL5XUdHLsIOnrOYFd/pFyDlikVnozVs8H59rVa2
Mh8dVvVbzWxjw7HV0ZO+Vvnok3MENjqxF669g+isgbuod3dcsNIKe3j2uWTr
moS7aG+ninqF0B6iBE8MK7bdRTOb91un+TvAkUhmaP1EHvpe5zuGuaoj+Kxa
EnSDl4dau0azbz1yBM221Tj9eB665eXDswl0Agv2lkSwzEMzpzxw4SpnwFYv
y43l8lDqgSWnXfnOkLNZPVphhIuuMkuD+T77QO5iUVu9gIuW2ffNvZF3gWsN
K8A3i4vE++sZLuUuUKcepjZwkYtY0mqF5/xc4Vns4bWeB7nIWbhmOFzaDbqV
lyeXsrmoaT+Xcx27weOgAp7cNi46LfqgcaXEDU5/HRfYa3FRq7KSZqbEDU4V
3OjQUuIif+Pp0ESOO+h2FJk9kdDIaKNn4ViZOwzsK+epj9EoWS5l7cFFd7j/
bFPI/U4a7ZXKvdAiRcEFM5l+L+JvX++/0pamYPBRU6wsceiYKGN0KQUct6iE
gBc0YrdMrTwmT4Eda+c+3Q4azUe4K0SsouCGdUFrSTuNgkZYC9c3UdCzzGDq
nZhGuxpuDtV5UVChb7pBrplG2epx4kVvCizv2G1vb6LRv5fOlTnsp+BQRGvE
DeJqOHB5yJeCkXX9PyoRb2w30pTxpyDcqKZrtYBGrCGxr8dxCmKKnXebNtJo
VHph4HMMBZGRtxgJdTS67nL09ZZiCozHOcr8chr5F8ixz5RQYJ1rnHGV2Gqu
uKq+lAJXq1N2nsR/35u8tquCgnMBK3WnymjkLTlt4VRLQalmVL8RsX7p5bQg
IakfEhkUltBILJfqktNFwbhJq0TAo1Gunxl/pJuCsNN3GpOII+t6N+j1UuBu
EZJ7mNj4sJqk+CUFlNqjt8uI0x7klDwYpOCplIEnp4hGR4J5zJ4/KGj+lfFy
7h6NGOLmR/LzFKyaT2D459NoqVZ20bEFCsx9Bg+YE8ueP/dzm4SCY+va38sT
Kxpu4SRIYTD0M/+p9i6N1BK5HxiyGLLa2mbliE0941izLAw6W7lXmrk0OjRu
f/DdRgwpO2vF7FzS33rDbrYBhg7fXa+1iYMyGQb3DDF8rShaN59Do+MO/Cl/
YwwjKX/qVRJHlm2K/30rhkjnOlcN4uSzSqW9VhjW1P82t3CbRi0yPbOPKQyS
Hyedhm/R6Gh7ZrCCB4ayvnJFEfHKmz69lCcGmFo7fZc4QG208o0XhoXwdtNg
YvlNn4MXfTE4HzoaNpVFI44bq88yGIPdRcEHReKP2c7VVZcwiJ+GZ/tl0CjL
j6U9G4XhLT23YEdso9eTCNEYFgcm44yJ08p8jnXGYKi9PPFtNp1Glg9DtCfj
MaizLXkZxPHj15IMkjEwy/Nb+tJopGEqDqELMBy16xOGp9LoS/+SScVCss91
VcP9xM/jbE9eLMJwvMG8xZb40suWM57FGGZ2TIepEr+O5kcpVGKIVhx/3ZhC
5uuoSDovwJDjEdOvSHzq/EfWeBMGfp5kfua/NLLX2ZxKCTEs10h1GCWeiSjO
3CzC4BnWE8gn5mjc444+xfBzNpUXQqwaml3t2oVhX6WfencyjSZU+82auzFY
evz07iHxE+GaBqNe8g8LsiPlxGdWpgtkXmGoXyJ2vUHc1XjziWAIw87MPwzY
xMnM+D79Dxjeaw3VP75J7lX92Dv9Tww73u3RqyUGX+kB6QkMGrUWggLiTxVX
hoc+YmDXJQYmELt4XXyf+gWD1j9FxU7EGxmNIYyvGKx9VY/sIpYUz0yEzWAI
lC3Zs4W49FvElMMchtbdenEqxP/h1ZxpmMfwKW1iWIbYl/r8j54Ew+Cl0sB/
k2hktmAamfINg/x7L9W/iBUKT84tLpL/efH2ryHi/wEBlqhU
       "]], 
      LineBox[CompressedData["
1:eJwV0nk4ldv3AHCHRJQobkiKhBDnOMi8lnlIJ86b4Rqi06BReA2hJDKGZHZk
LEPkiq5Cs2i6miR1K8qPBt0SJbN89++P/ezn86y113qetbYS7xB3l6CAgMBj
cv7/rnkSqyUgoI0t44uXGvqXg9u3sLX6YtpoMqu1+6RHOTDE98vvk9bG+yct
K0YcysHDlhLtVtdG94LcwBGtchC5vnawykUb523T/mz7WQY7a9oLt5zVxj1T
Bb35J8pgdfxC8RJbHayf5y3a1VgKD8unGd3OOlgut+BZe0UphN0anhT10sEz
9sLR7IJSeDzT8zH4kA5+4SnrmsWUwpHgqjbbfB30ydxcP88phde+9pHDQzoo
MeOZ4tNXAo6rOsaKbZloKNpyjKKLod1Q01XNiYm5nfHB1V7FYL71dFO9CxNH
HJ4UyFsXA/ukT9gtbybWpsY+dZUpBoWpXxP9wUyU3Wwiq9JSBMPdqjMqJUx8
k5zUOSNcBKdTkxi1E0ysc9BWDLtUCIurh7ez55gYXRypvLakEBLubG27KsjC
s2Icn88phRA5vSaucwkL4+jEgVZeIfD2tCwYXstC88FtxkeWF4Ke9RcRljML
pavEZFwi+PBqZpPElWoWvrKKfePuWgBfO7Zk9tex0GWyRP+HdQEIZFB/LL7E
wjwZjnSxXgGoq3gpbr/OwootDIaGdAFEOO3TFu9iYfe1FDHJ7nyQL0ri+M6w
cFHxwDsB93zwNu9IF+HookbFXd23e/IgUPTBMl1KF32CLz6O8syDE12dud4e
unhG1N9IwykPLuzuLm7g6eLrP5O0LunkwVz6wF9e4bp4nyG9l57IheJ3jCf1
pbr4s2Yq90xyLvTHmC/1+KmLptJTBdLNOfBZdrpszyTJL2/sP1+bA8MXm/Qi
5nTRu1HbelNJDsy+1/Lki7BRpd9mVWNCDsharKx4u5KNDTNGxyTccsCZMWm8
3ZqN944Umv0az4Ybxxt278tho6bu/TBZi2zokDs4Fcln4+lxoV0yBtnQ2aCe
erKEjb4xZxsUNLPhdX9Jw4XzbHxY4s52lMmGXxbps8PX2YhbLT1Wf8kCLcH9
mfRHNlq3lhVW5WQBP1blxpGNeuirnbyg/2cm2Kh16s+Y6mFsAMvPfCgTRv6h
6yIs9bDN/C5W9mWCncydM2Gb9VBtJcM750EmjFVtjwrcoYfsZ2Vp30sygfOo
2HDnKT3sdsqpS+JkgpCs3KVNn/RQ9qX/q4nG03Cgbkm1fJ4+tlZqunrnZkCD
AGVlckYfn214uiYtPQPGqfw+rzJ91Bpk17YnZMDxaWWZolp9lO193GcXngG5
doaxq2/p4456iekijwy41c/zVhnSR66pdXusQgYs/6NZUtvEAFce8OuadTkF
rdG8CIt3Bvg+cveXmso0ONeXNfVk0AB3bbs28zM/DdLMOyK2fTFAy81r1B1O
poHfb7XIqF8G2BfYxF8RmAYi0d8im8Q34s7gI/5Wxmmw9ejhI+sNNyL/e83r
h09T4VtU+jGp0xvxi7fYCCxMhTURrfH9loaYkqpUoZ+RArOVZ6Xd7A3R5raW
jkd8CvzbnXr24WZDFNymlhcXmQKZTN/blzwMsU/k8puxnSkg9FloLj7AEE2D
DPTROAU+um0O0eAb4p9sa9vgj8lQq/eeR48aovfg+aCFNslgMCKMwqVGGMyQ
OaAplwQXOlN/rKwwwm1yd5XfSiaB8vnlFbo1Rqicce15pmgSLOUpifn9bYQf
rFwklk0mwufnpt2t943QOc3Byf1lIvCv0HsCR43QqWExczI3Eeaj+zPeWBpj
0E7x/wuQT4T7S673N3wwRpbsIwNFVgIMjOtEGPxnjJxYZdNT6xPg97tyyasj
xigQvKZXWDkB2I1J0D5jjNmGPW+FlidAsdvWoh4pE3y88yJY/ooHuuQ/jxkz
ExyvUhBrb40HRZb8U+tcE3Qs257e7EDiW8NvvLQ1Rc/NNg7bwk4A36IoNiHD
DKf6JT3V5eMgqPbyWPNzc5S4RX3B8ePALBly1pVDVPhPofTrxxj4cHVDYec1
xP2L61JnFseA6sGfsWsDLPCZ7wN3tePRcPNto4WpgiUyq/lSLeuOQu5q9ZCC
G5YoEBkVZSZ2BKbGFa0vBVjhQk+w4sxGAr/sn0Sp5da46s3MmUzFSLj/fmqP
Voc1qjxIUU5wjABOn5LSohAbXLR8yavvmYdBqn7eSWOFLSYXnku5Mh0O26V9
/xC9b4tLk/qO/uMfDt+dQiiNg3Y4cre7LOtbGLywivOXWGqPQ592MRRiw8Du
yXK5+hv2KJ2Z731LLgwmNniaZ/MckBfSM5reFgpsJWWGgbQjfk/+Q2f4YCjc
6xrgF7Q5oog/P799bSgUuHtVW+zahLzR543NH0JgInArVSnjhDJl43f9z4dA
lo9Q8JZWJ6x84D85HxYCiaIX/Fu9NmNBcb1prmMIiNj3TPeLcdBGYMQscnUI
dHheZnD+4mDE++tT+TM0SArKVob5bsFH3LCj869ocLqx4l2QoDO+GWgY3HaN
hmuepW7JlDP6qb/4J/QsDcG3hxSO1TpjTFN7Qd1JGu5JSazKm3NGrGdy7A7T
wNP6uT/NzQXz56djluymQUPVtXKwzgUrvlbdaXOjoVlONVWj3gWVikqd04lt
lkwEBV50wbmhjN9/EvuN5ZvNNrrgy1Lm9VFXGvLa3nYvb3ZBhQD3dmXiBb47
hazaXDBMtHo0haKhN4/2K+shnvY7QTvTkLEoU37bvAs6eEiFnnWkwU6gOOKm
ABfLuyf0aOLf4+dfrRHkon1pl6wV8f7B27kDC7jYGW3gNOBAg+3N0WV7xbi4
fjbIbx3xTIiLeIgMF+0+FutdtKNh93vJ2WRN8r5kqdl7axrMrpzqbXLnYv7+
taFVQANfLq5j3oOLB61+R8YST0aF1Tl4cnGu9lGRD3Ej+hzt9ebiq1E1Y2li
1Ycaq4R5XNQIfNMZa0720dvhvfUAF5cwn3N3mdEwIDj75kcMF0Pe7qsEExqS
OXte69Rw8dfh7+V2G8m8zy2ypWu5WGRLm2gQm07XNFy+wEUp45ffFhOPVHxL
MqvnYtxp5dIuAxo85oI3bvqbi2NnZ418idUuHM3efYOLhkqhpkf1aehYlMUp
6uLixU/3HDvZNBT76rW+f85F4wdRUo3Eh5terFN5wcV3vA2jecRa22Xnal6S
+qyAmR3E2c1Ftc1vuSg7X2E8p0vDDv9q0e6PXCwc++SjR8zouN4mNsPFsJbp
hU1Msk9FftXeWS7ejKkcKiReGB6Wen+Oi6FRLZ9jiRev13FLEKDw5M0fJi7E
smmlQ4yFFAbZ3NH/rkMD0zVOckqSwqKrAYeYxH4f7Ld9UqXQXNn21r0NpL/5
OitbdQov7ohd3Ui8O4+hXrGeQnaWPP8M8QGH1lGeFoX5dub9QcSH6zTj+1gU
vuQHXl5FnBEqceGFKYXV6yJCI7VouCncPXWHS+FcYKaEvSYNex7m+YtvpfC8
dRtjI/GyU14vuK4U9t38LK5KvFN24GK/O4WilwR2LSAW0/zhP+9NYYD1X+vb
NGhwc5bsMfan8IpE7oQF8TDfqbEhivQzfRjJXU9Dvq/kmqkjFB6X+IDWxBYq
3WkYTaEEzV5lQJxd57X3SQyFaXqUrDyx8a19a77FUyj5fnLFgDoN8R+S0tUz
SP2nlzdGECswO/aVnCPz22/3tEmNhrF/hb4trqTwsWHlbDVxZ5zlocgqCv8N
vmd1hjjq5U3atYZC4TaWchzx6+jWI+IXKXw3OqzIJc5/VJ8efpXCFSOhUr9U
aQgMH5b8cI3C1TmJH4eI7ZU2ZHFvkHyJgRd9xBMhNXkbblMYn+sh9IDYTaGi
dOAuhYlbducXE0vv5zdu6aJw3NnzHIf4q/S/etefU6jQGyhvQ9x+Y8UVjRcU
Xld0rzEhppflXBV+ReHr+pAV64m7Wk61X+2l0AKVVYWJM0Tje9SGKFS/EC/R
to7sq/GOR84XCu8tWaDYSozegm8Ev5L/sOiVbSPx9/pj73qHKVw4xBssJ+a4
R37OGqNwqIPNiSdWZbTsY4yTuEe6WjTxXM3E14AJCnmSQvLhxBd+h4w6TFMo
cniV417iE9WX6CszFB4N+juRR+zN/fFLZY7C1HX2fV7EerPMw5m/KfS2eLbZ
lVi88tD0/DyFjqH2PRzi/wHrxbIR
       "]], LineBox[CompressedData["
1:eJwV1nc8Vu8bB3Ajo6yEzJRkZPVYpch9GdnJc44VipQRJSEVkYzUj+J57K2M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       "]], 
      LineBox[CompressedData["
1:eJwV1nk4lc8XAHBrhOypRKlUQvayRHOoZIt731cIpSRroci9llIoRCK7rKmU
JISEbNFC28+aJWt87VsiW35z/7rP55n7PjNz5pyZs8PWjbjAwsTEZMDMxMT4
zf4WIMvEJAdEpXt5kORDZDbhtesAlxyoihjWuoo8RMzcLqLOwnIgVpK8w5nz
IbLQJTmbpeSg+9o7r5jxDMTxdtevLKoc7A2rqSssykB22bUPTDLlQO9hlwyv
YQbafmsdd5quPEgv0sf9bqaj+odLzM0UeRC6XXvd9mo68qqa/MtpJQ9Ot5Q8
zJzS0dfl1qErbvLwvG1M1omajvyuZNXoJshDOGEQo7ozHXXY6PlMjsjDo2tF
kw3hachAvG4uVVcBBixfLK9XTEW1ajIn9xopQMYtZr6zoqnosGlU0UuqAuw9
Rz3dyJqKlMNOe1VZK4DHUtkiV1sKElv8s9B3RQHmSi45fbiegiab9yxLpimA
Rn1zw/GmZBQVHsL8fEEBHkk4GBnce4B4nk6eU15VgKMSZjptvg/Q7XemNWUs
irCLmKL5Oj5APksSgZ83KMK5ziiR9ToPkK3jG7bJXYow0OBtfWA+CakcHeVQ
pCjC5ZrKyELbJPRj2ZD39VNFmN9XR7tomIjG60zu971QBCGFhtm3hxIRUyQp
wvNKEVSXY7UkZBORlKTVtnNvFeFoVMCgyIZE5G3kLMfdqAg8FiVc9d8SkGhK
iLHNsiKI1UWlq1gkIOvDdREcxkpAzY8sDvGMR+6cnwSVSCWQ86otqLePR0GN
n+OsLZRgxejMf6Kn4lGOfXNqvq0SXPDzyR3UikerEQO5VjQleOWp9XwnZzxK
7WH+9jJdCYL9vl+STotDfTcO81n8VoJwrTvpC62xaHjzUobjXyX48t1qTrQh
Fk3mFal4ryrBpmCzIf3KWLTSK2uZxKEMo5biLvVZsWiz9tbHXVuVYWyfl6Op
dyyiMP/VOHdUGbRGTs75b4tFFTfz7Z1jleFeW73zD/cYVLfl0qJPkjKIaASg
k/Yx6HO+VHhYmjIMy2rzdVnFoI6+tPycZ8pgfn7ameN4DPqjHbEy+RaPD6q9
bRKPQbIsLvc9hpThXINLidqXaJQUIFnhp6oCjXZFekNK0ejY3s8HljVVgGPs
85tqqWg03eDxwltHBeRMInSztkWj4xvfJXudUAHTfpp/JFc0mss65+t+XgU0
h1+v7+i/j4y/pKrZ3VMB3vAPkYdj7yPWzVteGf6nApS+Bz6LTPfRxRcbnorG
HwA+wRfm32YiUT4TeeRQ8gFgXUtmshmNRPNkQrdVxgGIZ/+57U9/JLq5tHNj
yvMD4PfkaapKcySKO64WsL3qAByPav+1VhyJqvpsrSVHDoDAEZpH9bVIJCRS
wi936CAE6x+JqeaLRKXXbb21ew6CRDW45YdEoEfd0Yvffh0ETdG+mEzfCHT3
cJ33mdGDwPYwiJLhGoHO/tvr4/vnIAy2Gp+sNI1AHNcnfIq4VSEtd0QqaEcE
Mr1G99unpgp337J/3f32LprwjfAXiFKF9GmpdR4r4UjCu/RWn44a9C2p/yhO
CEMrTzKFzfTUYEZFQMA2Igy1N4dn1p9Qg8W91OqNQWHovoJN9SsLNQh2r7GL
cwtDrMOsq7dc1cDe9HXNsm4YGjI74SmdpAZNfxXMTRbuoOcqvbYeM2pgMLjS
1HP6Djo4zQ7s6erAVrpvcA5CUc7n8Nmtj9Xhx/sTm/nVQ9HOZ0KPlbLVocJY
i1lRMRTx2e7gOluoDrFTqT2BO0LRcJNmc+lHdbgXGKB1iSUUJb32cHSfUYcd
nqc5DepC0Nr1vshOHQ34azBpvt4kBH3c8LYvf1AD3Er1ppIuB6OBeXnvg2Ma
YH5qbZubczD61/OQv2xaA742V2brnQ9GygUhqHZZAz65iNVwnwxGqWamKa0C
hyAqNf/8/9SCkUfamMWy1iEQ4p7cbsYcjLYpin4/GncIlndJs0vG3UYeprSK
Nl1NsK2ZDm79cgslaacE3I7UggVlUUmloCB0+XnxXEnTYRA22F500j0QKaSN
UJS2AJAm191d3APQYNn+B5/LAQbvjOw1y7yJ9lz6HbDLVRt8WPIiQwduoMqu
Am1NMR2QfV+osF77BorbLuWZWKEDbFGLxjXe/mhxftvRV65H4FKNsBSH/3WU
lNEQLCB0FB5bRdTO5V9DH3sXHWXrjkLQqA7zp0k/ZNy9Y8d6z2MwNlC1o0rX
Dwm8XDOS3qQLw5p0Pe1yX3RO2EaE86MuaMm4xPuq+qIpI09S+tJx6JXbrN7+
yQe1HAl04OXTA711EpsVnX3Q8W9CW15W6MHuy+VPdvD6oIX9lodjbPWhU2Mz
079qb6S8YyfzQWED8JzeNTFN90YfGgeSEmsM4LSm4tVqdW+UaG71VPuCIQS8
WF1OZ/dGC+6m5JONRpDaqF1d00RH0adZr5iUGkHkHj2pzmw6CubMcSi1OgGU
TaGyocF0xKHXutTHZQwOQRe5+ezpqM6ymNk41xjOHHqU+seAjvhZNj/xsjGB
Tdq1wrmKdGRUsannMgsFWh1vusaJ01FF7x/NYlYKGFf4LJ3AVmBtTlpio0Bu
0nQRO7aQXqRZIAcFuH/wlV0Vo6OO/3F+jeGhwP5ikxXzrXTkOLhY/lqEApsK
Qo12b6GjIJ6upFVpCtjNSL3qF6ajcst0s1CSAuXvNGQHeejI/Mab/SOmeP7W
hamH2LOPG9n0zSjA4746dBZbaobtFecpCsz5xLv+5Mb7D3biCzlDgZcLq30/
uOjIuVDp420nCpD/XPTbOeloE2+depA/BWzGPB+ssdHRleoRMf/nFLjt4OzW
vUpDr4hRvw85FHDzm+DLwZ4bGO3iy6VAg7JBuzc2bd14cnoeBZ7zWw5txPYz
nBSrKaLAbzbdYZMVGgpumRVjr6LAx/UO/g1LNJQ8siwW1kyBij1bU3oXaKjb
Z8WvqYUCGzWiD7/C3s6z2rW1jQIGnWoct7Efyv1LzmmnwBRP+wZZ7CwPJvGv
3RR4Zs825T1PQwWrbOICIxTwdWn+I/aHhj4I8IrHr1JgYGS53H+WhpSe6M8v
/aNAS8fJjyR2ssatb2eYqBDY37a2F9v9/MrNPaxUoG8T+f19hoZEi0aHijip
oGhWPyyJ7WrxIa9ZiApOHpmsLVM0JJx246igNBXytVXunpygoevK5eJeMlSY
WtrAJI898mFhvl2WCqwh+1M4sSumXZ9lyFMhto7VrHychhx1TvMqHqBCRXdN
1W7sskH1HyZABd+WhctMYzRkK/vb5a4Znj+nqKd5mIb0C7s+jppTgZ/5vXgh
toLm+916p6gwWfA3IBr7n2FiD4s1FWb8ImsI7AcuiKSfo0KaqujGpv9oqDk7
TOP8RSocJORXOoZoSHef5Hr1ACpkN1yicwzS0P78DfZxgVQIYyu9OfYL7099
oeZ3EBVmhyLyvmH369X75QZTIZIj43oCtr+j+/Suu1QoSObplMEuySpv402g
wqkve+6cGqAh6T0nn/x6gff38rDz9z48vmVPuPRLKkRkopRS7GMbFi6751Eh
7nP01CPss3MJWisFVGjp5Z31xo6v6WoWKqGCyBxc2o3NZmPHeqQGr+/7PpWA
Xhr6Ge9xNqOVCkpR0dVEDw05hx3V/a+NCmQX7TNg/72+UXZ/OxV4aDf+yGEL
279eKOmkgldjewY3toHKcsT3XirYBuXYvu+moeLvAW/XRqnQxd7hp40duf6+
6Jk1HP/+C80nftLQcaZU70omAiTOjdscxv43/+yHBAsBMkxRG+SxXX5Vxw2w
EfBSjfMbP7Zu5YygExcBMRP0kZYuGlr2pHJ7biSAtu/DFXvsApfTzi0iBNi5
rdt6CtvR1unTwc0E7Iop/GWI3WpyM3hRFNtaqUsRO086n9VfgoCO/cGWa500
ZN/LvxIqQ0DcFQhLxxZvE7MakyWA09f5WCx28xepUiM5ArRlT0ncwdYuAzqf
IgHdWZZqnthice5zMQcJ6Bn9NKWP3Wj4fTxNm4D1T/U8ljtoKFSny5D5CAHQ
2q0yiw3qw9m2RwnwMYsRGcF+sYfJafdxAqpTVDTasEOYFQazjQg4GyjHXISt
9frezyJzAma/qt3ywk7aEli3ZkGAsYZthRv2X1+vF/qWBJjmrAk6YRfA6Ws/
rQkQp3vxWmPvqZcWZ7clwFXd48QR7EDZbewm5wmoNLI+p4XdGyEwkWBHgKeD
d6Qq9gPyb7msAwHOc/Igi83/s87a9CIB7L/zfolgX0JvjqZeIuBinvX/BLDr
M3Jkh10JyDZZ/cGDfcs+esX3MgGfelfVWLGXps4mZ3oR4Pdpx6GZdhoyJ0yD
JmgEfHdK/DeOXVh4/KKqN44H64euYWxXbznNBl8CEj0kR3qxB1hWOmdvEHBK
g1u7ERsuTL3TDCDgy42T7V+xUz/0P78dSIBQqUh4A7ZF+Cdf0dsE5Fd3Qx12
0WT5ebtgAornW3RqsAWpeYa5IQT8GJO0qcT+vDF+q04YAfacz4feYO+j32EN
DydgQ34j9TX27Y5rYy13CTguptxWiK2dZlfmFEmA2jl/hTzG/MwWma+iCAhp
tWLLxV45bxi2ep+AB8eI2efYxVJKVlGxBKhedBV7ii0UtvtIZxwB/u1BFk+w
3Sc2y+xOIIAjJy73EfZXEx4ht0S8P93kbZnYMgVrSyVJBHDzRzzNwA4R/t3P
kkyAxmU7o3TsIa+heqMUPN62iSsN+0h7e0FcKq6H/PS+FOz0Q1+SetMIuOCx
0JiMvZpSFSCdgfMrWrj7AbYlU6Gz50Ocz3emWRh+bZtFVGQSENsaqJ2ELVyX
pMH5mACX+feJidiX90bsJJ7g+rtUwM3w19CbXMlZBCxXH45PwJYd95wdfEqA
7TU7TYZDjR075LMJ0JUVW47H1lzKzi/OweefqlrH8PTjiRCtlwScXjaYYbh+
OWLuRh6uf2UmWcb3j6gKZ2vzCdAK2ObP8PWs/zVwvCLAYD51lGGL1SuqhoUE
zGf4uDLWo0QKZ0YUEaCTlM3FWD/PsyLexmICuBb2VjI89M/MZ2MJjnfTWBhj
v1Wmfwct3uD1GE65M+KTlJ1ITS4l4OtNGVdG/DyZDr3tKSNAPyExMBV7b861
GPsKAqaZp+cZ8Wdi2c6UXYm/f1Zv+hC7w7zKZaKKgHudZfWM84tgZT3i+Q7n
5+P3/xjn7XjqUe7rWgJ4nzaWM/JB5+Ux0eU6nN/cHfezsectQ2ZufiRAcLjy
NiOfvuftO133iQCBgchHjHzLXtfwkbOBgFvaOh0F2GcKNqTf+0LAZQOZu4x8
rVsfbZzSSMCQoBU/I99TbVRKe5vw/5M9xmux6UUtuyVbCHgorNr7gXFe5zav
ZrcRMKz/iJdRTzElKc9LunD+FJ653cmoR160aeUnAefvbNzeg61n1xuAegjI
DdH51s/Id75dlu/7CDjz9dfVUezzDk85m4fwfVYX3bnEOO+3+p6bhgloETwm
v4YtIjTWYzlCgLSrWhLjfqiv2P+6b4wAkasNRYz7Q0nk1YWpaVyPZyZZJLCZ
697WcC0T8GvD3SkDbLZtSVlOKwTUK3QrUbHX0bzCP67i+2lGJMocm2efvNlt
JhImt25PtcPefDd9hHkdCXWtOYv+2AonA/kX+Unom9ubV4atnGvzx1yQhN03
TFLfYR/k0OwoFiLhjFL/kwZszTdzmZ4iJDRW7uPowtYTt1ed3kqCl4wD6z/s
s4N6Z/7bQ8KXzqYBXXz/nz+8+4iuFAnLLFxXKYz3JZ5Z6vE+Enxz5CUssS/q
l87YypKgJCRTewmb/kLmVrciCTU1G3TisCOv8ua0aJJQtWWUdxy7kr158R1B
QqnJYEk2432rj3fgNiXBnricWowteM+qhThJgqB2bWINtt3mgbw+cxJ2emT9
rwObS2bWYc2aBJfMymM8+D01o/C3ajiQwFa0U8MDezLJqCDflwTF6FAZKn6v
E2z4JRb9SEg7UVdhg60t2XwXrpPQ/x+/gyt2zAsrp2838Hwe1fNh2BpVzhIT
t0iYth0X+Ih9azAkQiqSBI+LMUpHcX8gplDnnPaIBIp27R9D3G/MtbNO8Dwh
4dSNKAkb7M+BOm4+WSRsU620u4Lt21bpcTKbhJft4uqJ2B3XS/2480j4bbJR
YBg74cvLCFoZCSMdtrQ7uJ8RdkkqMGkk4bxC80hfPw2NC7ervG0iwanEWOkv
dm3FptfSLSQEuB2O5sX9lIdgbBn7DxJm2s+mHsJufHOvtuwnCXBq9EccdiTn
rda9IyRY8fX+oOJ+zLHgnUXsKAniHFaPnbDBmqWTZZyE46YdoTexp1769/yc
JOG+ZH1SPraxuc9w9BwJSZU5nYK4H9zD/MaZeZ6E724hDjLYq9kL464LJAzK
K3Ifxc755zmjv4Tj4fU18Sp20NNXHq+XSYg0KQqKwLYmZv9IrpJwovtEcBa2
yooC/f4/EvzIqIwqbO4nbktraySs9tOb2rH/DxTPulE=
       "]], 
      LineBox[CompressedData["
1:eJwV13k4lU0UAHBLIdmyJamIkOxEpOaEpOi673uFLFlSlrIUiousWSL7Xta+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       "]]},
     Annotation[#, "Charting`Private`Tag$39614485#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{15., 0},
  BaseStyle->Medium,
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{15, 80}, {0., 0.9844316171760252}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.848139089350533*^9, 3.8481391137133007`*^9}, 
   3.848141103982567*^9, 3.849594807079173*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"2a77e53c-acbc-4109-a24e-99f38b177371"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{62, Automatic}, {Automatic, 52}},
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 18, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"704e2038-00f2-448e-a6dd-50332a35c8f8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 4116, 107, 283, "Input",ExpressionUUID->"e87e0918-434b-44e2-bd7a-070c4e4db06d"],
Cell[CellGroupData[{
Cell[4699, 131, 757, 21, 73, "Input",ExpressionUUID->"f69ac1ab-0baf-4f7e-8c8e-f5d8eb966b4b"],
Cell[5459, 154, 2175, 55, 237, "Output",ExpressionUUID->"661d731e-3aa9-4dbf-b3e8-cec5c6fccbe5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7671, 214, 2560, 77, 199, "Input",ExpressionUUID->"680b91a2-71ec-4cd9-9c08-250da15d38ab"],
Cell[10234, 293, 1614, 27, 24, "Message",ExpressionUUID->"ef322ff2-76a2-405b-8f29-1cc3f42e7a59"],
Cell[11851, 322, 1614, 27, 24, "Message",ExpressionUUID->"ce3bf1f7-e4aa-48cb-b279-a6e113578464"],
Cell[13468, 351, 1616, 27, 24, "Message",ExpressionUUID->"cbe32c40-79a6-4ebb-b866-10e7d80f1ffd"],
Cell[15087, 380, 1643, 27, 24, "Message",ExpressionUUID->"f600a616-4e0f-45e5-921c-782c63aed60b"],
Cell[16733, 409, 1101, 21, 51, "Output",ExpressionUUID->"a6ff4938-7293-4582-8f0c-cfb5a13f2fc3"]
}, Open  ]],
Cell[17849, 433, 642, 20, 30, "Input",ExpressionUUID->"14c3dcce-be25-4433-9563-759a20ce886b"],
Cell[18494, 455, 5558, 165, 199, "Input",ExpressionUUID->"3d046b4c-7a9b-43e1-9e38-277c35044da0"],
Cell[CellGroupData[{
Cell[24077, 624, 628, 18, 30, "Input",ExpressionUUID->"9ccc8ecf-c33f-4190-a63b-a1edb6a295df"],
Cell[24708, 644, 5888, 173, 241, "Output",ExpressionUUID->"d6fd0595-0d7a-4da5-ba33-5fe87f20e45b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30633, 822, 3044, 91, 136, "Input",ExpressionUUID->"299feee6-2365-4b3d-b905-87d079626fca"],
Cell[33680, 915, 1005, 18, 40, "Message",ExpressionUUID->"b8987c35-0969-4c4b-b179-c43e6ccc5afc"],
Cell[34688, 935, 1040, 19, 24, "Message",ExpressionUUID->"6963438c-237b-4b41-9c8f-9b46be23d60d"],
Cell[35731, 956, 1005, 18, 40, "Message",ExpressionUUID->"1c79109d-61bd-467b-a6e3-436f03a6ca89"],
Cell[36739, 976, 1040, 19, 24, "Message",ExpressionUUID->"e8fb7ec8-d9d5-4d60-b0b9-ba05a8cb706a"],
Cell[37782, 997, 1005, 18, 40, "Message",ExpressionUUID->"e82986bc-75b3-40a2-8823-d3029d49fffe"],
Cell[38790, 1017, 1086, 19, 24, "Message",ExpressionUUID->"b0622c4d-74d9-4877-991c-a811370485d2"],
Cell[39879, 1038, 1043, 19, 24, "Message",ExpressionUUID->"ac6c37bb-11a5-4cd8-81bd-3b16c2cb4b97"],
Cell[40925, 1059, 1092, 19, 24, "Message",ExpressionUUID->"8b7aaa47-8a6c-4116-89d0-e10aa005c890"]
}, Open  ]],
Cell[42032, 1081, 3167, 85, 157, "Input",ExpressionUUID->"b096e414-0313-478e-b8d6-af1088ecaabd"],
Cell[CellGroupData[{
Cell[45224, 1170, 943, 17, 52, "Input",ExpressionUUID->"adfcbdbb-efbf-4fed-a0be-a698577dc1d4"],
Cell[46170, 1189, 1049, 19, 34, "Output",ExpressionUUID->"3b3fa749-381e-49d6-bebf-3df04810f61c"]
}, Open  ]],
Cell[47234, 1211, 556, 14, 30, "Input",ExpressionUUID->"4c2af046-398f-41d4-830d-9d55990fbb8c"],
Cell[CellGroupData[{
Cell[47815, 1229, 10472, 234, 430, "Input",ExpressionUUID->"94fba39d-a2c6-4763-b571-f0d0b9b49d2b"],
Cell[CellGroupData[{
Cell[58312, 1467, 462, 9, 24, "Print",ExpressionUUID->"ea391a02-4522-4411-9d40-bb51b07f01f1"],
Cell[58777, 1478, 461, 9, 24, "Print",ExpressionUUID->"8e935d4d-a776-46bd-bb65-d822bc4b8d02"],
Cell[59241, 1489, 462, 9, 24, "Print",ExpressionUUID->"deefc54f-889b-4be2-8112-ed527255a770"],
Cell[59706, 1500, 462, 9, 24, "Print",ExpressionUUID->"d78c01e0-83f3-4f4b-a9e8-2e26c62f20ac"],
Cell[60171, 1511, 462, 9, 24, "Print",ExpressionUUID->"3a7bfc39-63bf-4f25-a6dd-13c72b15a60c"],
Cell[60636, 1522, 462, 9, 24, "Print",ExpressionUUID->"866ccea0-5944-4e8f-b08d-f7d6575752ab"],
Cell[61101, 1533, 462, 9, 24, "Print",ExpressionUUID->"5494aca7-3d63-4e55-82b6-e81136569f22"],
Cell[61566, 1544, 462, 9, 24, "Print",ExpressionUUID->"8b7e4253-4167-480d-82f8-b4a4e08a941a"],
Cell[62031, 1555, 462, 9, 24, "Print",ExpressionUUID->"098b261b-24a3-4b68-b036-0f38bc65e973"],
Cell[62496, 1566, 462, 9, 24, "Print",ExpressionUUID->"9f11a185-f29c-417e-a930-f5546c29bd48"],
Cell[62961, 1577, 463, 9, 24, "Print",ExpressionUUID->"8a360d03-9bca-4ea9-b862-913062007cd9"],
Cell[63427, 1588, 463, 9, 24, "Print",ExpressionUUID->"7725d007-6358-4dd7-8812-0b5c46e23b47"],
Cell[63893, 1599, 463, 9, 24, "Print",ExpressionUUID->"4361a173-f46b-40e8-936a-0c883eceef44"],
Cell[64359, 1610, 465, 9, 24, "Print",ExpressionUUID->"4af16092-0839-4fc1-a091-1b4d3f570a57"],
Cell[64827, 1621, 463, 9, 24, "Print",ExpressionUUID->"c32b416a-e41b-497e-baa6-f207863d7615"],
Cell[65293, 1632, 463, 9, 24, "Print",ExpressionUUID->"718e5ec6-c742-42ac-abb0-5fc230466f2b"],
Cell[65759, 1643, 463, 9, 24, "Print",ExpressionUUID->"e4264b0e-8c37-4ad0-808b-4418eaa0f40c"],
Cell[66225, 1654, 465, 9, 24, "Print",ExpressionUUID->"7ccc1b6c-7f38-4619-9b78-637d187e7fae"],
Cell[66693, 1665, 465, 9, 24, "Print",ExpressionUUID->"5ef6370a-7400-4db7-9f64-d8a0b7c5155e"],
Cell[67161, 1676, 463, 9, 24, "Print",ExpressionUUID->"1862f247-6825-4f1b-9456-448989fffb27"],
Cell[67627, 1687, 465, 9, 24, "Print",ExpressionUUID->"79dafb09-06df-42ef-8fa4-7a3f45608766"],
Cell[68095, 1698, 463, 9, 24, "Print",ExpressionUUID->"aef36aaa-381b-4823-a538-fcf2d1e7d5e9"],
Cell[68561, 1709, 463, 9, 24, "Print",ExpressionUUID->"ec8c6dc9-843c-4bc6-837a-4440cbb6c09c"],
Cell[69027, 1720, 462, 9, 24, "Print",ExpressionUUID->"606c06c1-d768-4d48-aebb-5eeeb64cd988"],
Cell[69492, 1731, 463, 9, 24, "Print",ExpressionUUID->"f9badc88-7e60-46cc-9763-d07a425d3966"],
Cell[69958, 1742, 465, 9, 24, "Print",ExpressionUUID->"01bab910-a724-47e6-b568-17b476615736"],
Cell[70426, 1753, 463, 9, 24, "Print",ExpressionUUID->"d7b97b10-06b8-4ff6-8951-14ef871361b3"],
Cell[70892, 1764, 463, 9, 24, "Print",ExpressionUUID->"2ecde426-7f00-408a-9ca2-88324b1f7429"],
Cell[71358, 1775, 463, 9, 24, "Print",ExpressionUUID->"0f1fea4a-e540-4cc0-8fea-3d76435949dc"],
Cell[71824, 1786, 463, 9, 24, "Print",ExpressionUUID->"62fa3f72-1209-420d-8c72-842534100503"],
Cell[72290, 1797, 465, 9, 24, "Print",ExpressionUUID->"79a27993-fa1c-42ea-b10b-d43cb680b33d"]
}, Open  ]]
}, Open  ]],
Cell[72782, 1810, 1471, 35, 73, "Input",ExpressionUUID->"d31338e1-6c4e-4877-8f75-fe75c20effb1"],
Cell[CellGroupData[{
Cell[74278, 1849, 1386, 37, 94, "Input",ExpressionUUID->"7095c15e-b54e-4bf0-ab64-0143ddd3d35a"],
Cell[75667, 1888, 3469, 77, 247, "Output",ExpressionUUID->"0a9e3b83-bb32-416d-aea0-16fe0e51c0b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79173, 1970, 806, 22, 30, "Input",ExpressionUUID->"bba932f2-3723-4c3c-908e-f5130948ac08"],
Cell[79982, 1994, 3618, 97, 182, "Output",ExpressionUUID->"5eb9df18-099d-4100-96e3-cad2aa74561a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83637, 2096, 1067, 19, 52, "Input",ExpressionUUID->"19738409-65d1-4484-aadc-020ed4e3068f"],
Cell[84707, 2117, 1205, 21, 34, "Output",ExpressionUUID->"c552176b-5797-4561-a5af-416cd50917ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85949, 2143, 17311, 395, 913, "Input",ExpressionUUID->"f3fcf404-71de-49a2-bd23-75be16afd80c"],
Cell[CellGroupData[{
Cell[103285, 2542, 198, 4, 24, "Print",ExpressionUUID->"89b16570-01a8-4101-b2ae-db34818115d9"],
Cell[103486, 2548, 198, 4, 24, "Print",ExpressionUUID->"6d336647-1d93-4b28-85aa-a04a9a488dd5"],
Cell[103687, 2554, 198, 4, 24, "Print",ExpressionUUID->"0cb86a45-b42d-4088-9957-11e4e5fae947"],
Cell[103888, 2560, 198, 4, 24, "Print",ExpressionUUID->"3053e27c-b8a2-43ee-8d8d-ac151323f24d"],
Cell[104089, 2566, 198, 4, 24, "Print",ExpressionUUID->"41d48f02-720f-461a-9abe-7f86665c5562"],
Cell[104290, 2572, 198, 4, 24, "Print",ExpressionUUID->"d670526c-1b10-4b42-acea-53ac3ac66444"],
Cell[104491, 2578, 198, 4, 24, "Print",ExpressionUUID->"179c5fbb-bc28-4125-a1bc-a64cd650f61f"],
Cell[104692, 2584, 198, 4, 24, "Print",ExpressionUUID->"8f5c041a-6f70-43b4-9c39-b75e047328bc"],
Cell[104893, 2590, 197, 4, 24, "Print",ExpressionUUID->"ca0e208d-b314-462c-8910-7338026410a1"],
Cell[105093, 2596, 198, 4, 24, "Print",ExpressionUUID->"43118b9e-9940-4529-b2ca-07651bd284ad"],
Cell[105294, 2602, 199, 4, 24, "Print",ExpressionUUID->"19e0fac0-da2b-4a62-982a-2766a7e0cab8"],
Cell[105496, 2608, 198, 4, 24, "Print",ExpressionUUID->"f7dc5155-1b40-40c4-9788-c8b928d63ef9"],
Cell[105697, 2614, 201, 4, 24, "Print",ExpressionUUID->"bf9cbb38-78be-470e-a4fd-daac2a256514"],
Cell[105901, 2620, 199, 4, 24, "Print",ExpressionUUID->"61dfd60e-9e78-4c5d-8ee8-261e96ab23c3"],
Cell[106103, 2626, 199, 4, 24, "Print",ExpressionUUID->"bbee838a-042d-421c-be63-15cb5293d149"],
Cell[106305, 2632, 199, 4, 24, "Print",ExpressionUUID->"7ae6c374-7104-4861-b3a1-6c8dceadfc6d"],
Cell[106507, 2638, 199, 4, 24, "Print",ExpressionUUID->"b4e4a764-94d1-42d8-93e4-51075d6f116c"],
Cell[106709, 2644, 199, 4, 24, "Print",ExpressionUUID->"ccca2c69-d176-425c-b94d-e9da154cf53d"],
Cell[106911, 2650, 198, 4, 24, "Print",ExpressionUUID->"56f49fee-1d95-4884-a16a-0abb1f912ea9"],
Cell[107112, 2656, 199, 4, 24, "Print",ExpressionUUID->"3cc681d7-47e2-44fe-9fcf-9aecbd08c1b8"],
Cell[107314, 2662, 199, 4, 24, "Print",ExpressionUUID->"a3045ee7-ece6-4414-8d1e-ade9c3f35bd2"]
}, Open  ]]
}, Open  ]],
Cell[107540, 2670, 1496, 35, 73, "Input",ExpressionUUID->"0664d610-50ad-4afa-a70a-57fb9efa6d8a"],
Cell[CellGroupData[{
Cell[109061, 2709, 1443, 40, 115, "Input",ExpressionUUID->"8c690d38-2922-44be-afbb-14cd45674f6a"],
Cell[110507, 2751, 2817, 66, 246, "Output",ExpressionUUID->"96a58033-2d72-4f16-b315-9a8bdd147e8e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113361, 2822, 678, 19, 52, "Input",ExpressionUUID->"61565391-260c-4234-b732-b06abcfe551a"],
Cell[114042, 2843, 2248, 67, 119, "Output",ExpressionUUID->"4be48f55-0e90-415f-94cf-46804175e93d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116327, 2915, 1517, 35, 73, "Input",ExpressionUUID->"18489fa5-18f8-4b90-bc0e-93c03387a03a"],
Cell[117847, 2952, 994, 18, 42, "Message",ExpressionUUID->"81b11f2d-7b38-47f4-9b7b-a98b62770924"],
Cell[118844, 2972, 994, 18, 42, "Message",ExpressionUUID->"bbb23b28-563b-4bc5-afe3-24c30511d050"],
Cell[119841, 2992, 994, 18, 42, "Message",ExpressionUUID->"d2e3698b-7e1b-4bcb-8d13-3fc5d06bda5e"],
Cell[120838, 3012, 953, 17, 24, "Message",ExpressionUUID->"a4b053ba-d7ff-48de-9c2d-8155eb487c57"],
Cell[121794, 3031, 123454, 2080, 241, "Output",ExpressionUUID->"7c1945b5-668d-48cc-af5a-127e6272ab64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[245285, 5116, 3577, 90, 199, "Input",ExpressionUUID->"eebf182f-a45d-4d33-8689-2bcab4aa5f74"],
Cell[248865, 5208, 22473, 526, 240, "Output",ExpressionUUID->"7dbad42e-27de-4ec2-8b0d-f5898bf21599"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271375, 5739, 784, 22, 52, "Input",ExpressionUUID->"e9f73158-45d0-4300-9937-2b992013f3ba"],
Cell[272162, 5763, 2100, 46, 119, "Output",ExpressionUUID->"ecdf4d75-045f-47a8-9262-568d5782286a"]
}, Open  ]],
Cell[274277, 5812, 1006, 28, 52, "Input",ExpressionUUID->"abe358f4-d5e4-4b4a-996d-7ca582699471"],
Cell[CellGroupData[{
Cell[275308, 5844, 4311, 112, 262, "Input",ExpressionUUID->"0803ce38-bad4-445d-828e-d7ca577f1d87"],
Cell[279622, 5958, 51846, 887, 245, "Output",ExpressionUUID->"2a77e53c-acbc-4109-a24e-99f38b177371"]
}, Open  ]]
}
]
*)

