#!/usr/bin/env python3
import sys
import ome
import mrdr
import render
import config

srcDir = '../%s/' % sys.argv[1]
print('Creating projections for %s' % sys.argv[1])
omeFile = ome.master(srcDir)
(redFrames,greenFrames,redStill,greenStill,originalVolume) = render.spin(omeFile,config.dx,config.spins,config.headDir)
mrdr.savemat('../results/%s-spin.mat' % sys.argv[1],{'redFrames':redFrames,'greenFrames':greenFrames,'originalVolume':originalVolume})
mrdr.savemat('../results/%s-still.mat' % sys.argv[1],{'redFrames':redStill,'greenFrames':greenStill,'originalVolume':originalVolume})
