#!/usr/bin/env python3
import sys
import ome
import mrdr
import numpy
import config
import scipy.io as io

bweight = 4*config.r
inputs = sys.argv[1:]
if len(inputs)>1:
    print('Linked tracking: %s' % ' -> '.join(inputs))

for n,imageRun in enumerate(inputs):
    print('Tracking %s' % imageRun)
    omeFile = ome.master('../%s' % imageRun)
    priorTracks = []
    priorVecs = numpy.eye(3)
    if n>0:
        priorTracks = mrdr.load('../results/%s_tracks%i.pkl' % (inputs[n-1],config.pmax))
        priorVecs = priorTracks[-1]['vecs']

    tracks = mrdr.phaseOne(omeFile,config.r,config.dx,1.5*config.pmax,config.pad,config.napier,None,priorVecs)
    traces = mrdr.phaseTwo(tracks,config.dx,config.pmax,None,bweight,config.headDir,0,priorTracks)
    activity = mrdr.phaseThree(omeFile,traces,config.dx,config.r,1.2*config.r)

    mrdr.save('../results/%s_tracks%i.pkl' % (imageRun,config.pmax),tracks)
    mrdr.save('../results/%s_traces%i.pkl' % (imageRun,config.pmax),traces)
    mrdr.save('../results/%s_activity%i.pkl' % (imageRun,config.pmax),activity)
    io.savemat('../results/%s_data%i.mat' % (imageRun,config.pmax),{'tracks':tracks,'traces':traces,'activity':activity})
