% To plot the force velocity behavior of actin Arp2/3 branched cortex

close all

input_file = 'Examples_Dynamic/Bud_Eq_F0_0_12_Flatten.mat';
load(input_file)

% Normalizing length (in m)
L_0 = 1e-8;

% Normalizing Energy (in N-m)
E_0 = 20*1.38e-23*300;

% Normalizing Force (in N)
F_0 = E_0/L_0; 

% Normalizing Pressure
P_0 = F_0/L_0^2;

% Time Scale (in seconds)
t_0 = 3e-2/Material.mu/(20*300*1.38);


% Read velocity pressure curve from the experimental data
VP_exp = csvread('PV_Dataset_Fletcher_Cell2016.csv');

% Area of the patch over which actin exerts pressure 
A_actin = 1250e-18/L_0^2; % in nm^2/L^2

V_exp = VP_exp(:,2)'.*1e-6/60/L_0*t_0; P_exp = VP_exp(:,1)'./P_0;
F_exp = P_exp.*A_actin*F_0;



% Stalling force for actin network based on simulations
F_Stall = 1.82e-12/F_0;
P_Stall = F_Stall/A_actin;


P = linspace(0,2*P_Stall,20);
F = linspace(0,4*F_exp(end),20);
v0_t = 9e-3;
d_f = 20;
v_t = v0_t.*(exp(-d_f.*F./F_0) - exp(-d_f*F_Stall));



% Comparison of F-V curves between model and experimental data
figure
grid on
plot(F_exp/1e-12,1e4*V_exp,'--ro','Markersize',6,'LineWidth',3)
hold on
plot(F/1e-12,1e4*v_t,'--bv','MarkerSize',6,'LineWidth',3)
xlabel('Force (in pN)','FontSize',20,'FontWeight','bold','Color','k')
ylabel('Velocity (in nm/s)','FontSize',20,'FontWeight','bold','Color','k')
set (gca,'fontsize',20);
%print(ofile,'-dpng','-r300')


