function Energy = total_Energy(Aux,C,phi,d_phi,Inv)
global Invariant Material Constraints

if(nargin < 5)
    Inv=Invariant;
end

if(nargin==3)
    d_phi=zeros(size(phi));
    Lmd=0;
else
    Lmd = Material.Lmd;
end

if(isfield(Constraints,'f0'))
    f0 = Constraints.f0;
else
    f0 = 0;
end

if(isfield(Constraints,'f0z'))
    f0z = Constraints.f0z;
else
    f0z = 0;
end

if(isfield(Material,'phi_max'))
    tmp = (Material.k0/2* Aux.HmC02 + Material.RT_a0* (phi.*log(phi/Material.phi_max) + ...
   (Material.phi_max-phi).*log((Material.phi_max-phi)/Material.phi_max))...
+ Material.Chi/2 * phi.^2) .* C(:,1) .* Aux.au .* Inv.gweight;
else
    tmp = (Material.k0/2* Aux.HmC02 + Material.RT_a0* phi.* ( log(phi/Material.phi_bar) - 1)...
  + Material.Chi/2 * phi.^2) .* C(:,1) .* Aux.au .* Inv.gweight;
end

tmp = tmp + Lmd/2*d_phi.^2./Aux.au.* C(:,1).* Inv.gweight;
Energy = 2*pi*sum(tmp) - pi*f0*C(end,1)^2 - pi*f0z*C(1,2)^2;

