function plot_configuration(C_s, phi_s, r_s, V_s, psi_s,map_magenta,map_blue)
global Invariant ini_Val Material



scale = 10;

n_theta = 200;
theta_surf = [0:1*pi/n_theta:1*pi] - pi/2;
x = C_s(:,1) * cos(theta_surf);
y = C_s(:,1) * sin(theta_surf);
z_temps = C_s(:,2);
z = repmat(z_temps,1,n_theta+1);
C = repmat(phi_s,1,n_theta+1);
C(C>3.5) = 3.5;
C(1) = 3.5;

s = surf(x*scale,y*scale,z*scale,C)
hold on
shading interp;
s.EdgeColor = 'none';
colormap(map_magenta)
%colormap bone
freezeColors


ss = colorbar
set(ss,'LineWidth',2)

return

cbfreeze(colorbar)






n_theta = 200;
theta_surf = [0:2*pi/n_theta:2*pi];% - pi/2;
x = r_s' * cos(theta_surf);
y = r_s' * sin(theta_surf);
z_temps = r_s'*0;
z = repmat(z_temps,1,n_theta+1);
C = repmat(psi_s,1,n_theta+1);
C(C>0.8) = 0.8;
C(1) = 0.8;

s_ = surf(x*scale,y*scale,z*scale,C)
hold on
shading interp;
s_.EdgeColor = 'none';
colormap(map_blue)
%colormap pink
ss_ = colorbar('west')
set(ss_,'LineWidth',2)
caxis([0 0.8])

n_theta = 40;
theta_surf = [0:2*pi/n_theta:2*pi];% - pi/2;
x = r_s' * cos(theta_surf);
y = r_s' * sin(theta_surf);
z_temps = r_s'*0;
z = repmat(z_temps,1,n_theta+1);
vx = V_s * cos(theta_surf);
vy = V_s * sin(theta_surf);
vz_temps = V_s*0;
vz = repmat(z_temps,1,n_theta+1);

step = 70;
v_factor = 1700;
%quiver3(x(1:step:end,:)*scale, y(1:step:end,:)*scale, z(1:step:end,:)*scale, ...
%    v_factor*vx(1:step:end,:), v_factor*vy(1:step:end,:), v_factor*vz(1:step:end,:), 'k','LineWidth',1,'AutoScale','off')


xx = reshape(x(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
yy = reshape(y(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
zz = reshape(z(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
vxx = reshape(vx(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
vyy = reshape(vy(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
vzz = reshape(vz(1:step:end,:),size(x(1:step:end,:),1)*size(x(1:step:end,:),2),1);
xT=[xx yy zz];
vT=[vxx vyy vzz];

xT = xT*scale;
vT = vT*v_factor;
xTT = xT + vT;

vNorm = sqrt(xTT(:,1).^2 + xTT(:,2).^2 ) *0.001 ;
%vNorm = sqrt(vT(:,1).^2 + vT(:,2).^2 + vT(:,3).^2) *0.01 ;
%vNorm = sqrt(vT(:,1).^2 + vT(:,2).^2 ) *0.01 ;

%hcones= arrow3(xT ,xTT, 'k', vNorm , vNorm'*3);
%quiver3D(xT, vT, [0.9 0.9 0.9], 0.);
quiver3D(xT, vT, [0.2 0.2 0.2], 0.);

