clear all
close all
addpath Functionals:Interpolation_Geometry:Reparametrization:Input_Files:Matrices:quiver3D_pub

% Load the output file generated after running the Main_Script
load('Output_Files/Bud_Evolved_Branched_Actin.mat')

load cmaps.mat;

% Plotting time evolution 
figure(990)
plot(time(2:end),max_phi_hist)
xlabel('time')
ylabel('maxphi')
figure(991)
plot(time(2:end),max_psi_hist)
xlabel('time')
ylabel('maxpsi')
figure(992)
plot(time,Areal_Strain,'--ro','Markersize',4,'LineWidth',2)
xlabel('time')
ylabel('Normalized excess area')



figg=figure(999)
plot(time/1000,Areal_Strain,'Color',map_magenta(1,:),'LineWidth',2)
hold on
plot(time(2:end)/1000,max_psi_hist,'Color',map_blue(1,:),'LineWidth',2)
legend('Normalized excess area', 'Max \psi')
axis([0 120, -0.05 1.2])
set(gca,'FontName','times')
set(gca,'FontSize',20)
set(gca,'LineWidth',1)
%print(figg,'DN_6_Evol_Exp.png','-dpng','-r300')


return


%%
% Plotting shape, protein concentration at any given time instant

i = 500; % Specify the index for which you want to genenrate the shape i=1 corresponds to initial time
time(i)
C_s(:,1) = C_s_hist(:,2*i-1);
C_s(:,2) = C_s_hist(:,2*i  );
phi_s = phi_s_hist(:,i);

[V_s] = interpolate_func_2(Invariant_sample,V_hist(:,i));
[psi_s] = interpolate_func_2(Invariant_sample,C_psi_hist(:,i));
r_s = Invariant_sample.gaussp * Material.R0;


fig = figure;
plot_configuration(C_s, phi_s/Material.phi_bar,r_s, V_s, psi_s,map_magenta,map_blue)

light('position',[1/sqrt(2) -1/sqrt(2) 1])
axis equal
view(-40,16)
axis off

filename = ['NB_5_snapshot_' num2str(i,'%03d') '.png' ];

%print(fig,filename,'-dpng','-r300')

