function [error, x_rep] = error_param(u,nn,p,C,CP,iopen)
global Constraints
 
Invariant_u = precal_generic(u);
Matrix = zeros(nn);
b1 = zeros(nn,1);
b2 = zeros(nn,1);
Nshape = Invariant_u.Nshape;
spv = Invariant_u.spv;
for i=1:length(u)
    k=1:(p+1);
    kk=(spv(i)+k-1);
    Matrix(kk,kk)= Matrix(kk,kk) + Nshape(i,:)'*Nshape(i,:);
    b1(kk) = b1(kk) + C(i,1)*Nshape(i,:)';
    b2(kk) = b2(kk) + C(i,2)*Nshape(i,:)';
end
if iopen == 1
    L1=zeros(size(Matrix,1),6);
    L1(1,1)=1;
    L1(2,2)=1;
    L1(3,3)=1;
    L1(end-2,4)=1;
    L1(end-1,5)=1;
    L1(end,6)=1;
    %L1(end,4)=1;
    %L1(end-1,4)=-1;
    b1=[b1 ; CP(1);CP(3);CP(5); CP(end-5); CP(end-3); CP(end-1)];
    Matrix_=[Matrix L1; L1' zeros(6)];
    x_reparam=Matrix_\b1;
    x_reparam(end-5:end)=[];
    %    x_reparam=Matrix\b1;
    %elseif isfield(Constraints,'vert_slide_nodes')
    %    naux = length(Constraints.vert_slide_nodes);
    %    L1=zeros(size(Matrix,1),2 + naux);
    %    L1(1,1)=1;
    %    L1(end,2)=1;
    %    for i = 1:naux
    %        L1(Constraints.vert_slide_nodes(i),2+i)=1;
    %    end
    %    b1=[b1 ; zeros(2,1); CP(2*Constraints.vert_slide_nodes-1)];
    %    Matrix_=[Matrix L1; L1' zeros(2+ naux)];
    %    x_reparam=Matrix_\b1;
    %    x_reparam(end-(2+naux)+1:end)=[];
elseif iopen == 2
    L1 = zeros(size(Matrix,1),1);
    L1(1,1) = 1;
    b1=[b1 ; zeros(1,1)];
    Matrix_=[Matrix L1; L1' zeros(1)];
    x_reparam=Matrix_\b1;
    x_reparam(end)=[];
elseif iopen == 3 % For open patch of membrane with R(0) = 0
    L1 = zeros(size(Matrix,1),1);
    L1(1,1) = 1;
    b1 = [b1 ; 0];
    Matrix_ = [Matrix L1; L1' zeros(1)];
    x_reparam=Matrix_\b1;
    x_reparam(end)=[];
elseif iopen == 4 % For closed vesicle with end point fixed
    L1=zeros(size(Matrix,1),2);
    L1(1,1)=1;
    L1(end,2)=1;
    b1=[b1 ; zeros(2,1)];
    Matrix_=[Matrix L1; L1' zeros(2)];
    x_reparam=Matrix_\b1;
    x_reparam(end-1:end)=[];
elseif iopen == 6 % For open patch of membrane with R(0)=0 and R(end) fixed
    L1=zeros(size(Matrix,1),2);
    L1(1,1)=1;
    L1(end,2)=1;
    b1=[b1 ; 0; CP(end-1)];
    Matrix_=[Matrix L1; L1' zeros(2)];
    x_reparam=Matrix_\b1;
    x_reparam(end-1:end)=[];
elseif iopen == 7 % For open patch of membrane with height at pole fixed
    L1=zeros(size(Matrix,1),2);
    L1(1,1)=1;
    L1(end,2)=1;
    b1=[b1 ; 0; CP(end-1)];
    Matrix_=[Matrix L1; L1' zeros(2)];
    x_reparam=Matrix_\b1;
    x_reparam(end-1:end)=[];
elseif iopen == 8 % For support bilayer    
    L1 = zeros(size(Matrix,1),1);
    L1(1,1) = 1;
    b1 = [b1 ; 0];
    Matrix_ = [Matrix L1; L1' zeros(1)];
    x_reparam=Matrix_\b1;
    x_reparam(end)=[];
elseif iopen == 9 % For support bilayer without volume constraint
    L1 = zeros(size(Matrix,1),1);
    L1(1,1) = 1;
    b1 = [b1 ; 0];
    Matrix_ = [Matrix L1; L1' zeros(1)];
    x_reparam=Matrix_\b1;
    x_reparam(end)=[];
elseif iopen == 10 % For support bilayer with volume constraint
        L1 = zeros(size(Matrix,1),1);
    L1(1,1) = 1;
    b1 = [b1 ; 0];
    Matrix_ = [Matrix L1; L1' zeros(1)];
    x_reparam=Matrix_\b1;
    x_reparam(end)=[];
%     L1 = zeros(size(Matrix,1),2);
%     L1(1,1) = 1;
%     L1(end,2)=1;
%      b1=[b1 ; 0; CP(end-1)];
%     Matrix_=[Matrix L1; L1' zeros(2)];
%     x_reparam=Matrix_\b1;
%     x_reparam(end-1:end)=[];
else
    L1=zeros(size(Matrix,1),2);
    L1(1,1)=1;
    L1(end,2)=1;
    b1=[b1 ; zeros(2,1)];
    Matrix_=[Matrix L1; L1' zeros(2)];
    x_reparam=Matrix_\b1;
    x_reparam(end-1:end)=[];
end
 
 
L2=zeros(size(Matrix,1),2);
if iopen == 1
    L2(1,1)=1;
    L2(end,2)=1;
    b2=[b2 ; CP(2); CP(end)];
    Matrix_=[Matrix L2; L2' zeros(2)];
    y_reparam=Matrix_\b2;
    y_reparam(end-1:end)=[];
elseif iopen == 2
    L2 = zeros(size(Matrix,1),1);
    L2(1,1)=1;
    L2(2,1)=-1;
    b2=[b2 ; zeros(1,1)];
    Matrix_=[Matrix L2; L2' zeros(1)];
    y_reparam=Matrix_\b2;
    y_reparam(end)=[];
     
elseif iopen ==3
    L2 = zeros(size(Matrix,1),2);
    L2(1,1) = 1;
    L2(2,1) = -1;

    L2((length(L2)-1),2) = 1;
    L2((length(L2)),2) = -1;
     
     
    b2 = [b2 ; zeros(2,1)];
    Matrix_=[Matrix L2; L2' zeros(2)];
    y_reparam=Matrix_\b2;
    y_reparam(end-1:end)=[];
     
    % elseif iopen ==3
    %     L2 = zeros(size(Matrix,1),4);
    %     L2(1,1) = 1;
    %     L2(2,1) = -1;
    %
    %     L2((length(L2)-2),2) = 1;
    %     L2((length(L2)-1),2) = -2;
    %     L2((length(L2)),2) = 1;
    %
    %     L2((length(L2)-1),3) = 1;
    %     L2((length(L2)),3) = -1;
    %
    %     L2((length(L2)),4) = 1;
    %
    %
    %     b2 = [b2 ; zeros(4,1)];
    %     Matrix_=[Matrix L2; L2' zeros(4)];
    %     y_reparam=Matrix_\b2;
    %     y_reparam(end-3:end)=[];
     
elseif iopen ==4 % For closed vesicle with end point fixed
    L2=zeros(size(Matrix,1),3);
    L2(1,1)=1;
    L2(2,1)=-1;
    L2(end-1,2)=1;
    L2(end,2)= -1;
    L2(end,3)= 1;
    b2=[b2 ; zeros(1,1); 0;CP(end)];
    Matrix_=[Matrix L2; L2' zeros(3)];
    y_reparam=Matrix_\b2;
    y_reparam(end-2:end)=[];
     
elseif iopen == 5 % Open patch with H=0 at the boundary
    L2 = zeros(size(Matrix,1),4);
    L2(1,1) = 1;
    L2(2,1) = -1;
    L2((length(L2)),2) = 1;
     
    L2((length(L2)-1),3) = 1;
    L2((length(L2)),3) = -1;
     
    L2((length(L2)-2),4) = 1;
    L2((length(L2)-1),4) = -1;
     
    b2 = [b2 ; zeros(4,1)];
    Matrix_=[Matrix L2; L2' zeros(4)];
    y_reparam=Matrix_\b2;
    y_reparam(end-3:end)=[];
     
elseif iopen ==6
    L2 = zeros(size(Matrix,1),3);
    L2(1,1) = 1;
    L2(2,1) = -1;
    L2((length(L2)),2) = 1;
     
    L2((length(L2)-1),3) = 1;
    L2((length(L2)),3) = -1;
     
     
    b2 = [b2 ; zeros(3,1)];
    Matrix_=[Matrix L2; L2' zeros(3)];
    y_reparam=Matrix_\b2;
    y_reparam(end-2:end)=[];
     
elseif iopen == 7 %Height fixed of starting point
    L2 = zeros(size(Matrix,1),4);
    L2(1,1) = 1;
    L2(2,1) = -1;
    L2((length(L2)),2) = 1;
    L2((length(L2)-1),3) = 1;
    L2((length(L2)),3) = -1;
    L2(1,4) = 1;
    b2 = [b2 ;  zeros(3,1); CP(2) ];
    Matrix_=[Matrix L2; L2' zeros(4)];
    y_reparam=Matrix_\b2;
    y_reparam(end-3:end)=[];
     
elseif iopen ==8 % For support bilayer
    L2 = zeros(size(Matrix,1),2);
    L2(1,1) = 1;
    L2(2,1) = -1;
    L2((length(L2)-1),2) = 1;
    L2((length(L2)),2) = -1;
    b2 = [b2 ;  zeros(2,1);];
    Matrix_=[Matrix L2; L2' zeros(2)];
    y_reparam=Matrix_\b2;
    y_reparam(end-1:end)=[];
elseif iopen ==9 % For support bilayer with height fixed at r=0
    L2 = zeros(size(Matrix,1),3);
    L2(1,1) = 1;
    L2(2,1) = -1;
    L2((length(L2)-1),2) = 1;
    L2((length(L2)),2) = -1;
    L2(1,3) = 1;
    b2 = [b2 ; zeros(2,1); CP(2);];
    Matrix_=[Matrix L2; L2' zeros(3)];
    y_reparam=Matrix_\b2;
    y_reparam(end-2:end)=[];
elseif iopen ==10 % For support bilayer with height fixed at r=end
    L2 = zeros(size(Matrix,1),3);
    L2(1,1) = 1;
    L2(2,1) = -1;
     
    L2((length(L2)-1),2) = 1;
    L2((length(L2)),2) = -1;
    L2((length(L2)),3) = 1; 
     
    b2 = [b2 ; zeros(1,1)  ; zeros(1,1); CP(end)];
    Matrix_=[Matrix L2; L2' zeros(3)];
    y_reparam=Matrix_\b2;
    y_reparam(end-2:end)=[];
else
    L2(1,1)=1;
    L2(2,1)=-1;
    L2(end,2)=1;
    L2(end-1,2)=-1;
    b2=[b2 ; zeros(2,1)];
    Matrix_=[Matrix L2; L2' zeros(2)];
    y_reparam=Matrix_\b2;
    y_reparam(end-1:end)=[];
end
 
x_rep=zeros(2*length(x_reparam),1);
x_rep(1:2:end)=x_reparam;
x_rep(2:2:end)=y_reparam;
 
 
[C_,C1_,C2_] = interpolate(Invariant_u,x_rep);
 
error = sum((C(:,1)-C_(:,1)).^2) + sum((C(:,2)-C_(:,2)).^2);