function [C_fit,phi_fit] = original_shape_to_fit(x,C_phi) % at points uniformly spaced by arclength
global ini_Val Invariant

if nargin==1
    C_phi=ones(ini_Val.ncontrol,1);
end



%Initialization
nn=ini_Val.ncontrol;
N=(nn-1)*20; % 120
gaussp=linspace(0,1,N);
n_sample_fit=(nn-1)*16; % 100
Invariant_sample_bis = precal_generic(gaussp); 


[C,C1,C2] = interpolate(Invariant_sample_bis,x);
%au = zeros(ngp_total,1);
%calculating the constants and surface properties at gauss point
au = (C1(:,1).^2 + C1(:,2).^2);
au = sqrt(au);

arclength=zeros(size(gaussp));
arclength(1)=0;
for i=2:length(au)
    arclength(i)=arclength(i-1) + (au(i-1)+au(i))/2*Invariant_sample_bis.gweight;
end

arcl_equi=linspace(0,arclength(end),n_sample_fit);

u_arcl_equi(1)=0;
for i=2:n_sample_fit-1
    [val, index]=min(abs(arclength-arcl_equi(i)));
    if arclength(index)>arcl_equi(i)
        index=index-1;
    end
    u_arcl_equi(i)=(arcl_equi(i)*(gaussp(index+1)-gaussp(index)) + ...
        gaussp(index)*arclength(index+1) - gaussp(index+1)*arclength(index)) ...
        / (arclength(index+1)-arclength(index));
    
end

%Original shape
u_arcl_equi(n_sample_fit)=1;

Invariant_u_arcl_equi = precal_generic(u_arcl_equi); 
[C_fit,C1,C2] = interpolate(Invariant_u_arcl_equi,x);
[phi_fit d_phi] = interpolate_func_2(Invariant_u_arcl_equi,C_phi);

% 
% figure
% plot(gaussp,au,'ko')
% figure
% plot(gaussp,arclength,'ro-')
% hold on
% for i=1:n_sample_fit
%  plot([u_arcl_equi(i) u_arcl_equi(i) ],[0 arcl_equi(i)],'gs-')
%  plot([0 u_arcl_equi(i) ],[arcl_equi(i) arcl_equi(i)],'gs-')
% end   