function [C,C_eq,dC,g] = Nonlin_constr(x)
global Invariant ini_Val Material Constraints ALG
 
if isfield(ini_Val,'iopen')
    iopen = ini_Val.iopen;
else
    iopen = 0;
end
  
if isfield(Constraints,'iSurf_loc')
    iSurf_loc = Constraints.iSurf_loc;
else
   iSurf_loc = 0;
end

if isfield(Constraints,'iVol_s')
    iVol_s = Constraints.iVol_s;
else
    iVol_s = 0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%Initialization
if (iopen ~= 3 && iopen ~= 6 && iopen ~=7 && iopen ~=9)
    V0=Constraints.V0;
end
 
if (iVol_s)
    V0 = Constraints.V0;
end

if (iSurf_loc)
    S0=Constraints.S0;
else
    S0=pi*(Material.R0^2);
end


C0=Constraints.C0;
p = ini_Val.p;
 
 
[C,C1,C2]=interpolate(Invariant,x);
Aux = auxiliary_calculations(Invariant,p,C0,C,C1,C2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Volume: vesicle 

if (iopen ~= 3 && iopen ~= 6 && iopen ~=7 && iopen ~= 8 && iopen ~=9 && iopen ~=10)
    [tV,dV_dCP] = Volume_functional(Aux);
    dV_dCP=reshape(dV_dCP,length(x),1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Volume: open membrane with support

if (iVol_s)
    [tV,dV_dCP] = Volume_functional_support(Aux);
    %[tV,dV_dCP] = Volume_functional(Aux);
    dV_dCP=reshape(dV_dCP,length(x),1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% local area constraints

if Constraints.iSurf_loc == 1
    [S_L,dS_L_dCP] = localArea_functional(Aux);
    
     % without volume constraints
    if (iopen == 3 || iopen == 6 || iopen == 7 || iVol_s == 0)
        g = [dS_L_dCP'];
        C_eq = [(S_L-Constraints.S0_L)];
        
    elseif (iopen==8 || iopen==10)
        g=[dV_dCP,dS_L_dCP'];
        C_eq = [(tV-V0); (S_L-Constraints.S0_L)];
        
    else  % with volume constraints
        g=[dV_dCP,dS_L_dCP'];
        C_eq = [(tV-V0); (S_L-Constraints.S0_L)];
    end
% area constraints 
else  
    [tS,dS_dCP] = Area_functional(Aux);
    dS_dCP=reshape(dS_dCP,length(x),1);
    
    if (iopen == 3 || iopen == 6 || iopen == 7 || iVol_s == 0)
        g=[dS_dCP];
        C_eq = [(tS-S0)];
        
    elseif (iopen==8 || iopen==10)
        g=[dV_dCP];
        C_eq = [(tV-V0)];
        
    else
        g=[dV_dCP,dS_dCP];
        C_eq = [(tV-V0); (tS-S0)];
        
    end
end

C=[];
dC=[];