function [gpoint,gweight]=gaquad(gaussno);
%
% Computes the N Legendre-Gauss nodes and weights on the interval
% [-1,1] 
%
% If the number of gauss points is > 100, use iterated 
% trapezoidal rule. 
%
% Written by Greg von Winckel - 02/25/2004
% Modified by Luca Heltai - 03/21/2011
%
if gaussno > 100;
    gweight = ones(gaussno);
    gpoint = [-1:(2/(gaussno-1)):1];
else
    N=gaussno-1;
    N1=gaussno; N2=N+2;
    
    xu=linspace(-1,1,N1)';
    
    % Initial guess
    y=-cos((2*(0:N)'+1)*pi/(2*N+2))+(0.27/N1)*sin(pi*xu*N/N2);
    
    % Legendre-Gauss Vandermonde Matrix
    L=zeros(N1,N2);
    
    % Derivative of LGVM
    Lp=zeros(N1,N2);
    
    % Compute the zeros of the N+1 Legendre Polynomial
    % using the recursion relation and the Newton-Raphson method
    
    y0=2;
    
    % Iterate until new points are uniformly within epsilon of old points
    while max(abs(y-y0))>eps
        
        
        L(:,1)=1;
        Lp(:,1)=0;
        
        L(:,2)=y;
        Lp(:,2)=1;
        
        for k=2:N1
            L(:,k+1)=( (2*k-1)*y.*L(:,k)-(k-1)*L(:,k-1) )/k;
        end
     
        Lp=(N2)*( L(:,N1)-y.*L(:,N2) )./(1-y.^2);   
        
        y0=y;
        y=y0-L(:,N2)./Lp;
        
    end
    
    gpoint=y;
    
    % Compute the weights
    gweight=2./((1-y.^2).*Lp.^2)*(N2/N1)^2;
end
