##### LOAD LIBRARIES #####

import sys
sys.path.append('../ssr_benchmark/')
import dtpy_ccm_legacy as ccm
import numpy as np
import pandas as pd
import os

##### PREPARE OUTFOLDER #####
outfolder = 'randomized_failure_mode'
if not os.path.exists(outfolder):
    os.makedirs(outfolder)

##### GENERATE DATA FROM TOY MODEL #####

job_idx = 1
np.random.seed(job_idx)

results = {'r0' : [],
           'r1' : [],
           'axy' : [],
           'ayx' : [],
           'ic0' : [],
           'ic1' : [],
           'tp_star' : [],
           'xmax' : [],
           'ymax' : [],
           'xmin' : [],
           'ymin' : []}

lib_size = 200
n_trials = 250

for trial in range(n_trials):
    done_yet = False
    while not done_yet:
        r0 = np.random.uniform(3.7, 3.9)
        r1 = np.random.uniform(3.1, 3.3)
        axy = np.random.uniform(0.15, 0.2)
        ayx = np.random.uniform(0.15, 0.2)
        ic0 = np.random.uniform(0.01, 0.99)
        ic1 = np.random.uniform(0.01, 0.99)

        def nextstate(x):                       # dynamics equations
            xprime = np.zeros(2)
            xprime[0] = x[0] * (r0 - r0 * x[0] - axy * x[1])
            xprime[1] = x[1] * (r1 - r1 * x[1] - ayx * x[0])
            return xprime

        x0 = np.array([ic0, ic1])               # initial condition
        n_steps = 3000                           # number of steps
        x = np.zeros([n_steps, 2])
        x[0,:] = x0
        for i in range(1,n_steps):
            x[i,:] = nextstate(x[i-1,:])
        if (not np.any(np.isinf(x))) and (not np.any(np.isnan(x))):
            # explosions to infinity are bad
            done_yet = True

    ##### CCM: CROSS MAP SKILL VERSUS PREDICTION HORIZON ######
    prediction_horizons = np.arange(-8,9)
    AxB = ccm.run_ccm(data=x, max_tau=1, min_E=2, max_E=2,
                      lib=(101, 2000), pred=(2001,3000),
                      min_lib_size=lib_size, max_lib_size=lib_size,
                      lib_size_step=1, num_samples=1,
                      remove_temp_files=True,
                      prediction_horizon=prediction_horizons,
                      temp_folder=f'failure_mode_tmp{job_idx}', seed=trial+1)
    #AxB.to_csv('y_drives_x_2.csv')
    tp_star = prediction_horizons[np.argmax(AxB.rho.values)]

    ##### RECORD OPTIMAL PREDICTION HORIZON ######
    results['r0'].append(r0)
    results['r1'].append(r1)
    results['axy'].append(axy)
    results['ayx'].append(ayx)
    results['ic0'].append(ic0)
    results['ic1'].append(ic1)
    results['tp_star'].append(tp_star)
    results['xmax'].append(np.max(x[:,0]))
    results['ymax'].append(np.max(x[:,1]))
    results['xmin'].append(np.min(x[:,0]))
    results['ymin'].append(np.min(x[:,1]))

df = pd.DataFrame.from_dict(results)
df.to_csv(os.path.join(outfolder,f'data{job_idx}.csv'))
