# same as ebitest_rw.R but for the AR(1) data
library(rEDM)
x = read.csv('raw/ar_xdata.csv', header=FALSE)
y = read.csv('raw/ar_ydata.csv', header=FALSE)
n_surr = 499
# test for significance of pearson correlation using random phase surrogates
pvalues <- matrix(ncol=1, nrow=ncol(x))
for(idx in 1:ncol(x)){
  rho = cor(x[,idx],y[,idx])
  y_surr = make_surrogate_data(y[,idx], "ebisuzaki", n_surr)
  rho_null = cor(x[,idx],y_surr)
  pval = (sum(abs(rho_null) >= abs(rho)) + 1) / (length(rho_null) + 1)
  pvalues[idx] <- pval
}
pvalues <- data.frame(pvalues)
write.csv(pvalues, 'raw/ar_ebitest.csv')
