function p = permtest(x,y,n_perm)
% compute p-value for Pearson correlation
% using a permutation test
rho_obs = pcorr(x,y);
RHO_ = zeros(n_perm,1);
for i = 1 : n_perm
    y_ = randsample(y, length(y), false);
    RHO_(i) = pcorr(x, y_);
end
p = (sum(abs(RHO_) >= abs(rho_obs)) + 1) / (n_perm + 1);
end