
#### Dependencies:

Matlab code was run in Matlab R2018B, except for the MVGC analysis, which was run on a computer cluster that was equipped with Matlab R2019A. Most of the remaining code is written in Python (version 3.7). The Python code uses standard scientific computing libraries (numpy, pandas, scipy). Tests involving convergent cross mapping or surrogate data used the package rEDM in R (R version 4.0.2). We used rEDM version 1.5 for figures 2 & 7 in the main text and version 0.7.2 for Appendix 4 figures 4-6 since we found it easier to produce distinct training/testing splits in version 0.7.2.

Tests involving Granger causality used the MVGC package (version 1.0).

We used computers running MacOS and Linux.

#### Running the code:

For some figures, the simulation can be reproduced by just running the corresponding Matlab file. The following figures require multiple steps to reproduce:

Main text figure 2:
  * Run `random_walk_correlation/random_walk.m` in Matlab to make the random walk datasets and perform the permuation tests. Then run `ebitest_rw.R` in R to perform the random phase tests.
  * Run `random_walk_correlation/stationary_ar.m` in Matlab to make the random walk datasets and perform the permuation tests. Then run `ebitest_ar.R` in R to perform the random phase tests.

Main text figure 4:
  * Run the Matlab program `oscillators.m` from inside the `ssr_noise` folder.

Main text figure 5:
  * Run the Matlab programs `failure_modes.m` and `integer_mult.m` from inside the `ssr_failure_modes` folder

Main text figure 7:
  * From the `ssr_benchmark` folder run the `benchmark.py` file using Python. Different arguments
    give different behaviors. For the "standard CCM analysis" with one or two drivers run:

    ```python3 benchmark.py $JOBIDX onedriver ebisuzaki```
    or
    ```python3 benchmark.py $JOBIDX twodrivers ebisuzaki```

    except replace `$JOBIDX` with an integer. This will run 10 trials of each noise condition, using the `$JOBIDX` value to produce random number generator seeds for each trial. This allows for very simple parallelization. To use the "alternate CCM analysis", run:

    ```python3 benchmark.py $JOBIDX twodrivers ebisuzaki 1 1 altstats```

    (replacing `twodrivers` with `onedriver` for the one-driver case). To run 10 trials of the Granger causality analysis, run:

    ```python3 benchmark.py $JOBIDX twodrivers granger```

    (replacing `twodrivers` with `onedriver` for the one-driver case). There is some setup required for the Granger causality analysis. See the section **figure 7 notes** below.

Appendix 4 figure 2:
  * run the Matlab program `takens.m` inside the `Takens` folder.

Appendix 4 figure 3:
  * run the Matlab program `continuous_nonrev.m` inside the `continuous_nonrev` folder.

Appendix 4 figure 4:
  * Run `lib_construction/make_datasets.m` in Matlab to make the datasets. Then run `lib_construction/run_ccm.py` in Python (e.g. by calling `python3 run_ccm.py` from inside the `lib_constrution` directory) to perform the CCM tests. The program `plot_data.m` in the same folder makes the plots
  of CCM results.

Appendix 4 figure 5:
  * Run `prediction_lag/prediction_lag.m` in Matlab to make the datasets. Then run `prediction_lag/run_ccm.py` in Python (e.g. by calling `python3 run_ccm.py` from inside the `prediction_lag` directory) to perform the CCM tests. The file `plot_data.m` plots the CCM results. The results are categorized by as systems 1 through 6. Their correspondence to the rows of the figure is as follows:
    * sys 1 : row 1
    * sys 2 : row 3
    * sys 3 : row 4
    * sys 4 : row 5
    * sys 5 : row 2
    * sys 6 : row 6

Appendix 4 figure 6:
  * From inside the  `more_prediction_lag` folder, run

    ```python3 randomized_working.py```

    and

    ```python3 randomized_failure_mode.py```

    to run the simulations. The file `make_plots.py` makes some boxplots.

### Figure 7 notes:

The file `ssr_benchmark/mvgc.py` will need to be adjusted for your setup if you run the Granger causality simulation.
    * you may need to modify lines 38 and 54.
    * The filepath in line 38 should be the folder where your MVGC distribution is installed.
    * In line 54, the filepath `/Applications/MATLAB_R2018b.app/bin/matlab` should be replaced with whatever you use to call matlab from the command line. It is currently set up for a Mac with a Matlab distribution in the Applications folder, but on Linux, I can replace the filepath with simply `matlab`.
