%% style
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
rng(5)

%% oscillations with integer multiples
tau = 300;

omega1 = 1;
omega2 = 5;

xprime = @(x) [x(2), -(omega1)^2*x(1)];
xprime2 = @(x) [x(2), -(omega2)^2*x(1)];
xprime_all = @(x) [xprime(x(1:2)), xprime2(x(3:4))];

% numerical integration
tspan = (0 : 0.003 : 14);
y0 = ones(1,4);
opts = odeset('RelTol',1e-7,'AbsTol',1e-7);
[t,states] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
x = states(:,1);
y = states(:,3);
%%
fig3_5 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plot(t,x, t, y)
xlim([0,14])
xticks([0,7,14])
xlabel('time')
%saveas(fig3_5,'fig3_5.svg')
%%
idx = 2 : round(length(x) * 0.55);
idx = idx(randperm(length(idx)));
fig4 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plotit(y,x,tau, idx)
c = colorbar;
c.Ticks = [0,1];
c.TickLabels = {'min', 'max'};
%title('Delay space of Y')
xlabel('Y(t - \tau)')
ylabel('Y(t)')
set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig4,'raw/fig4.svg')
%%
fig5 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plotit(x,y,tau, idx)
c = colorbar;
c.Ticks = [0,1];
c.TickLabels = {'min', 'max'};
%title('Delay space of X')
xlabel('X(t - \tau)')
ylabel('X(t)')
set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig5,'raw/fig5.svg')
len = max(idx) + tau;
csvwrite('data/system2.csv', [x, y])
csvwrite('data/time2.csv', t)
%%
function plotit(x,y,tau,idx)
n_colors = 100;
y_ = (y-min(y));
y_ = round(y_ / max(y_) * (n_colors-1) + 1);
h = colormap(gray(n_colors));
for i = idx
    plot(x(i-1:i+1), x(i-1+tau:i+1+tau), 'LineWidth', 10, 'color', h(y_(i+tau),:))
    hold on
end
end